/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.GameMode;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.tabs.InfoEquipping;
import pcgen.gui.tabs.InfoGear;
import pcgen.gui.tabs.InfoNaturalWeapons;
import pcgen.gui.tabs.InfoResources;
import pcgen.gui.tabs.InfoTempMod;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoInventory
extends JTabbedPane
implements Filterable,
CharacterInfoTab {
    static final long serialVersionUID = -4186874622211290063L;
    private static final Tab tab = Tab.INVENTORY;
    private InfoEquipping equipment;
    private InfoGear gear;
    private InfoNaturalWeapons naturalWeapons;
    private InfoResources resources;
    private InfoTempMod tempmod;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoInventory(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.equipment = new InfoEquipping(playerCharacter);
        this.gear = new InfoGear(playerCharacter);
        this.resources = new InfoResources(playerCharacter);
        this.tempmod = new InfoTempMod(playerCharacter);
        this.setName(tab.toString());
        this.initComponents();
        this.initActionListeners();
        InfoGear.setNeedsUpdate(true);
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Inventory.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Inventory.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.gear.getToDos());
        arrayList.addAll(this.equipment.getToDos());
        arrayList.addAll(this.resources.getToDos());
        arrayList.addAll(this.tempmod.getToDos());
        if (SettingsHandler.showNaturalWeaponTab()) {
            arrayList.addAll(this.naturalWeapons.getToDos());
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            InfoInventory.setNeedsUpdate(true);
            this.gear.setPc(this.pc);
            this.equipment.setPc(this.pc);
            this.resources.setPc(this.pc);
            this.tempmod.setPc(this.pc);
            if (SettingsHandler.showNaturalWeaponTab()) {
                this.naturalWeapons.forceRefresh();
            }
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    InfoTempMod getTempModPane() {
        return this.tempmod;
    }

    @Override
    public List<PObjectFilter> getAvailableFilters() {
        return this.gear.getAvailableFilters();
    }

    @Override
    public void setFilterMode(int n) {
        if (this.getSelectedIndex() == Tab.GEAR.index()) {
            this.gear.setFilterMode(n);
        }
    }

    @Override
    public int getFilterMode() {
        if (this.getSelectedIndex() == Tab.GEAR.index()) {
            return this.gear.getFilterMode();
        }
        return 0;
    }

    public InfoGear getInfoGear() {
        return this.gear;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        if (this.getSelectedIndex() == Tab.GEAR.index()) {
            return this.gear.isMatchAnyEnabled();
        }
        return false;
    }

    public static void setNeedsUpdate(boolean bl) {
        InfoGear.setNeedsUpdate(bl);
        InfoEquipping.setNeedsUpdate(bl);
        InfoResources.setNeedsUpdate(bl);
        InfoTempMod.setNeedsUpdate(bl);
        if (SettingsHandler.showNaturalWeaponTab()) {
            InfoNaturalWeapons.setNeedsUpdate(bl);
        }
    }

    @Override
    public boolean isNegateEnabled() {
        if (this.getSelectedIndex() == Tab.GEAR.index()) {
            return this.gear.isNegateEnabled();
        }
        return false;
    }

    @Override
    public List<PObjectFilter> getRemovedFilters() {
        return this.gear.getRemovedFilters();
    }

    @Override
    public List<PObjectFilter> getSelectedFilters() {
        return this.gear.getSelectedFilters();
    }

    @Override
    public int getSelectionMode() {
        if (this.getSelectedIndex() == Tab.GEAR.index()) {
            return this.gear.getSelectionMode();
        }
        return -2;
    }

    @Override
    public void initializeFilters() {
        this.gear.initializeFilters();
    }

    @Override
    public void refreshFiltering() {
        this.gear.refreshFiltering();
    }

    private void initActionListeners() {
        this.gear.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.equipment.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.resources.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.tempmod.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ComponentEvent componentEvent2 = new ComponentEvent(InfoInventory.this.getSelectedComponent(), 102);
                PToolBar.getCurrentInstance().getComponentListener().componentShown(componentEvent2);
                InfoInventory.this.refresh();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (InfoInventory.this.getSelectedIndex() == Tab.GEAR.index()) {
                    InfoGear.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == Tab.EQUIPPING.index()) {
                    InfoEquipping.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == Tab.RESOURCES.index()) {
                    InfoResources.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == Tab.TEMPBONUS.index()) {
                    InfoTempMod.setNeedsUpdate(true);
                }
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.add((Component)this.gear, Tab.GEAR.index());
        this.setTitleAt(Tab.GEAR.index(), PropertyFactory.getString("in_Info" + this.gear.getName()));
        this.add((Component)this.equipment, Tab.EQUIPPING.index());
        this.setTitleAt(Tab.EQUIPPING.index(), PropertyFactory.getString("in_Info" + this.equipment.getName()));
        this.add((Component)this.resources, Tab.RESOURCES.index());
        this.setTitleAt(Tab.RESOURCES.index(), PropertyFactory.getString("in_Info" + this.resources.getName()));
        this.add((Component)this.tempmod, Tab.TEMPBONUS.index());
        this.setTitleAt(Tab.TEMPBONUS.index(), PropertyFactory.getString("in_Info" + this.tempmod.getName()));
        if (SettingsHandler.showNaturalWeaponTab()) {
            this.naturalWeapons = new InfoNaturalWeapons(this.pc);
            this.add((Component)this.naturalWeapons, Tab.NATWEAPONS.index());
            this.setTitleAt(Tab.NATWEAPONS.index(), PropertyFactory.getString("in_Info" + this.naturalWeapons.getName()));
        }
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoInventory.this.refresh();
            }
        });
    }

    @Override
    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        int n = this.getSelectedIndex();
        if (n == Tab.GEAR.index()) {
            return this.gear.accept(playerCharacter, pObject);
        }
        if (n == Tab.EQUIPPING.index()) {
            return this.equipment.accept(playerCharacter, pObject);
        }
        if (n == Tab.RESOURCES.index()) {
            return this.resources.accept(playerCharacter, pObject);
        }
        if (n == Tab.TEMPBONUS.index()) {
            return this.tempmod.accept(playerCharacter, pObject);
        }
        return false;
    }
}

