/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.spells;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.spells.InfoSpellsSubTab;
import pcgen.gui.tabs.spells.SpellModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoSpellBooks
extends InfoSpellsSubTab {
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("InfoSpellBooks.sort.avail.spells.by"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("InfoSpellBooks.sort.select.spells.by"));
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addSpellButton;
    private JButton delSpellButton;
    private JTextField spellBookNameText = new JTextField();
    private JComboBoxEx primaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx primaryViewSelectComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewSelectComboBox = new JComboBoxEx();
    private JComboBoxEx selectFromComboBox = new JComboBoxEx();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private boolean hasBeenSized = false;
    private int selectFromMode = 0;

    public InfoSpellBooks(PlayerCharacter playerCharacter) {
        super(playerCharacter, Tab.SPELLBOOKS);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoSpellBooks.this.initComponents();
                InfoSpellBooks.this.initActionListeners();
            }
        });
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Spells.Books.Order", Tab.KNOWN_SPELLS.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Spells.Books.Order", n);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    protected void updateCharacterInfo() {
        this.lastClass = "";
        if (this.pc == null || !this.needsUpdate) {
            return;
        }
        this.pc.getSpellList();
        this.updateBookList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.classLabel.setText("");
        this.needsUpdate = false;
    }

    @Override
    protected void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoSpellBooks.splitPane", (int)(this.getSize().getWidth() * 3.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoSpellBooks.bsplit", (int)(this.getSize().getHeight() - 150.0));
            n3 = SettingsHandler.getPCGenOption("InfoSpellBooks.asplit", (int)(this.getSize().getWidth() - 400.0));
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "SpellSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "SpellAva", n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoSpellBooks.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoSpellBooks.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoSpellBooks.asplit", n3);
        }
    }

    @Override
    protected void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoSpellBooks.this.formComponentShown();
            }
        });
        this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoSpellBooks.this.hasBeenSized && (n = InfoSpellBooks.this.splitPane.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoSpellBooks.splitPane", n);
                }
            }
        });
        this.bsplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoSpellBooks.this.hasBeenSized && (n = InfoSpellBooks.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoSpellBooks.bsplit", n);
                }
            }
        });
        this.asplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoSpellBooks.this.hasBeenSized && (n = InfoSpellBooks.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoSpellBooks.asplit", n);
                }
            }
        });
        this.addSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.addSpellButton();
            }
        });
        this.delSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.delSpellButton();
            }
        });
        this.primaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.primaryViewComboBoxActionPerformed(InfoSpellBooks.this.primaryViewComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.secondaryViewComboBoxActionPerformed(InfoSpellBooks.this.secondaryViewComboBox.getSelectedIndex());
            }
        });
        this.primaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.primaryViewSelectComboBoxActionPerformed(InfoSpellBooks.this.primaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.secondaryViewSelectComboBoxActionPerformed(InfoSpellBooks.this.secondaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.selectFromComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellBooks.this.selectFromComboBoxActionPerformed(InfoSpellBooks.this.selectFromComboBox.getSelectedIndex());
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    protected void initComponents() {
        this.readyForRefresh = true;
        this.updateBookList();
        this.sanityCheckAvailableSpellMode(SettingsHandler.getSpellsTab_AvailableListMode());
        SettingsHandler.setSpellsTab_AvailableListMode(this.primaryViewMode);
        this.sanityCheckSelectedSpellMode(SettingsHandler.getSpellsTab_SelectedListMode());
        SettingsHandler.setSpellsTab_SelectedListMode(this.primaryViewSelectMode);
        this.populateViewCombo(this.primaryViewComboBox, this.primaryViewMode, false);
        Utility.setDescription(this.primaryViewComboBox, PropertyFactory.getString("InfoSpells.change.how.spell.are.listed"));
        this.populateViewCombo(this.secondaryViewComboBox, this.secondaryViewMode, true);
        this.populateViewCombo(this.primaryViewSelectComboBox, this.primaryViewSelectMode, false);
        Utility.setDescription(this.primaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        this.populateViewCombo(this.secondaryViewSelectComboBox, this.secondaryViewSelectMode, true);
        Utility.setDescription(this.secondaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        this.selectFromComboBox.addItem(PropertyFactory.getString("InfoSpellBooks.select.known"));
        this.selectFromComboBox.addItem(PropertyFactory.getString("InfoSpellBooks.select.own.list"));
        this.selectFromComboBox.setSelectedIndex(0);
        ImageIcon imageIcon = IconUtilitities.getImageIcon("Forward16.gif");
        this.addSpellButton = new JButton(imageIcon);
        imageIcon = IconUtilitities.getImageIcon("Back16.gif");
        this.delSpellButton = new JButton(imageIcon);
        this.createModels();
        this.createTreeTables();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PropertyFactory.getString("InfoSpellBooks.School"));
        arrayList.add(PropertyFactory.getString("InfoSpellBooks.Descriptor"));
        arrayList.add(PropertyFactory.getString("InfoSpellBooks.SourceFile"));
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        arrayList2.add(Boolean.TRUE);
        arrayList2.add(Boolean.TRUE);
        arrayList2.add(Boolean.TRUE);
        this.buildTopPanel();
        this.initBottomPanel();
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoSpellBooks.this.refresh();
            }
        });
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(this.splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 1));
        jPanel4.add(new JLabel(PropertyFactory.getString("InfoSpellBooks.select.from")));
        jPanel4.add(this.selectFromComboBox);
        jPanel3.add((Component)jPanel4, "North");
        jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 1));
        jPanel4.add(this.avaLabel);
        jPanel4.add(this.primaryViewComboBox);
        jPanel4.add(this.secondaryViewComboBox);
        jPanel3.add((Component)jPanel4, "South");
        Utility.setDescription(jPanel3, PropertyFactory.getString("InfoSpells.rightclick.add.to.spellbooks"));
        jPanel.add((Component)jPanel3, "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)this.buildModSpellPanel(this.addSpellButton, "InfoSpells.add.selected"), "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 1));
        jPanel5.add(this.selLabel);
        jPanel5.add(this.primaryViewSelectComboBox);
        jPanel5.add(this.secondaryViewSelectComboBox);
        jPanel2.add((Component)jPanel5, "North");
        jScrollPane = new JScrollPane(this.selectedTable, 22, 30);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.selectedTable.setAutoResizeMode(0);
        this.selectedTable.setShowHorizontalLines(true);
        jPanel2.add((Component)jScrollPane, "Center");
        JButton jButton2 = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)this.buildModSpellPanel(this.delSpellButton, "InfoSpells.remove.selected"), "South");
    }

    private JPanel buildModSpellPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, PropertyFactory.getString(string));
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private void initBottomPanel() {
        this.botPane.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel2.setLayout(gridBagLayout);
        this.asplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 10);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.spell.info"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        jPanel.add(jScrollPane);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 13);
        JScrollPane jScrollPane2 = new JScrollPane();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.class.info"));
        titledBorder2.setTitleJustification(2);
        jScrollPane2.setBorder(titledBorder2);
        this.classLabel.setBackground(this.topPane.getBackground());
        jScrollPane2.setViewportView(this.classLabel);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel2.add(jScrollPane2);
    }

    @Override
    protected void updateBookList() {
        this.availableBookList.clear();
        this.availableBookList.add(Globals.getDefaultSpellBook());
        this.selectedBookList.clear();
        for (String string : this.pc.getSpellBooks()) {
            SpellBook spellBook = this.pc.getSpellBookByName(string);
            if (spellBook.getType() != 3 || this.selectedBookList.contains(string)) continue;
            this.selectedBookList.add(string);
        }
    }

    @Override
    protected void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SpellModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, this.selectFromMode, this.pc, this, "");
        } else {
            this.availableModel.resetModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, this.selectFromMode, this, "");
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SpellModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this.pc, this, PropertyFactory.getString("InfoSpellBooks.no.selected.help"));
        } else {
            this.selectedModel.resetModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this, PropertyFactory.getString("InfoSpellBooks.no.selected.help"));
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void setSelectedSpell(PObjectNode pObjectNode, boolean bl) {
        if (pObjectNode == null) {
            this.lastSpell = null;
            this.infoLabel.setText();
            return;
        }
        if (pObjectNode.getItem() instanceof SpellInfo) {
            CharacterSpell characterSpell = ((SpellInfo)pObjectNode.getItem()).getOwner();
            if (characterSpell.getSpell() != null) {
                if (bl) {
                    this.addSpellButton.setEnabled(true);
                    this.addMenu.setEnabled(true);
                } else {
                    this.delSpellButton.setEnabled(true);
                    this.delSpellMenu.setEnabled(true);
                }
                this.setInfoLabelText((SpellInfo)pObjectNode.getItem());
            }
        } else {
            if (bl) {
                this.addSpellButton.setEnabled(false);
                this.addMenu.setEnabled(false);
            } else {
                this.delSpellButton.setEnabled(false);
                this.delSpellMenu.setEnabled(false);
            }
            if (pObjectNode.getItem() instanceof SpellBook) {
                SpellBook spellBook = (SpellBook)pObjectNode.getItem();
                if (!bl) {
                    this.spellBookNameText.setText(spellBook.getName());
                    this.setInfoLabelText(spellBook);
                }
            }
        }
    }

    @Override
    protected void addSpellButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        String string = treePath == null ? "" : this.getBookName((PObjectNode)treePath.getPathComponent(1));
        if (string.length() <= 0 || this.pc.getSpellBookByName(string) == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.first.select.spellbook"), "PCGen", MessageType.ERROR);
            return;
        }
        if (this.primaryViewMode != 0 && this.secondaryViewMode != 0 || this.primaryViewMode != 1 && this.secondaryViewMode != 1) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
            return;
        }
        this.currSpellBook = string;
        TreePath[] treePathArray = this.availableTable.getTree().getSelectionPaths();
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            Object object = treePathArray[i].getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            this.addSpellToTarget(pObjectNode, string);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    @Override
    protected void setAutoBookButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        String string = treePath == null ? "" : this.getBookName((PObjectNode)treePath.getPathComponent(1));
        if (string.length() <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.first.select.spellbook"), "PCGen", MessageType.ERROR);
            return;
        }
        if (string.equals(this.pc.getSpellBookNameToAutoAddKnown())) {
            this.pc.setSpellBookNameToAutoAddKnown("");
        } else {
            this.pc.setSpellBookNameToAutoAddKnown(string);
        }
    }

    String getBookName(PObjectNode pObjectNode) {
        String string;
        if (pObjectNode.getItem() instanceof SpellBook) {
            SpellBook spellBook = (SpellBook)pObjectNode.getItem();
            string = spellBook.getName();
        } else {
            string = String.valueOf(pObjectNode.getItem());
        }
        return string;
    }

    @Override
    protected void delSpellButton() {
        TreePath[] treePathArray = this.selectedTable.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            TreePath treePath = treePathArray[i];
            Object object = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            List<Object> list = this.getInfoFromNode(pObjectNode);
            CharacterSpell characterSpell = null;
            String string = null;
            if (list != null) {
                characterSpell = (CharacterSpell)list.get(0);
                string = (String)list.get(1);
            }
            if (characterSpell == null) continue;
            String string2 = this.getBookName((PObjectNode)treePath.getPathComponent(1));
            SpellInfo spellInfo = (SpellInfo)pObjectNode.getItem();
            PCClass pCClass = this.pc.getClassKeyed(string);
            if (pCClass == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
                continue;
            }
            this.currSpellBook = string2;
            String string3 = this.pc.delSpell(spellInfo, pCClass, string2 = this.currSpellBook);
            if (string3.length() <= 0) continue;
            ShowMessageDelegate.showMessageDialog(string3, "PCGen", MessageType.ERROR);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void selectFromComboBoxActionPerformed(int n) {
        if (n >= 0 && n <= 2) {
            this.selectFromMode = n;
            this.updateAvailableModel();
        }
    }
}

