/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeTableModel
implements TreeTableModel {
    private final EventListenerList listenerList = new EventListenerList();
    private Object root;
    private String qFilter = null;

    public AbstractTreeTableModel(Object object) {
        this.root = object;
    }

    @Override
    public final int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public final void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public final void fireTreeNodesChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(TreeModelListener.class)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    public final void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public final void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return this.getColumnClass(n).equals(TreeTableModel.class);
    }

    @Override
    public final Object getChild(Object object, int n) {
        return PObjectNode.getChild(object, n);
    }

    @Override
    public final int getChildCount(Object object) {
        return PObjectNode.getChildCount(object);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Object.class;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    public void updateTree() {
        this.fireTreeNodesChanged(this.root, new TreePath(this.root));
    }

    protected final void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(TreeModelListener.class)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public String getQFilter() {
        return this.qFilter;
    }

    public void setQFilter(String string) {
        this.qFilter = string != null ? string.toLowerCase() : null;
    }

    public void clearQFilter() {
        this.qFilter = null;
    }
}

