/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Pantheon;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.gui.filter.Filterable;
import pcgen.gui.utils.PObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoViewModelBuilder {
    private InfoViewModelBuilder() {
    }

    public static PObjectNode buildAlignmentView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Deity> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (Deity deity : collection) {
            PCAlignment pCAlignment;
            if (!filterable.accept(playerCharacter, deity) || (pCAlignment = deity.get(ObjectKey.ALIGNMENT)) == null) continue;
            String string = pCAlignment.getKeyName();
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            pObjectNode2.addChild(new PObjectNode(deity));
        }
        return pObjectNode;
    }

    public static PObjectNode buildDomainView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Deity> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<Domain, PObjectNode> hashMap = new HashMap<Domain, PObjectNode>();
        for (Deity deity : collection) {
            if (!filterable.accept(playerCharacter, deity) || deity.getKeyName().equalsIgnoreCase("NONE")) continue;
            for (CDOMReference cDOMReference : deity.getSafeListMods(Deity.DOMAINLIST)) {
                for (Domain domain : cDOMReference.getContainedObjects()) {
                    PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(domain);
                    if (pObjectNode2 == null) {
                        pObjectNode2 = new PObjectNode(domain);
                        hashMap.put(domain, pObjectNode2);
                        pObjectNode.addChild(pObjectNode2);
                    }
                    pObjectNode2.addChild(new PObjectNode(deity));
                }
            }
        }
        return pObjectNode;
    }

    public static PObjectNode buildPantheonView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Deity> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (Deity deity : collection) {
            if (!filterable.accept(playerCharacter, deity)) continue;
            for (Pantheon pantheon : deity.getSafeListFor(ListKey.PANTHEON)) {
                String string = pantheon.toString();
                PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
                if (pObjectNode2 == null) {
                    pObjectNode2 = new PObjectNode(string);
                    hashMap.put(string, pObjectNode2);
                    pObjectNode.addChild(pObjectNode2);
                }
                pObjectNode2.addChild(new PObjectNode(deity));
            }
        }
        return pObjectNode;
    }

    public static PObjectNode buildNameView(Filterable filterable, PlayerCharacter playerCharacter, Collection<? extends PObject> collection, String string) {
        PObjectNode pObjectNode = new PObjectNode();
        for (PObject pObject : collection) {
            if (!filterable.accept(playerCharacter, pObject) || string != null && pObject.getDisplayName().toLowerCase().indexOf(string) < 0 && pObject.getType().toLowerCase().indexOf(string) < 0) continue;
            pObjectNode.addChild(new PObjectNode(pObject));
        }
        return pObjectNode;
    }

    public static PObjectNode buildAllRaceTypesView(Filterable filterable, PlayerCharacter playerCharacter) {
        return InfoViewModelBuilder.buildAllRaceTypesView(filterable, playerCharacter, Globals.getContext().ref.getConstructedCDOMObjects(Race.class));
    }

    public static PObjectNode buildAllRaceTypesView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Race> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (Race race : collection) {
            if (!filterable.accept(playerCharacter, race)) continue;
            RaceType raceType = race.get(ObjectKey.RACETYPE);
            String string = raceType == null ? "" : raceType.toString();
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            for (Type type : race.getTrueTypeList(true)) {
                String string2 = type.toString();
                PObjectNode pObjectNode3 = (PObjectNode)hashMap.get(string2);
                if (pObjectNode3 == null) {
                    pObjectNode3 = new PObjectNode(string2);
                    hashMap.put(string2, pObjectNode3);
                    pObjectNode.addChild(pObjectNode3);
                }
                pObjectNode3.addChild(new PObjectNode(race));
            }
            pObjectNode2.addChild(new PObjectNode(race));
        }
        return pObjectNode;
    }

    public static PObjectNode buildRaceTypeView(Filterable filterable, PlayerCharacter playerCharacter) {
        return InfoViewModelBuilder.buildRaceTypeView(filterable, playerCharacter, Globals.getContext().ref.getConstructedCDOMObjects(Race.class));
    }

    public static PObjectNode buildRaceTypeView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Race> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (Race race : collection) {
            if (!filterable.accept(playerCharacter, race)) continue;
            RaceType raceType = race.get(ObjectKey.RACETYPE);
            String string = raceType == null ? "" : raceType.toString();
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            pObjectNode2.addChild(new PObjectNode(race));
        }
        return pObjectNode;
    }

    public static PObjectNode buildRaceTypeSubTypeView(Filterable filterable, PlayerCharacter playerCharacter) {
        return InfoViewModelBuilder.buildRaceTypeSubTypeView(filterable, playerCharacter, Globals.getContext().ref.getConstructedCDOMObjects(Race.class));
    }

    public static PObjectNode buildRaceTypeSubTypeView(Filterable filterable, PlayerCharacter playerCharacter, Collection<Race> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (Race race : collection) {
            List<RaceSubType> list;
            if (!filterable.accept(playerCharacter, race)) continue;
            RaceType raceType = race.get(ObjectKey.RACETYPE);
            String string = raceType == null ? "" : raceType.toString();
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            if ((list = race.getListFor(ListKey.RACESUBTYPE)) != null) {
                for (RaceSubType raceSubType : list) {
                    String string2 = string + ":" + raceSubType;
                    PObjectNode pObjectNode3 = (PObjectNode)hashMap.get(string2);
                    if (pObjectNode3 == null) {
                        pObjectNode3 = new PObjectNode(raceSubType);
                        hashMap.put(string2, pObjectNode3);
                        pObjectNode2.addChild(pObjectNode3);
                    }
                    pObjectNode3.addChild(new PObjectNode(race));
                }
                continue;
            }
            pObjectNode2.addChild(new PObjectNode(race));
        }
        return pObjectNode;
    }

    public static PObjectNode buildTypeView(Filterable filterable, PlayerCharacter playerCharacter, Collection<? extends PObject> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (PObject pObject : collection) {
            if (!filterable.accept(playerCharacter, pObject)) continue;
            String string = pObject.getType();
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            pObjectNode2.addChild(new PObjectNode(pObject));
        }
        return pObjectNode;
    }

    public static PObjectNode buildSourceView(Filterable filterable, PlayerCharacter playerCharacter, Collection<? extends PObject> collection) {
        PObjectNode pObjectNode = new PObjectNode();
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (PObject pObject : collection) {
            String string;
            if (!filterable.accept(playerCharacter, pObject) || (string = SourceFormat.getFormattedString(pObject, SourceFormat.LONG, false)).length() == 0) continue;
            PObjectNode pObjectNode2 = (PObjectNode)hashMap.get(string);
            if (pObjectNode2 == null) {
                pObjectNode2 = new PObjectNode(string);
                hashMap.put(string, pObjectNode2);
                pObjectNode.addChild(pObjectNode2);
            }
            pObjectNode2.addChild(new PObjectNode(pObject));
        }
        return pObjectNode;
    }
}

