/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import pcgen.util.Logging;

public final class LabelTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static final Color SelectedBackgroundColor = Color.white;
    private static Map<String, Font> fontMap = new HashMap<String, Font>();
    private Color myColor = Color.white;

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Font font;
        String string;
        Font font2 = this.getFont();
        String string2 = font2.getName();
        int n2 = font2.getSize();
        try {
            string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        }
        catch (Exception exception) {
            string = "";
            Logging.errorPrint("problem converting in treecellrenderer", exception);
        }
        if (string.length() > 1 && string.charAt(1) == '|') {
            if (string.charAt(0) == 'B') {
                string = string.substring(2, string.length());
                font = LabelTreeCellRenderer.getFontFromMap(string2, 1, n2);
                this.setFont(font);
            } else if (string.charAt(0) == 'I') {
                string = string.substring(2, string.length());
                font = LabelTreeCellRenderer.getFontFromMap(string2, 2, n2);
                this.setFont(font);
            }
        } else {
            font = LabelTreeCellRenderer.getFontFromMap(string2, 0, n2);
            this.setFont(font);
        }
        int n3 = string.indexOf("|");
        int n4 = string.lastIndexOf("|");
        Color color = null;
        if (n3 > -1 && n3 != n4) {
            String string3 = string.substring(n3 + 1, n4);
            try {
                color = new Color(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n3 > -1 && n3 != n4 && color != null) {
            this.myColor = color;
            string = string.substring(0, n3) + string.substring(n4 + 1);
            if (bl) {
                this.setBackground(this.myColor);
                this.setForeground(Color.white);
            } else {
                this.setForeground(this.myColor);
                this.setBackground(Color.white);
            }
        } else if (bl) {
            this.setForeground(Color.white);
            this.setBackground(Color.blue);
        } else {
            this.setForeground(Color.black);
            this.setBackground(Color.white);
        }
        this.setText(string);
        return this;
    }

    private static Font getFontFromMap(String string, int n, int n2) {
        String string2 = LabelTreeCellRenderer.getFontKey(string, n, n2);
        Font font = fontMap.get(string2);
        if (font == null) {
            font = new Font(string, n, n2);
            fontMap.put(string2, font);
        }
        return font;
    }

    private static String getFontKey(String string, int n, int n2) {
        return string + "." + n + "." + n2;
    }
}

