/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.JLabelPane;
import pcgen.util.PropertyFactory;

public final class LinkableHtmlMessage
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -3678273627369325170L;
    private static final String HTML_START = "<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\">";
    private static final String HTML_END = "</body></html>";
    private JButton btnClose;
    private JLabelPane msgText;

    public LinkableHtmlMessage(Frame frame, String string, String string2) {
        super(frame, string2, true);
        this.commonInit(string);
        this.setLocationRelativeTo(frame);
    }

    public LinkableHtmlMessage(Dialog dialog, String string, String string2) {
        super(dialog, string2, true);
        this.commonInit(string);
        this.setLocationRelativeTo(dialog);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.btnClose.grabFocus();
        }
        super.setVisible(bl);
    }

    private void commonInit(String string) {
        this.initUI();
        String string2 = string;
        int n = 0;
        while ((n = string2.indexOf(10, n)) >= 0) {
            string2 = string2.substring(0, n) + "<br>" + string2.substring(n + 1);
        }
        this.msgText.setBackground(this.btnClose.getBackground());
        this.msgText.setText(HTML_START + string2 + HTML_END);
        this.repaint();
        this.pack();
    }

    private void initUI() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        container.add((Component)new JLabel(icon), gridBagConstraints);
        this.msgText = new JLabelPane();
        this.msgText.setBorder(null);
        this.msgText.addHyperlinkListener(new Hyperactive());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add(this.msgText);
        this.btnClose = new JButton(PropertyFactory.getString("in_ok"));
        this.btnClose.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.btnClose.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.btnClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LinkableHtmlMessage.this.quit();
            }
        });
        this.btnClose.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) {
                    LinkableHtmlMessage.this.quit();
                }
            }
        });
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }
}

