/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserRadio;

public final class SwingChooserRadio
extends JDialog
implements ChooserRadio {
    static final long serialVersionUID = -2156072283857697398L;
    private static String in_ok;
    private static String in_cancel;
    private ButtonGroup avaGroup = null;
    private JComboBoxEx cmbCombo;
    private final JPanel avaPane = new JPanel();
    private JButton cancelButton;
    private JButton okButton;
    private JLabelPane mMessageText;
    private JRadioButton lblCombo;
    private List mAvailableList = new ArrayList();
    private List mSelectedList = new ArrayList();
    private JRadioButton[] avaRadioButton = null;

    public SwingChooserRadio() {
        super(Globals.getRootFrame());
        this.initComponents();
    }

    public void setAvailableList(List list) {
        this.mAvailableList = list;
    }

    public void setComboData(String string, List list) {
        this.cmbCombo = new JComboBoxEx(list.toArray());
        ((DefaultComboBoxModel)this.cmbCombo.getModel()).insertElementAt("(None)", 0);
        this.cmbCombo.setSelectedIndex(0);
        this.cmbCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && SwingChooserRadio.this.cmbCombo.getSelectedIndex() > 0) {
                    SwingChooserRadio.this.lblCombo.setSelected(true);
                }
            }
        });
        this.lblCombo = new JRadioButton(string);
        this.lblCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!SwingChooserRadio.this.lblCombo.isSelected()) {
                    SwingChooserRadio.this.cmbCombo.setSelectedIndex(0);
                } else if (SwingChooserRadio.this.cmbCombo.getSelectedIndex() == 0) {
                    SwingChooserRadio.this.cmbCombo.setSelectedIndex(1);
                }
            }
        });
    }

    public void setMessageText(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "<html>&nbsp;</html>";
        }
        this.mMessageText.setText(string);
    }

    public ArrayList getSelectedList() {
        return new ArrayList(this.mSelectedList);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateAvailableTable();
            this.setLocationRelativeTo(this.getOwner());
            super.pack();
            this.pack();
            if (this.getWidth() < 120) {
                this.setSize(120, this.getHeight());
            }
        }
        super.setVisible(bl);
    }

    private void setData(List list) {
        int n = 0;
        this.avaRadioButton = new JRadioButton[list.size()];
        this.avaGroup = new ButtonGroup();
        for (String string : list) {
            if (string.length() <= 0) continue;
            this.avaRadioButton[n] = new JRadioButton(string, false);
            this.avaGroup.add(this.avaRadioButton[n]);
            ++n;
        }
        if (n > 0) {
            this.avaRadioButton[0].setSelected(true);
        }
        if (this.lblCombo != null) {
            this.avaGroup.add(this.lblCombo);
        }
    }

    private void close() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.setModal(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "Select One");
        this.avaPane.setBorder(titledBorder);
        this.mMessageText = new JLabelPane();
        this.mMessageText.setBackground(container.getBackground());
        this.setMessageText(null);
        this.okButton = new JButton(in_ok);
        this.cancelButton = new JButton(in_cancel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == SwingChooserRadio.this.okButton) {
                    SwingChooserRadio.this.selectedOK();
                } else if (actionEvent.getSource() == SwingChooserRadio.this.cancelButton) {
                    SwingChooserRadio.this.close();
                }
            }
        };
        this.okButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mMessageText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        container.add((Component)this.avaPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 0.0, 0.0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 1, 2, 3, 1, 0.0, 0.0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.cancelButton, gridBagConstraints);
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    private void selectedOK() {
        Object object = null;
        for (int i = 0; i < this.avaRadioButton.length; ++i) {
            if (!this.avaRadioButton[i].isSelected()) continue;
            object = this.avaRadioButton[i].getText();
            break;
        }
        if (this.lblCombo != null && this.lblCombo.isSelected()) {
            object = this.cmbCombo.getSelectedItem();
        }
        this.mSelectedList.clear();
        if (object != null) {
            this.mSelectedList.add(object);
        }
        this.setVisible(false);
    }

    private void updateAvailableTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.mAvailableList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        this.setData(arrayList);
        int n = this.avaRadioButton.length;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.avaPane.removeAll();
        this.avaPane.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            gridBagConstraints.anchor = 17;
            Utility.buildConstraints(gridBagConstraints, 0, n2, 2, 1, 1.0, 0.0);
            gridBagLayout.setConstraints(this.avaRadioButton[i], gridBagConstraints);
            this.avaPane.add(this.avaRadioButton[i]);
            if (n <= 11 || i >= n - 1) continue;
            gridBagConstraints.anchor = 13;
            Utility.buildConstraints(gridBagConstraints, 3, n2, 2, 1, 1.0, 0.0);
            gridBagLayout.setConstraints(this.avaRadioButton[++i], gridBagConstraints);
            this.avaPane.add(this.avaRadioButton[i]);
        }
        if (this.lblCombo != null) {
            Utility.buildConstraints(gridBagConstraints, 0, n, 3, 1, 0.0, 0.0);
            gridBagLayout.setConstraints(this.lblCombo, gridBagConstraints);
            this.avaPane.add(this.lblCombo);
            Utility.buildConstraints(gridBagConstraints, 0, n + 1, 3, 1, 0.0, 0.0);
            gridBagLayout.setConstraints(this.cmbCombo, gridBagConstraints);
            this.avaPane.add(this.cmbCombo);
        }
    }

    static {
        PropertyFactory.getString("in_available");
        in_ok = PropertyFactory.getString("in_ok");
        in_cancel = PropertyFactory.getString("in_cancel");
    }
}

