/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class Utility {
    public static void setDescription(JComponent jComponent, String string) {
        jComponent.setToolTipText(string);
    }

    public static void setGuiTextInfo(Object object, String string) {
        String string2 = PropertyFactory.getString(string);
        Utility.setTextAndMnemonic(object, string2);
        String string3 = string + "_tip";
        String string4 = PropertyFactory.getString(string3);
        if (string4.length() > 0 && !string4.equals(string3 + " not defined.") && object instanceof JComponent) {
            Utility.setDescription((JComponent)object, string4);
        }
    }

    public static Container getParentNamed(Container container, String string) {
        while (container != null && !container.getClass().getName().equals(string)) {
            container = container.getParent();
        }
        return container;
    }

    public static File getTempPreviewFile(PlayerCharacter playerCharacter, String string) {
        String string2 = string == null || string.equals("") ? SettingsHandler.getSelectedCharacterHTMLOutputSheet(playerCharacter) : string;
        if (string2 == null || string2.trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("No HTML template specified in preferences.", "PCGen", MessageType.ERROR);
            return null;
        }
        String string3 = string2.substring(string2.lastIndexOf(46));
        File file = null;
        try {
            file = File.createTempFile("currentPC", string3, SettingsHandler.getTempPath());
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog("Could not create temporary preview file.", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not create temporary preview file.", iOException);
        }
        return file;
    }

    public static void setTextAndMnemonic(Object object, String string) {
        if (object instanceof JLabel) {
            ((JLabel)object).setText(string);
            return;
        }
        int n = string.length();
        int n2 = 0;
        char c = '\u0000';
        while ((n2 = string.indexOf(38, n2)) >= 0) {
            if (n2 >= n - 1) continue;
            if (string.charAt(n2 + 1) == '&') {
                ++n2;
            } else {
                c = string.charAt(n2 + 1);
            }
            string = string.substring(0, n2) + string.substring(n2 + 1);
            --n;
        }
        if (object instanceof JButton) {
            ((JButton)object).setText(string);
            if (c != '\u0000') {
                ((JButton)object).setMnemonic(c);
            }
        } else if (object instanceof JMenuItem) {
            ((JMenuItem)object).setText(string);
            if (c != '\u0000') {
                ((JMenuItem)object).setMnemonic(c);
            }
        }
    }

    public static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        Utility.buildConstraints(gridBagConstraints, n, n2, n3, n4, d, d2);
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
    }

    public static void buildRelativeConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2, int n3, int n4) {
        Utility.buildConstraints(gridBagConstraints, -1, -1, n, n2, d, d2);
        gridBagConstraints.fill = n3;
        gridBagConstraints.anchor = n4;
    }

    public static void buildRelativeConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2) {
        Utility.buildConstraints(gridBagConstraints, -1, -1, n, n2, d, d2);
    }

    public static void centerDialog(JDialog jDialog) {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Dimension dimension = jDialog.getSize();
        if (dimension.height > rectangle.height) {
            dimension.height = rectangle.height;
        }
        if (dimension.width > rectangle.width) {
            dimension.width = rectangle.width;
        }
        jDialog.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        jDialog.setSize(dimension);
    }

    public static void centerFrame(JFrame jFrame, boolean bl) {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        if (bl) {
            jFrame.setSize(rectangle.width / 2, rectangle.height / 2);
        }
        Dimension dimension = jFrame.getSize();
        if (dimension.height > rectangle.height) {
            dimension.height = rectangle.height;
        }
        if (dimension.width > rectangle.width) {
            dimension.width = rectangle.width;
        }
        jFrame.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
    }

    public static JButton createButton(ActionListener actionListener, String string, String string2, String string3, boolean bl) {
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        if (string != null) {
            jButton.setActionCommand(string);
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(jButton, string2);
        }
        IconUtilitities.maybeSetIcon(jButton, string3);
        jButton.setEnabled(bl);
        return jButton;
    }

    public static JMenu createMenu(String string, String string2, boolean bl) {
        String string3 = PropertyFactory.getString("in_" + string);
        char c = PropertyFactory.getMnemonic("in_mn_" + string);
        String string4 = PropertyFactory.getString("in_" + string + "Tip");
        return Utility.createMenu(string3, c, string4, string2, bl);
    }

    public static JMenu createMenu(String string, char c, String string2, String string3, boolean bl) {
        JMenu jMenu = new JMenu(string);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(jMenu, string2);
        }
        IconUtilitities.maybeSetIcon(jMenu, string3);
        jMenu.setEnabled(bl);
        return jMenu;
    }

    public static JMenuItem createMenuItem(String string, ActionListener actionListener, String string2, String string3, String string4, boolean bl) {
        String string5 = PropertyFactory.getString("in_" + string);
        char c = PropertyFactory.getMnemonic("in_mn_" + string);
        String string6 = PropertyFactory.getString("in_" + string + "Tip");
        return Utility.createMenuItem(string5, actionListener, string2, c, string3, string6, string4, bl);
    }

    public static JMenuItem createMenuItem(String string, ActionListener actionListener, String string2, char c, String string3, String string4, String string5, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        if (string2 != null) {
            jMenuItem.setActionCommand(string2);
        }
        if (c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        if (string3 != null) {
            KeyStroke keyStroke;
            int n = 2;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            String string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("shortcut")) {
                n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            } else if (string6.equalsIgnoreCase("alt")) {
                n = System.getProperty("mrj.version") != null ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 : 8;
            } else if (string6.equalsIgnoreCase("shift-shortcut")) {
                n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1;
            }
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
            }
            if ((keyStroke = KeyStroke.getKeyStroke(string6)) != null) {
                int n2 = keyStroke.getKeyCode();
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, n));
            }
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(jMenuItem, string4);
        }
        IconUtilitities.maybeSetIcon(jMenuItem, string5);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup buttonGroup, String string, ActionListener actionListener, String string2, char c, String string3, String string4, String string5, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        if (actionListener != null) {
            jRadioButtonMenuItem.addActionListener(actionListener);
        }
        if (string2 != null) {
            jRadioButtonMenuItem.setActionCommand(string2);
        }
        if (c != '\u0000') {
            jRadioButtonMenuItem.setMnemonic(c);
        }
        if (string3 != null) {
            jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string3));
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(jRadioButtonMenuItem, string4);
        }
        IconUtilitities.maybeSetIcon(jRadioButtonMenuItem, string5);
        jRadioButtonMenuItem.setEnabled(bl);
        return jRadioButtonMenuItem;
    }

    public static void handleToolTipShownStateChange() {
        ToolTipManager.sharedInstance().setEnabled(SettingsHandler.isToolTipTextShown());
    }

    public static void previewInBrowser(PlayerCharacter playerCharacter) {
        File file = new File(SettingsHandler.getSelectedCharacterHTMLOutputSheet(playerCharacter));
        String string = file.getAbsolutePath();
        Utility.previewInBrowser(string, playerCharacter);
    }

    public static void previewInBrowser(String string, PlayerCharacter playerCharacter) {
        File file = Utility.getTempPreviewFile(playerCharacter, null);
        if (file == null) {
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            Utility.printToWriter(outputStreamWriter, string, playerCharacter);
            outputStreamWriter.close();
            URL uRL = file.toURI().toURL();
            Utility.viewInBrowser(uRL.toString());
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog("Could not preview file in external browser. Sorry...", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not preview file in external browser. Sorry...", exception);
        }
    }

    public static void printToWriter(Writer writer, String string, PlayerCharacter playerCharacter) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException(string + " does not exist!");
        }
        String string2 = file.getName().toLowerCase();
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        if (string2.startsWith("csheet") || string2.startsWith("eqsheet") || string2.endsWith(".xml")) {
            new ExportHandler(file).write(playerCharacter, bufferedWriter);
        } else if (string2.startsWith("psheet")) {
            new ExportHandler(file).write(Globals.getPCList(), bufferedWriter);
        } else {
            throw new IOException(string2 + " is not a valid template file name.");
        }
        bufferedWriter.close();
    }

    public static void selectDefaultBrowser(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Find and select your preferred html browser.");
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jFileChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
        }
        if (SettingsHandler.getBrowserPath() != null) {
            jFileChooser.setCurrentDirectory(new File(SettingsHandler.getBrowserPath()));
        }
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            SettingsHandler.setBrowserPath(file.getAbsolutePath());
        }
    }

    public static String stripHTML(String string) {
        String string2 = string;
        while (string2.indexOf(60) >= 0) {
            string2 = string2.substring(0, string2.indexOf(60)) + string2.substring(string2.indexOf(62) + 1, string2.length());
        }
        return string2;
    }

    public static void viewInBrowser(String string) {
        try {
            String string2 = System.getProperty("os.name");
            if (string2.startsWith("Windows ") && SettingsHandler.getBrowserPath() == null) {
                Utility.selectDefaultBrowser(null);
            }
            if (string2.startsWith("Mac OS")) {
                BrowserLauncher.openURL(string);
            } else {
                BrowserLauncher.openURL(string);
            }
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog("Could not preview file in external browser. Sorry...", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not preview file in external browser. Sorry...", exception);
        }
    }

    public static Dimension getScreenSize(Toolkit toolkit) {
        Dimension dimension = toolkit.getScreenSize();
        if (dimension.getWidth() * 3.0 == dimension.getHeight() * 8.0) {
            dimension.setSize(dimension.getWidth() / 2.0, dimension.getHeight());
        }
        return dimension;
    }

    public static String shortenString(FontMetrics fontMetrics, String string, int n) {
        for (int i = string.length(); i > 0; i -= 5) {
            String string2 = "..." + string.substring(string.length() - i);
            int n2 = fontMetrics.stringWidth(string2);
            if (n2 >= n) continue;
            return string2;
        }
        return "";
    }
}

