/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public abstract class IOHandler {
    public final void read(PlayerCharacter playerCharacter, String string) {
        this.internalRead(playerCharacter, string, true);
    }

    public final void readForPreview(PlayerCharacter playerCharacter, String string) {
        this.internalRead(playerCharacter, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRead(PlayerCharacter playerCharacter, String string, boolean bl) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.read(playerCharacter, fileInputStream, bl);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in IOHandler::read when reading", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Exception in IOHandler::read", iOException);
                }
                catch (NullPointerException nullPointerException) {
                    Logging.errorPrint("Could not create file inputStream IOHandler::read", nullPointerException);
                }
            }
        }
    }

    public final void write(PlayerCharacter playerCharacter, String string) throws IOException, NullPointerException {
        OutputStream outputStream = null;
        File file = null;
        try {
            File file2 = new File(string);
            if (SettingsHandler.getCreatePcgBackup() && file2.exists() && file2.length() > 0L) {
                String string2 = file2.getName();
                File file3 = SettingsHandler.getBackupPcgPath();
                file = !file3.getPath().equals("") ? new File(file3 + File.separator + string2 + ".bak") : new File(string + ".bak");
                if (file.exists()) {
                    file.delete();
                }
                file2.renameTo(file);
            }
            file2 = null;
            outputStream = new FileOutputStream(string);
            this.write(playerCharacter, outputStream);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in IOHandler::write when writing", iOException);
            throw iOException;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Exception in IOHandler::write", iOException);
                    throw iOException;
                }
                catch (NullPointerException nullPointerException) {
                    Logging.errorPrint("Could not create FileOutputStream in IOHandler::write", nullPointerException);
                    throw nullPointerException;
                }
            }
        }
    }

    protected abstract void read(PlayerCharacter var1, InputStream var2, boolean var3);

    protected abstract void write(PlayerCharacter var1, OutputStream var2);
}

