/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.EqModControl;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.core.character.WieldCategory;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.util.PropertyFactory;

public class WeaponhToken
extends WeaponToken {
    public static final String TOKEN_NAME = "WEAPONH";

    public String getTokenName() {
        return TOKEN_NAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        stringTokenizer.nextToken();
        Equipment equipment = WeaponhToken.getWeaponEquipment(playerCharacter);
        if (equipment != null) {
            return this.getWeaponToken(playerCharacter, equipment, stringTokenizer);
        }
        if (exportHandler != null && exportHandler.getExistsOnly()) {
            exportHandler.setNoMoreItems(true);
            if (exportHandler.getCheckBefore()) {
                exportHandler.setCanWrite(false);
            }
        }
        return "";
    }

    public static Equipment getWeaponEquipment(PlayerCharacter playerCharacter) {
        WeaponProf weaponProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, "Unarmed Strike");
        if (weaponProf == null) {
            weaponProf = new WeaponProf();
            weaponProf.setName(PropertyFactory.getString("Equipment.UnarmedStrike"));
            weaponProf.put(StringKey.KEY_NAME, "Unarmed Strike");
            weaponProf.addToListFor(ListKey.TYPE, Type.SIMPLE);
            Globals.getContext().ref.importObject(weaponProf);
        }
        Equipment equipment = new Equipment();
        equipment.setName(PropertyFactory.getString("Equipment.UnarmedStrike"));
        equipment.put(StringKey.KEY_NAME, "KEY_Unarmed Strike");
        equipment.put(ObjectKey.WEAPON_PROF, new CDOMDirectSingleRef<WeaponProf>(weaponProf));
        equipment.put(StringKey.OUTPUT_NAME, PropertyFactory.getString("Equipment.UnarmedStrike"));
        equipment.addType(Type.WEAPON);
        equipment.addType(Type.MELEE);
        equipment.addType(Type.SIMPLE);
        equipment.addType(Type.UNARMED);
        equipment.addType(Type.SUBDUAL);
        equipment.addType(Type.STANDARD);
        equipment.addType(Type.MONK);
        equipment.addType(Type.BLUDGEONING);
        equipment.put(ObjectKey.WIELD, WieldCategory.findByName("Light"));
        equipment.put(ObjectKey.COST, BigDecimal.ZERO);
        equipment.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
        equipment.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
        EquipmentHead equipmentHead = equipment.getEquipmentHead(1);
        equipmentHead.put(StringKey.DAMAGE, "1d1");
        equipmentHead.put(IntegerKey.CRIT_MULT, 2);
        equipmentHead.put(IntegerKey.CRIT_RANGE, 1);
        equipment.put(ObjectKey.MOD_CONTROL, EqModControl.NO);
        String string = playerCharacter.getSize();
        if (string.length() > 1) {
            string = string.toUpperCase().substring(0, 1);
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        equipment.put(ObjectKey.SIZE, sizeAdjustment);
        equipment.put(ObjectKey.BASESIZE, sizeAdjustment);
        return equipment;
    }
}

