/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence;

import java.net.URI;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SystemLoader;
import pcgen.persistence.lst.LstSystemLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistenceManager {
    private static final SystemLoader instance = new LstSystemLoader();
    private static boolean initialized;
    private static final PersistenceManager managerInstance;

    private PersistenceManager() {
    }

    public static PersistenceManager getInstance() {
        return managerInstance;
    }

    public void addObserver(Observer observer) {
        instance.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        instance.deleteObserver(observer);
    }

    public void setChosenCampaignSourcefiles(List<URI> list) {
        instance.setChosenCampaignSourcefiles(list, SettingsHandler.getGame());
    }

    public void setChosenCampaignSourcefiles(List<URI> list, GameMode gameMode) {
        instance.setChosenCampaignSourcefiles(list, gameMode);
    }

    public List<URI> getChosenCampaignSourcefiles() {
        return instance.getChosenCampaignSourcefiles(SettingsHandler.getGame());
    }

    public List<URI> getChosenCampaignSourcefiles(GameMode gameMode) {
        return instance.getChosenCampaignSourcefiles(gameMode);
    }

    public boolean isCustomItemsLoaded() {
        return instance.isCustomItemsLoaded();
    }

    public Set<String> getSources() {
        return instance.getSources();
    }

    public void emptyLists() {
        instance.emptyLists();
    }

    public void initialize() throws PersistenceLayerException {
        if (!initialized) {
            instance.initialize();
            instance.loadModItems(true);
            initialized = true;
        }
    }

    public void loadCampaigns(List<Campaign> list) throws PersistenceLayerException {
        try {
            instance.loadCampaigns(list);
            instance.loadModItems(true);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Globals.emptyLists();
            this.emptyLists();
            for (Campaign campaign : list) {
                campaign.setIsLoaded(false);
            }
            persistenceLayerException.fillInStackTrace();
            throw persistenceLayerException;
        }
    }

    public void refreshCampaigns() {
        instance.refreshCampaigns();
    }

    static {
        managerInstance = new PersistenceManager();
    }
}

