/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.BaseDiceLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public class BaseDiceLoader {
    public static final String BASEDICE = "baseDice";
    public static final String UP = "up";
    public static final String DOWN = "down";

    public void parseLine(GameMode gameMode, String string, URI uRI) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(BASEDICE, "");
        hashMap.put(UP, "");
        hashMap.put(DOWN, "");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(BaseDiceLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            BaseDiceLstToken baseDiceLstToken = (BaseDiceLstToken)map.get(string3);
            if (baseDiceLstToken != null) {
                String string4 = string2.substring(n + 1).trim();
                LstUtils.deprecationCheck(baseDiceLstToken, "Base Dice", uRI, string4);
                if (baseDiceLstToken.parse(hashMap, string4)) continue;
                Logging.errorPrint("Error parsing base dice:miscinfo.lst from the " + gameMode.getName() + " Game Mode" + ':' + string2 + "\"");
                continue;
            }
            Logging.errorPrint("Invalid sub tag " + baseDiceLstToken + " on BASEDICE line");
            throw new PersistenceLayerException("Invalid sub tag " + baseDiceLstToken + " on BASEDICE line");
        }
        if (!gameMode.getDamageUpMap().containsKey(hashMap.get(BASEDICE))) {
            gameMode.getDamageUpMap().put((String)hashMap.get(BASEDICE), (String)hashMap.get(UP));
            gameMode.getDamageDownMap().put((String)hashMap.get(BASEDICE), (String)hashMap.get(DOWN));
        } else {
            Logging.errorPrint("Duplicate BASEDICE: tag on gamemode.");
        }
    }
}

