/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCCheckLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class PCCheckLoader
extends LstLineFileLoader {
    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        PObject pObject = new PObject();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PCCheckLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in check " + pObject.getDisplayName() + " of " + uRI);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in check " + pObject.getDisplayName() + " of " + uRI);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(pObject, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                if (map.containsKey(string4)) {
                    PCCheckLstToken pCCheckLstToken = (PCCheckLstToken)map.get(string4);
                    LstUtils.deprecationCheck(pCCheckLstToken, pObject, string2);
                    if (!pCCheckLstToken.parse(pObject, string2)) {
                        Logging.errorPrint("Error parsing PCCheck " + pObject.getDisplayName() + ':' + uRI.toString() + ':' + string3 + "\"");
                    }
                } else {
                    Logging.replayParsedMessages();
                }
            }
            Logging.clearParseMessages();
        }
    }
}

