/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.StringTokenizer;
import pcgen.core.SizeAdjustment;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SizeAdjustmentLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

final class SizeAdjustmentLoader
extends LstLineFileLoader {
    public void loadLstFile(LoadContext loadContext, URI uRI, String string) throws PersistenceLayerException {
        SystemCollections.getGameModeNamed(string).clearSizeAdjustmentList();
        super.loadLstFile(loadContext, uRI, string);
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        String string2;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        SizeAdjustment sizeAdjustment = new SizeAdjustment();
        if (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n = ((String)object).indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: " + (String)object);
                return;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + (String)object);
                return;
            }
            String string3 = ((String)object).substring(0, n);
            if (!"SIZENAME".equals(string3)) {
                Logging.errorPrint("Expected first token in SizeAdjustment to be SIZENAME");
                return;
            }
            string2 = n == ((String)object).length() - 1 ? null : ((String)object).substring(n + 1);
            sizeAdjustment = SystemCollections.getGameModeNamed(this.getGameMode()).getSizeAdjustmentNamed(string2);
            if (sizeAdjustment == null) {
                sizeAdjustment = new SizeAdjustment();
                sizeAdjustment.setName(string2);
                SystemCollections.getGameModeNamed(this.getGameMode()).addToSizeAdjustmentList(sizeAdjustment);
            }
        }
        object = TokenStore.inst().getTokenMap(SizeAdjustmentLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5 = stringTokenizer.nextToken().trim();
            int n = string5.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: " + string5);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + string5);
                continue;
            }
            string2 = string5.substring(0, n);
            String string6 = string4 = n == string5.length() - 1 ? null : string5.substring(n + 1);
            if (loadContext.processToken(sizeAdjustment, string2, string4)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                if (object.containsKey(string2)) {
                    SizeAdjustmentLstToken sizeAdjustmentLstToken = (SizeAdjustmentLstToken)object.get(string2);
                    LstUtils.deprecationCheck(sizeAdjustmentLstToken, sizeAdjustment, string4);
                    if (!sizeAdjustmentLstToken.parse(sizeAdjustment, string4)) {
                        Logging.errorPrint("Error parsing SizeAdjustment " + sizeAdjustment.getDisplayName() + ':' + uRI.toString() + ':' + string5 + "\"");
                    }
                } else {
                    Logging.replayParsedMessages();
                }
            }
            Logging.clearParseMessages();
        }
    }
}

