/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.ListSet;
import pcgen.base.util.TreeMapToList;
import pcgen.base.util.TripleKeyMap;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.SimpleAssociatedObject;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.core.Globals;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.AssociatedCollectionChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.CollectionChanges;
import pcgen.rules.context.ListChanges;
import pcgen.rules.context.ListCommitStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListContext {
    private final TrackingListCommitStrategy edits = new TrackingListCommitStrategy();

    public URI getSourceURI() {
        return this.edits.getSourceURI();
    }

    public void setSourceURI(URI uRI) {
        this.edits.setSourceURI(uRI);
        this.getCommitStrategy().setSourceURI(uRI);
    }

    public URI getExtractURI() {
        return this.edits.getExtractURI();
    }

    public void setExtractURI(URI uRI) {
        this.edits.setExtractURI(uRI);
        this.getCommitStrategy().setExtractURI(uRI);
    }

    public <T extends CDOMObject> AssociatedPrereqObject addToMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference, T t) {
        return this.edits.addToMasterList(string, cDOMObject, cDOMReference, t);
    }

    public <T extends CDOMObject> void removeFromMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference, T t) {
        this.edits.removeFromMasterList(string, cDOMObject, cDOMReference, t);
    }

    public void clearAllMasterLists(String string, CDOMObject cDOMObject) {
        this.edits.clearAllMasterLists(string, cDOMObject);
    }

    public <T extends CDOMObject> void clearMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
        this.edits.clearMasterList(string, cDOMObject, cDOMReference);
    }

    public <T extends CDOMObject> AssociatedPrereqObject addToList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<? super T>> cDOMReference, CDOMReference<T> cDOMReference2) {
        return this.edits.addToList(string, cDOMObject, cDOMReference, cDOMReference2);
    }

    public <T extends CDOMObject> AssociatedPrereqObject removeFromList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<? super T>> cDOMReference, CDOMReference<T> cDOMReference2) {
        return this.edits.removeFromList(string, cDOMObject, cDOMReference, cDOMReference2);
    }

    public void removeAllFromList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<?>> cDOMReference) {
        this.edits.removeAllFromList(string, cDOMObject, cDOMReference);
    }

    public void commit() {
        Object object;
        Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection22;
        ListCommitStrategy listCommitStrategy = this.getCommitStrategy();
        for (Object object2 : this.edits.positiveMasterMap.getKeySet()) {
            this.commitDirect((CDOMReference)object2);
        }
        for (Object object2 : this.edits.negativeMasterMap.getKeySet()) {
            this.removeDirect((CDOMReference)object2);
        }
        for (Object object2 : this.edits.globalClearSet.getKeySet()) {
            for (Object object3 : this.edits.globalClearSet.getSecondaryKeySet(object2)) {
                for (Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection22 : this.edits.globalClearSet.getListFor(object2, object3)) {
                    listCommitStrategy.removeAllFromList("FOO", (CDOMObject)object3, (CDOMReference<? extends CDOMList<?>>)((Object)collection22));
                }
            }
        }
        for (Object object2 : this.edits.negativeMap.getKeySet()) {
            for (Object object3 : this.edits.negativeMap.getSecondaryKeySet(object2)) {
                object = (CDOMObject)this.edits.negativeMap.get(object2, object3);
                collection22 = ((CDOMObject)object).getModifiedLists();
                for (CDOMReference cDOMReference : collection22) {
                    this.remove((CDOMObject)object3, (CDOMObject)object, cDOMReference);
                }
            }
        }
        for (Object object2 : this.edits.positiveMap.getKeySet()) {
            for (Object object3 : this.edits.positiveMap.getSecondaryKeySet(object2)) {
                object = (CDOMObject)this.edits.positiveMap.get(object2, object3);
                collection22 = ((CDOMObject)object).getModifiedLists();
                for (CDOMReference cDOMReference : collection22) {
                    this.add((CDOMObject)object3, (CDOMObject)object, cDOMReference);
                }
            }
        }
        for (Object object2 : this.edits.masterAllClear.getKeySet()) {
            for (Object object3 : this.edits.masterAllClear.getListFor(object2)) {
                listCommitStrategy.clearAllMasterLists((String)object2, ((OwnerURI)object3).owner);
            }
        }
        this.rollback();
    }

    private <T extends CDOMObject> void commitDirect(CDOMReference<? extends CDOMList<T>> cDOMReference) {
        ListCommitStrategy listCommitStrategy = this.getCommitStrategy();
        for (OwnerURI ownerURI : this.edits.positiveMasterMap.getSecondaryKeySet(cDOMReference)) {
            for (CDOMObject cDOMObject : this.edits.positiveMasterMap.getTertiaryKeySet(cDOMReference, ownerURI)) {
                AssociatedPrereqObject associatedPrereqObject = (AssociatedPrereqObject)this.edits.positiveMasterMap.get(cDOMReference, ownerURI, cDOMObject);
                AssociatedPrereqObject associatedPrereqObject2 = listCommitStrategy.addToMasterList(associatedPrereqObject.getAssociation(AssociationKey.TOKEN), ownerURI.owner, cDOMReference, cDOMObject);
                Collection<AssociationKey<?>> collection = associatedPrereqObject.getAssociationKeys();
                for (AssociationKey<?> associationKey : collection) {
                    this.setAssoc(associatedPrereqObject, associatedPrereqObject2, associationKey);
                }
                associatedPrereqObject2.addAllPrerequisites(associatedPrereqObject.getPrerequisiteList());
            }
        }
    }

    private <T extends CDOMObject> void removeDirect(CDOMReference<? extends CDOMList<T>> cDOMReference) {
        ListCommitStrategy listCommitStrategy = this.getCommitStrategy();
        for (OwnerURI ownerURI : this.edits.negativeMasterMap.getSecondaryKeySet(cDOMReference)) {
            for (CDOMObject cDOMObject : this.edits.negativeMasterMap.getTertiaryKeySet(cDOMReference, ownerURI)) {
                AssociatedPrereqObject associatedPrereqObject = (AssociatedPrereqObject)this.edits.negativeMasterMap.get(cDOMReference, ownerURI, cDOMObject);
                listCommitStrategy.removeFromMasterList(associatedPrereqObject.getAssociation(AssociationKey.TOKEN), ownerURI.owner, cDOMReference, cDOMObject);
            }
        }
    }

    public void rollback() {
        this.edits.decommit();
    }

    public Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> getChangedLists(CDOMObject cDOMObject, Class<? extends CDOMList<?>> clazz) {
        return this.getCommitStrategy().getChangedLists(cDOMObject, clazz);
    }

    public <T extends CDOMObject> AssociatedChanges<CDOMReference<T>> getChangesInList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
        return this.getCommitStrategy().getChangesInList(string, cDOMObject, cDOMReference);
    }

    public <T extends CDOMObject> AssociatedChanges<T> getChangesInMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
        return this.getCommitStrategy().getChangesInMasterList(string, cDOMObject, cDOMReference);
    }

    public Changes<CDOMReference> getMasterListChanges(String string, CDOMObject cDOMObject, Class<? extends CDOMList<?>> clazz) {
        return this.getCommitStrategy().getMasterListChanges(string, cDOMObject, clazz);
    }

    public boolean hasMasterLists() {
        return this.getCommitStrategy().hasMasterLists();
    }

    private <BT extends CDOMObject> void remove(CDOMObject cDOMObject, CDOMObject cDOMObject2, CDOMReference<CDOMList<BT>> cDOMReference) {
        ListCommitStrategy listCommitStrategy = this.getCommitStrategy();
        Collection<CDOMReference<BT>> collection = cDOMObject2.getListMods(cDOMReference);
        for (CDOMReference<BT> cDOMReference2 : collection) {
            for (AssociatedPrereqObject associatedPrereqObject : cDOMObject2.getListAssociations(cDOMReference, cDOMReference2)) {
                String string = associatedPrereqObject.getAssociation(AssociationKey.TOKEN);
                AssociatedPrereqObject associatedPrereqObject2 = listCommitStrategy.removeFromList(string, cDOMObject, cDOMReference, cDOMReference2);
                Collection<AssociationKey<?>> collection2 = associatedPrereqObject.getAssociationKeys();
                for (AssociationKey<?> associationKey : collection2) {
                    this.setAssoc(associatedPrereqObject, associatedPrereqObject2, associationKey);
                }
                associatedPrereqObject2.addAllPrerequisites(associatedPrereqObject.getPrerequisiteList());
            }
        }
    }

    private <BT extends CDOMObject> void add(CDOMObject cDOMObject, CDOMObject cDOMObject2, CDOMReference<CDOMList<BT>> cDOMReference) {
        ListCommitStrategy listCommitStrategy = this.getCommitStrategy();
        Collection<CDOMReference<BT>> collection = cDOMObject2.getListMods(cDOMReference);
        for (CDOMReference<BT> cDOMReference2 : collection) {
            for (AssociatedPrereqObject associatedPrereqObject : cDOMObject2.getListAssociations(cDOMReference, cDOMReference2)) {
                String string = associatedPrereqObject.getAssociation(AssociationKey.TOKEN);
                AssociatedPrereqObject associatedPrereqObject2 = listCommitStrategy.addToList(string, cDOMObject, cDOMReference, cDOMReference2);
                Collection<AssociationKey<?>> collection2 = associatedPrereqObject.getAssociationKeys();
                for (AssociationKey<?> associationKey : collection2) {
                    this.setAssoc(associatedPrereqObject, associatedPrereqObject2, associationKey);
                }
                associatedPrereqObject2.addAllPrerequisites(associatedPrereqObject.getPrerequisiteList());
            }
        }
    }

    private <T> void setAssoc(AssociatedPrereqObject associatedPrereqObject, AssociatedPrereqObject associatedPrereqObject2, AssociationKey<T> associationKey) {
        associatedPrereqObject2.setAssociation(associationKey, associatedPrereqObject.getAssociation(associationKey));
    }

    public boolean masterListsEqual(AbstractListContext abstractListContext) {
        return this.getCommitStrategy().equalsTracking(abstractListContext.getCommitStrategy());
    }

    protected abstract ListCommitStrategy getCommitStrategy();

    public <T extends CDOMObject> void cloneInMasterLists(T t, T t2) {
        MasterListInterface masterListInterface = Globals.getMasterLists();
        for (CDOMReference cDOMReference : masterListInterface.getActiveLists()) {
            Collection<AssociatedPrereqObject> collection = masterListInterface.getAssociations(cDOMReference, t);
            if (collection == null) continue;
            for (AssociatedPrereqObject associatedPrereqObject : collection) {
                AssociatedPrereqObject associatedPrereqObject2 = this.getCommitStrategy().addToMasterList(associatedPrereqObject.getAssociation(AssociationKey.TOKEN), t2, cDOMReference, t2);
                associatedPrereqObject2.addAllPrerequisites(associatedPrereqObject.getPrerequisiteList());
                for (AssociationKey<?> associationKey : associatedPrereqObject.getAssociationKeys()) {
                    if (associationKey == AssociationKey.TOKEN || associationKey == AssociationKey.OWNER) continue;
                    associatedPrereqObject2.setAssociation(associationKey, associatedPrereqObject.getAssociation(associationKey));
                }
            }
        }
    }

    private static class OwnerURI {
        public final CDOMObject owner;
        public final URI source;

        public OwnerURI(URI uRI, CDOMObject cDOMObject) {
            this.source = uRI;
            this.owner = cDOMObject;
        }

        public int hashCode() {
            return this.owner.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof OwnerURI) {
                OwnerURI ownerURI = (OwnerURI)object;
                if (this.source == null ? ownerURI.source != null : !this.source.equals(ownerURI.source)) {
                    return false;
                }
                return this.owner.equals(ownerURI.owner);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrackingListCommitStrategy
    implements ListCommitStrategy {
        private URI sourceURI;
        private URI extractURI;
        private final TripleKeyMap<CDOMReference<? extends CDOMList<?>>, OwnerURI, CDOMObject, AssociatedPrereqObject> positiveMasterMap = new TripleKeyMap();
        private final TripleKeyMap<CDOMReference<? extends CDOMList<?>>, OwnerURI, CDOMObject, AssociatedPrereqObject> negativeMasterMap = new TripleKeyMap();
        private final HashMapToList<CDOMReference<? extends CDOMList<?>>, OwnerURI> masterClearSet = new HashMapToList();
        private final HashMapToList<String, OwnerURI> masterAllClear = new HashMapToList();
        private final DoubleKeyMap<URI, CDOMObject, CDOMObject> positiveMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMap<URI, CDOMObject, CDOMObject> negativeMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMapToList<URI, CDOMObject, CDOMReference<? extends CDOMList<?>>> globalClearSet = new DoubleKeyMapToList(HashMap.class, IdentityHashMap.class);

        public URI getExtractURI() {
            return this.extractURI;
        }

        @Override
        public void setExtractURI(URI uRI) {
            this.extractURI = uRI;
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        @Override
        public void setSourceURI(URI uRI) {
            this.sourceURI = uRI;
        }

        @Override
        public <T extends CDOMObject> AssociatedPrereqObject addToMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference, T t) {
            SimpleAssociatedObject simpleAssociatedObject = new SimpleAssociatedObject();
            simpleAssociatedObject.setAssociation(AssociationKey.OWNER, cDOMObject);
            simpleAssociatedObject.setAssociation(AssociationKey.TOKEN, string);
            this.positiveMasterMap.put(cDOMReference, new OwnerURI(this.sourceURI, cDOMObject), t, simpleAssociatedObject);
            return simpleAssociatedObject;
        }

        @Override
        public <T extends CDOMObject> void removeFromMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference, T t) {
            SimpleAssociatedObject simpleAssociatedObject = new SimpleAssociatedObject();
            simpleAssociatedObject.setAssociation(AssociationKey.OWNER, cDOMObject);
            simpleAssociatedObject.setAssociation(AssociationKey.TOKEN, string);
            this.negativeMasterMap.put(cDOMReference, new OwnerURI(this.sourceURI, cDOMObject), t, simpleAssociatedObject);
        }

        @Override
        public Changes<CDOMReference> getMasterListChanges(String string, CDOMObject cDOMObject, Class<? extends CDOMList<?>> clazz) {
            OwnerURI ownerURI = new OwnerURI(this.extractURI, cDOMObject);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Set<CDOMReference<CDOMList<?>>> set = this.positiveMasterMap.getKeySet();
            if (set != null) {
                block0: for (CDOMReference<CDOMList<?>> cDOMReference : set) {
                    if (!clazz.equals(cDOMReference.getReferenceClass())) continue;
                    for (CDOMObject cDOMObject2 : this.positiveMasterMap.getTertiaryKeySet(cDOMReference, ownerURI)) {
                        AssociatedPrereqObject associatedPrereqObject = this.positiveMasterMap.get(cDOMReference, ownerURI, cDOMObject2);
                        if (!cDOMObject.equals(associatedPrereqObject.getAssociation(AssociationKey.OWNER)) || !string.equals(associatedPrereqObject.getAssociation(AssociationKey.TOKEN))) continue;
                        arrayList.add(cDOMReference);
                        continue block0;
                    }
                }
            }
            set = this.negativeMasterMap.getKeySet();
            ArrayList arrayList2 = new ArrayList();
            if (set != null) {
                block2: for (CDOMReference cDOMReference : set) {
                    if (!clazz.equals(cDOMReference.getReferenceClass())) continue;
                    for (CDOMObject cDOMObject3 : this.negativeMasterMap.getTertiaryKeySet(cDOMReference, ownerURI)) {
                        AssociatedPrereqObject associatedPrereqObject = this.negativeMasterMap.get(cDOMReference, ownerURI, cDOMObject3);
                        if (!cDOMObject.equals(associatedPrereqObject.getAssociation(AssociationKey.OWNER)) || !string.equals(associatedPrereqObject.getAssociation(AssociationKey.TOKEN))) continue;
                        arrayList2.add(cDOMReference);
                        continue block2;
                    }
                }
            }
            return new CollectionChanges<CDOMReference>(arrayList, arrayList2, this.masterAllClear.containsInList(string, ownerURI));
        }

        @Override
        public <T extends CDOMObject> AssociatedChanges<T> getChangesInMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
            TreeMapToList<CDOMObject, Object> treeMapToList = new TreeMapToList<CDOMObject, Object>(CDOMObjectUtilities.CDOM_SORTER);
            OwnerURI ownerURI = new OwnerURI(this.extractURI, cDOMObject);
            Set<CDOMObject> set = this.positiveMasterMap.getTertiaryKeySet(cDOMReference, ownerURI);
            for (CDOMObject object22 : set) {
                AssociatedPrereqObject associatedPrereqObject = this.positiveMasterMap.get(cDOMReference, ownerURI, object22);
                if (!string.equals(associatedPrereqObject.getAssociation(AssociationKey.TOKEN))) continue;
                treeMapToList.addToListFor(object22, associatedPrereqObject);
            }
            TreeMapToList treeMapToList2 = new TreeMapToList(CDOMObjectUtilities.CDOM_SORTER);
            Set<CDOMObject> set2 = this.negativeMasterMap.getTertiaryKeySet(cDOMReference, ownerURI);
            for (CDOMObject cDOMObject2 : set2) {
                AssociatedPrereqObject associatedPrereqObject = this.negativeMasterMap.get(cDOMReference, ownerURI, cDOMObject2);
                if (!string.equals(associatedPrereqObject.getAssociation(AssociationKey.TOKEN))) continue;
                treeMapToList2.addToListFor(cDOMObject2, associatedPrereqObject);
            }
            return new AssociatedCollectionChanges<CDOMObject>(treeMapToList, treeMapToList2, this.masterClearSet.containsInList(cDOMReference, ownerURI));
        }

        public <T extends CDOMObject> void clearMasterList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
            this.masterClearSet.addToListFor(cDOMReference, new OwnerURI(this.sourceURI, cDOMObject));
        }

        @Override
        public void clearAllMasterLists(String string, CDOMObject cDOMObject) {
            this.masterAllClear.addToListFor(string, new OwnerURI(this.sourceURI, cDOMObject));
        }

        private CDOMObject getPositive(URI uRI, CDOMObject cDOMObject) {
            CDOMObject cDOMObject2 = this.positiveMap.get(uRI, cDOMObject);
            if (cDOMObject2 == null) {
                cDOMObject2 = new CDOMShell();
                this.positiveMap.put(uRI, cDOMObject, cDOMObject2);
            }
            return cDOMObject2;
        }

        private CDOMObject getNegative(URI uRI, CDOMObject cDOMObject) {
            CDOMObject cDOMObject2 = this.negativeMap.get(uRI, cDOMObject);
            if (cDOMObject2 == null) {
                cDOMObject2 = new CDOMShell();
                this.negativeMap.put(uRI, cDOMObject, cDOMObject2);
            }
            return cDOMObject2;
        }

        @Override
        public <T extends PrereqObject> AssociatedPrereqObject addToList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<? super T>> cDOMReference, CDOMReference<T> cDOMReference2) {
            SimpleAssociatedObject simpleAssociatedObject = new SimpleAssociatedObject();
            simpleAssociatedObject.setAssociation(AssociationKey.TOKEN, string);
            this.getPositive(this.sourceURI, cDOMObject).putToList(cDOMReference, cDOMReference2, simpleAssociatedObject);
            return simpleAssociatedObject;
        }

        @Override
        public <T extends PrereqObject> AssociatedPrereqObject removeFromList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<? super T>> cDOMReference, CDOMReference<T> cDOMReference2) {
            SimpleAssociatedObject simpleAssociatedObject = new SimpleAssociatedObject();
            simpleAssociatedObject.setAssociation(AssociationKey.TOKEN, string);
            this.getNegative(this.sourceURI, cDOMObject).putToList(cDOMReference, cDOMReference2, simpleAssociatedObject);
            return simpleAssociatedObject;
        }

        @Override
        public Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> getChangedLists(CDOMObject cDOMObject, Class<? extends CDOMList<?>> clazz) {
            ListSet<CDOMReference<? extends CDOMList<? extends PrereqObject>>> listSet = new ListSet<CDOMReference<? extends CDOMList<? extends PrereqObject>>>();
            for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : this.getPositive(this.extractURI, cDOMObject).getModifiedLists()) {
                if (!clazz.equals(cDOMReference.getReferenceClass())) continue;
                listSet.add(cDOMReference);
            }
            for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : this.getNegative(this.extractURI, cDOMObject).getModifiedLists()) {
                if (!clazz.equals(cDOMReference.getReferenceClass())) continue;
                listSet.add(cDOMReference);
            }
            List<CDOMReference<? extends CDOMList<?>>> list = this.globalClearSet.getListFor(this.extractURI, cDOMObject);
            if (list != null) {
                for (CDOMReference cDOMReference : list) {
                    if (!clazz.equals(cDOMReference.getReferenceClass())) continue;
                    listSet.add(cDOMReference);
                }
            }
            return listSet;
        }

        @Override
        public void removeAllFromList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<?>> cDOMReference) {
            this.globalClearSet.addToListFor(this.sourceURI, cDOMObject, cDOMReference);
        }

        @Override
        public <T extends PrereqObject> AssociatedChanges<CDOMReference<T>> getChangesInList(String string, CDOMObject cDOMObject, CDOMReference<? extends CDOMList<T>> cDOMReference) {
            return new ListChanges(string, this.getPositive(this.extractURI, cDOMObject), this.getNegative(this.extractURI, cDOMObject), cDOMReference, this.globalClearSet.containsInList(this.extractURI, cDOMObject, cDOMReference));
        }

        @Override
        public boolean hasMasterLists() {
            return !this.positiveMasterMap.isEmpty() && !this.masterClearSet.isEmpty() && !this.masterAllClear.isEmpty();
        }

        public void decommit() {
            this.masterAllClear.clear();
            this.masterClearSet.clear();
            this.positiveMasterMap.clear();
            this.negativeMasterMap.clear();
            this.positiveMap.clear();
            this.negativeMap.clear();
            this.globalClearSet.clear();
        }

        @Override
        public boolean equalsTracking(ListCommitStrategy listCommitStrategy) {
            if (listCommitStrategy instanceof TrackingListCommitStrategy) {
                TrackingListCommitStrategy trackingListCommitStrategy = (TrackingListCommitStrategy)listCommitStrategy;
                return trackingListCommitStrategy.masterAllClear.equals(this.masterAllClear) && trackingListCommitStrategy.masterClearSet.equals(this.masterClearSet) && trackingListCommitStrategy.positiveMasterMap.equals(this.positiveMasterMap) && trackingListCommitStrategy.negativeMasterMap.equals(this.negativeMasterMap);
            }
            return false;
        }

        public void purge(CDOMObject cDOMObject) {
            this.positiveMap.remove(this.sourceURI, cDOMObject);
            this.negativeMap.remove(this.sourceURI, cDOMObject);
            this.globalClearSet.removeListFor(this.sourceURI, cDOMObject);
        }

        protected static class CDOMShell
        extends CDOMObject {
            protected CDOMShell() {
            }

            public CDOMObject clone() throws CloneNotSupportedException {
                throw new CloneNotSupportedException();
            }

            public boolean isType(String string) {
                return false;
            }
        }
    }
}

