/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Kit;
import pcgen.core.kit.BaseKit;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.CDOMLoader;
import pcgen.rules.persistence.CDOMSubLineLoader;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMKitLoader
implements CDOMLoader<Kit> {
    private final Map<String, CDOMSubLineLoader<? extends BaseKit>> loadMap = new HashMap<String, CDOMSubLineLoader<? extends BaseKit>>();
    private final Class<Kit> targetClass = Kit.class;

    public void addLineLoader(CDOMSubLineLoader<? extends BaseKit> cDOMSubLineLoader) {
        this.loadMap.put(cDOMSubLineLoader.getPrefix(), cDOMSubLineLoader);
    }

    public boolean parseSubLine(LoadContext loadContext, Kit kit, String string, URI uRI) {
        int n = string.indexOf(9);
        String string2 = n == -1 ? string : string.substring(0, n);
        int n2 = string2.indexOf(58);
        if (n2 == -1) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line without a colon in first token: " + string + " in file: " + uRI);
            return false;
        }
        String string3 = string2.substring(0, n2);
        CDOMSubLineLoader<? extends BaseKit> cDOMSubLineLoader = this.loadMap.get(string3);
        if (cDOMSubLineLoader == null) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line with prefix: " + string3 + ".  Line was: " + string + " in file: " + uRI);
            return false;
        }
        try {
            if (!this.subParse(loadContext, kit, cDOMSubLineLoader, string, uRI)) {
                return false;
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean parseLine(LoadContext loadContext, Kit kit, String string, URI uRI) throws PersistenceLayerException {
        return false;
    }

    @Override
    public void loadLstFiles(LoadContext loadContext, Collection<CampaignSourceEntry> collection) {
        throw new IllegalStateException("Can't do this yet");
    }

    public void loadLstFile(LoadContext loadContext, URI uRI) {
        throw new IllegalStateException("Can't do this yet");
    }

    private <CC extends BaseKit> boolean subParse(LoadContext loadContext, Kit kit, CDOMSubLineLoader<CC> cDOMSubLineLoader, String string, URI uRI) throws PersistenceLayerException {
        BaseKit baseKit = (BaseKit)cDOMSubLineLoader.getCDOMObject(loadContext);
        loadContext.obj.addToList(kit, ListKey.KIT_TASKS, baseKit);
        return cDOMSubLineLoader.parseLine(loadContext, baseKit, string, uRI);
    }

    protected Kit getCDOMObject(LoadContext loadContext, String string) {
        Kit kit = loadContext.ref.silentlyGetConstructedCDOMObject(this.targetClass, string);
        if (kit == null) {
            kit = loadContext.ref.constructCDOMObject(this.targetClass, string);
        }
        return kit;
    }

    public Class<Kit> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void unloadLstFiles(LoadContext loadContext, Collection<CampaignSourceEntry> collection) {
        HashMapToList hashMapToList = new HashMapToList();
        for (CDOMSubLineLoader<? extends BaseKit> object : this.loadMap.values()) {
            hashMapToList.addToListFor(object.getLoadedClass(), object);
        }
        for (CampaignSourceEntry campaignSourceEntry : collection) {
            loadContext.setExtractURI(campaignSourceEntry.getURI());
            URI uRI = campaignSourceEntry.getWriteURI();
            File file = new File(uRI);
            this.ensureCreated(file.getParentFile());
            try {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Kit kit : loadContext.ref.getConstructedCDOMObjects(Kit.class)) {
                    if (!campaignSourceEntry.getURI().equals(kit.get(ObjectKey.SOURCE_URI))) continue;
                    CharSequence charSequence = new StringBuilder();
                    String[] stringArray = loadContext.unparseSubtoken(kit, "*KITTOKEN");
                    ((StringBuilder)charSequence).append("STARTPACK:");
                    ((StringBuilder)charSequence).append(kit.getDisplayName());
                    if (stringArray != null) {
                        ((StringBuilder)charSequence).append("\t").append(StringUtil.join(stringArray, "\t"));
                    }
                    ((StringBuilder)charSequence).append("\n");
                    Changes<BaseKit> changes = loadContext.getObjectContext().getListChanges(kit, ListKey.KIT_TASKS);
                    Collection<BaseKit> collection2 = changes.getAdded();
                    if (collection2 == null) continue;
                    for (BaseKit baseKit : collection2) {
                        List list = hashMapToList.getListFor(baseKit.getClass());
                        for (CDOMSubLineLoader cDOMSubLineLoader : list) {
                            this.processTask(loadContext, baseKit, cDOMSubLineLoader, (StringBuilder)charSequence);
                        }
                    }
                    ((StringBuilder)charSequence).append("\n");
                    treeSet.add(((StringBuilder)charSequence).toString());
                }
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println("#~PARAGRAPH");
                for (CharSequence charSequence : treeSet) {
                    printWriter.print((String)charSequence);
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private <T extends BaseKit> void processTask(LoadContext loadContext, T t, CDOMSubLineLoader<T> cDOMSubLineLoader, StringBuilder stringBuilder) {
        cDOMSubLineLoader.unloadObject(loadContext, t, stringBuilder);
    }

    private boolean ensureCreated(File file) {
        if (!file.exists()) {
            if (!this.ensureCreated(file.getParentFile())) {
                return false;
            }
            return file.mkdir();
        }
        return true;
    }
}

