/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public final class SourceLogFormatter
extends Formatter {
    private static final char SEPERATOR = ' ';
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.S");
    private final Date date = new Date();
    private static final Pattern javaExtPattern = Pattern.compile("\\.java");

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        this.date.setTime(logRecord.getMillis());
        stringBuffer.append(df.format(this.date));
        stringBuffer.append(' ');
        stringBuffer.append(String.valueOf(logRecord.getLevel()));
        stringBuffer.append(' ');
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(' ');
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement stackTraceElement = null;
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().startsWith("pcgen.util.Logging") || stackTraceElementArray[i].getClassName().startsWith("java.util.logging")) continue;
            stackTraceElement = stackTraceElementArray[i];
            break;
        }
        if (stackTraceElement != null) {
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuffer.append(javaExtPattern.matcher(stackTraceElement.getFileName()).replaceFirst(""));
                stringBuffer.append(':');
                stringBuffer.append(stackTraceElement.getLineNumber());
            } else {
                stringBuffer.append(stackTraceElement.getClassName());
                stringBuffer.append(' ');
                stringBuffer.append(stackTraceElement.getMethodName());
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            stringBuffer.append('\n');
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.flush();
            stringBuffer.append(stringWriter);
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

