/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.choiceset.SpellCasterChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.BonusAddition;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCasterToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<PCClass> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "SPELLCASTER";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        ReferenceChoiceSet referenceChoiceSet;
        String string2;
        Object object;
        String string3;
        Formula formula;
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string3 = string;
        } else {
            object = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string3 = string.substring(n + 1);
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        object = new StringTokenizer(string3, ",");
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<CDOMSingleRef> arrayList2 = new ArrayList<CDOMSingleRef>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        CDOMGroupRef cDOMGroupRef = loadContext.ref.getCDOMAllReference(PCCLASS_CLASS);
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if ("ANY".equalsIgnoreCase(string2)) {
                bl = true;
                arrayList.add(cDOMGroupRef);
                continue;
            }
            bl2 = true;
            if (string2.equals("Arcane") || string2.equals("Divine") || string2.equals("Psionic")) {
                arrayList3.add(string2);
                continue;
            }
            if (string2.startsWith("TYPE.") || string2.startsWith("TYPE=")) {
                referenceChoiceSet = TokenUtilities.getTypeReference((LoadContext)loadContext, PCCLASS_CLASS, (String)string2.substring(5));
                if (referenceChoiceSet == null) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getFullName() + ": " + string2 + " is not a valid reference: " + string));
                    return false;
                }
                arrayList.add(referenceChoiceSet);
                continue;
            }
            arrayList2.add(loadContext.ref.getCDOMReference(PCCLASS_CLASS, string2));
        }
        if (bl && bl2) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        string2 = arrayList.isEmpty() ? null : new ReferenceChoiceSet(arrayList);
        referenceChoiceSet = arrayList2.isEmpty() ? null : new ReferenceChoiceSet(arrayList2);
        SpellCasterChoiceSet spellCasterChoiceSet = new SpellCasterChoiceSet(cDOMGroupRef, arrayList3, (PrimitiveChoiceSet)string2, (PrimitiveChoiceSet)referenceChoiceSet);
        PersistentTransitionChoice persistentTransitionChoice = new PersistentTransitionChoice((ChoiceSet)spellCasterChoiceSet, formula);
        persistentTransitionChoice.setTitle("Spell Caster Class Choice");
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!PCCLASS_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, PCClass pCClass, PlayerCharacter playerCharacter) {
        PCClass pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
        if (pCClass2 == null) {
            playerCharacter.incrementClassLevel(0, pCClass);
            pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
        }
        BonusAddition.applyBonus((String)("PCLEVEL|" + pCClass2.getKeyName() + "|1"), (String)"", (PlayerCharacter)playerCharacter, (CDOMObject)cDOMObject, (boolean)false);
        pCClass2.setLevel(pCClass2.getLevel(), playerCharacter);
    }

    public boolean allow(PCClass pCClass, PlayerCharacter playerCharacter, boolean bl) {
        return true;
    }

    public PCClass decodeChoice(String string) {
        return (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCCLASS_CLASS, string);
    }

    public String encodeChoice(Object object) {
        return ((PCClass)object).getKeyName();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, PCClass pCClass) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, PCClass pCClass) {
        PCClass pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
        if (pCClass2 != null) {
            BonusAddition.removeBonus((String)("PCLEVEL|" + pCClass2.getKeyName() + "|1"), (String)"", (PlayerCharacter)playerCharacter, (CDOMObject)cDOMObject);
            pCClass2.setLevel(pCClass2.getLevel(), playerCharacter);
        }
    }
}

