/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.helper.StatLock;
import pcgen.core.PCStat;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineLst
implements CDOMPrimaryToken<CDOMObject> {
    public static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    public String getTokenName() {
        return "DEFINE";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        ParsingSeparator parsingSeparator = new ParsingSeparator(string, '|');
        if (!parsingSeparator.hasNext()) {
            Logging.errorPrint((String)(this.getTokenName() + " may not be empty"));
            return false;
        }
        String string2 = parsingSeparator.next();
        if (string2.startsWith("UNLOCK.")) {
            if (parsingSeparator.hasNext()) {
                Logging.errorPrint((String)(this.getTokenName() + " found UNLOCK. with additional pipe separated item.  " + "Must be of Format: varName|varFormula or " + "LOCK.<stat>|value or UNLOCK.<stat>"));
                return false;
            }
            PCStat pCStat = (PCStat)loadContext.ref.getAbbreviatedObject(PCSTAT_CLASS, string.substring(7));
            loadContext.obj.addToList(cDOMObject, ListKey.UNLOCKED_STATS, (Object)pCStat);
            return true;
        }
        if (!parsingSeparator.hasNext()) {
            Logging.errorPrint((String)(this.getTokenName() + " varName|varFormula" + "or LOCK.<stat>|value syntax requires an argument"));
            return false;
        }
        String string3 = string2;
        if (string3.length() == 0) {
            Logging.errorPrint((String)("Empty Variable Name found in " + this.getTokenName() + ": " + string));
            return false;
        }
        try {
            Formula formula = FormulaFactory.getFormulaFor((String)parsingSeparator.next());
            if (parsingSeparator.hasNext()) {
                Logging.errorPrint((String)(this.getTokenName() + " " + string2 + " syntax requires only one argument: " + string));
                return false;
            }
            if (string.startsWith("LOCK.")) {
                PCStat pCStat = (PCStat)loadContext.ref.getAbbreviatedObject(PCSTAT_CLASS, string2.substring(5));
                loadContext.getObjectContext().addToList(cDOMObject, ListKey.STAT_LOCKS, (Object)new StatLock(pCStat, formula));
            } else {
                loadContext.getObjectContext().put(cDOMObject, VariableKey.getConstant((String)string3), formula);
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.errorPrint((String)("Illegal Formula found in " + this.getTokenName() + ": " + string + " " + illegalArgumentException.getLocalizedMessage()));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.STAT_LOCKS);
        Changes changes2 = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.UNLOCKED_STATS);
        Set set = loadContext.getObjectContext().getVariableKeys(cDOMObject);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (set != null && !set.isEmpty()) {
            for (VariableKey variableKey : set) {
                treeSet.add(variableKey.toString() + "|" + loadContext.getObjectContext().getVariable(cDOMObject, variableKey));
            }
        }
        if (changes != null && !changes.isEmpty()) {
            if (changes.includesGlobalClear()) {
                loadContext.addWriteMessage("DEFINE:LOCK does not support .CLEAR");
                return null;
            }
            if (changes.hasAddedItems()) {
                for (VariableKey variableKey : changes.getAdded()) {
                    treeSet.add("LOCK." + variableKey.getLockedStat().getLSTformat() + "|" + variableKey.getLockValue());
                }
            }
        }
        if (changes2 != null && !changes2.isEmpty()) {
            if (changes2.includesGlobalClear()) {
                loadContext.addWriteMessage("DEFINE:UNLOCK does not support .CLEAR");
                return null;
            }
            if (changes2.hasAddedItems()) {
                for (VariableKey variableKey : changes2.getAdded()) {
                    treeSet.add("UNLOCK." + variableKey.getLSTformat());
                }
            }
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

