/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolygonProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPolygonElementBridge
extends SVGDecoratedShapeElementBridge {
    public String getLocalName() {
        return "polygon";
    }

    public Bridge getInstance() {
        return new SVGPolygonElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        block5: {
            String s = e.getAttributeNS(null, "points");
            if (s.length() != 0) {
                AWTPolygonProducer app = new AWTPolygonProducer();
                app.setWindingRule(CSSUtilities.convertFillRule(e));
                try {
                    try {
                        PointsParser pp = new PointsParser();
                        pp.setPointsHandler(app);
                        pp.parse(s);
                    }
                    catch (ParseException ex) {
                        BridgeException bex = new BridgeException(e, "attribute.malformed", new Object[]{"points"});
                        bex.setGraphicsNode(shapeNode);
                        throw bex;
                    }
                    Object var9_8 = null;
                    shapeNode.setShape(app.getShape());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    shapeNode.setShape(app.getShape());
                    throw throwable;
                }
            }
            throw new BridgeException(e, "attribute.missing", new Object[]{"points"});
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }
}

