/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.HashTableStack;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDocumentFactory
extends DefaultHandler
implements LexicalHandler,
DocumentFactory {
    protected DOMImplementation implementation;
    protected String parserClassName;
    protected Document document;
    protected DocumentDescriptor documentDescriptor;
    protected boolean createDocumentDescriptor;
    protected Node currentNode;
    protected Locator locator;
    protected boolean inCDATA;
    protected boolean inDTD;
    protected boolean isValidating;
    protected HashTableStack namespaces;
    protected ErrorHandler errorHandler;
    protected List preInfo;

    public SAXDocumentFactory(DOMImplementation impl, String parser) {
        this.implementation = impl;
        this.parserClassName = parser;
    }

    public SAXDocumentFactory(DOMImplementation impl, String parser, boolean dd) {
        this.implementation = impl;
        this.parserClassName = parser;
        this.createDocumentDescriptor = dd;
    }

    public Document createDocument(String ns, String root, String uri) throws IOException {
        return this.createDocument(ns, root, uri, new InputSource(uri));
    }

    public Document createDocument(String uri) throws IOException {
        return this.createDocument(new InputSource(uri));
    }

    public Document createDocument(String ns, String root, String uri, InputStream is) throws IOException {
        InputSource inp = new InputSource(is);
        inp.setSystemId(uri);
        return this.createDocument(ns, root, uri, inp);
    }

    public Document createDocument(String uri, InputStream is) throws IOException {
        InputSource inp = new InputSource(is);
        inp.setSystemId(uri);
        return this.createDocument(inp);
    }

    public Document createDocument(String ns, String root, String uri, Reader r) throws IOException {
        InputSource inp = new InputSource(r);
        inp.setSystemId(uri);
        return this.createDocument(ns, root, uri, inp);
    }

    public Document createDocument(String uri, Reader r) throws IOException {
        InputSource inp = new InputSource(r);
        inp.setSystemId(uri);
        return this.createDocument(inp);
    }

    protected Document createDocument(String ns, String root, String uri, InputSource is) throws IOException {
        String docElemNS;
        Document ret = this.createDocument(is);
        Element docElem = ret.getDocumentElement();
        String lname = root;
        String nsURI = ns;
        if (ns == null) {
            int idx = lname.indexOf(58);
            String nsp = idx == -1 || idx == lname.length() - 1 ? "" : lname.substring(0, idx);
            nsURI = this.namespaces.get(nsp);
            if (idx != -1 && idx != lname.length() - 1) {
                lname = lname.substring(idx + 1);
            }
        }
        if (!((docElemNS = docElem.getNamespaceURI()) == nsURI || docElemNS != null && docElemNS.equals(nsURI))) {
            throw new IOException("Root element namespace does not match that requested:\nRequested: " + nsURI + "\n" + "Found: " + docElemNS);
        }
        if (docElemNS != null) {
            if (!docElem.getLocalName().equals(lname)) {
                throw new IOException("Root element does not match that requested:\nRequested: " + lname + "\n" + "Found: " + docElem.getLocalName());
            }
        } else if (!docElem.getNodeName().equals(lname)) {
            throw new IOException("Root element does not match that requested:\nRequested: " + lname + "\n" + "Found: " + docElem.getNodeName());
        }
        return ret;
    }

    protected Document createDocument(InputSource is) throws IOException {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader(this.parserClassName);
            parser.setContentHandler(this);
            parser.setDTDHandler(this);
            parser.setEntityResolver(this);
            parser.setErrorHandler(this.errorHandler == null ? this : this.errorHandler);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            parser.parse(is);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof InterruptedIOException) {
                throw (InterruptedIOException)ex;
            }
            throw new IOException(e.getMessage());
        }
        this.currentNode = null;
        Document ret = this.document;
        this.document = null;
        return ret;
    }

    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    public void setValidating(boolean isValidating) {
        this.isValidating = isValidating;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public void startDocument() throws SAXException {
        this.preInfo = new LinkedList();
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.inCDATA = false;
        this.inDTD = false;
        this.currentNode = null;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        Element e;
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXException(new InterruptedIOException());
        }
        int len = attributes.getLength();
        this.namespaces.push();
        int i = 0;
        while (i < len) {
            String ns;
            String aname = attributes.getQName(i);
            if (aname.equals("xmlns")) {
                ns = attributes.getValue(i);
                if (ns.length() == 0) {
                    ns = null;
                }
                this.namespaces.put("", ns);
            } else if (aname.startsWith("xmlns:")) {
                ns = attributes.getValue(i);
                if (ns.length() == 0) {
                    ns = null;
                }
                int idx = aname.indexOf(58);
                this.namespaces.put(aname.substring(idx + 1), ns);
            }
            ++i;
        }
        int idx = rawName.indexOf(58);
        String nsp = idx == -1 || idx == rawName.length() - 1 ? "" : rawName.substring(0, idx);
        String nsURI = this.namespaces.get(nsp);
        if (this.currentNode == null) {
            this.document = this.implementation.createDocument(nsURI, rawName, null);
            Iterator i2 = this.preInfo.iterator();
            e = this.document.getDocumentElement();
            this.currentNode = e;
            while (i2.hasNext()) {
                PreInfo pi = (PreInfo)i2.next();
                Node n = pi.createNode(this.document);
                this.document.insertBefore(n, e);
            }
            this.preInfo = null;
        } else {
            e = this.document.createElementNS(nsURI, rawName);
            this.currentNode.appendChild(e);
            this.currentNode = e;
        }
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocationLine(e, this.locator.getLineNumber());
        }
        int i3 = 0;
        while (i3 < len) {
            String aname = attributes.getQName(i3);
            if (aname.equals("xmlns")) {
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", aname, attributes.getValue(i3));
            } else {
                idx = aname.indexOf(58);
                nsURI = idx == -1 ? null : this.namespaces.get(aname.substring(0, idx));
                e.setAttributeNS(nsURI, aname, attributes.getValue(i3));
            }
            ++i3;
        }
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void warning(SAXParseException ex) throws SAXException {
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.currentNode != null) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.namespaces.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        if (this.currentNode == null) {
            if (this.inCDATA) {
                this.preInfo.add(new CDataInfo(data));
            } else {
                this.preInfo.add(new TextInfo(data));
            }
        } else {
            Text n = this.inCDATA ? this.document.createCDATASection(data) : this.document.createTextNode(data);
            this.currentNode.appendChild(n);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.inDTD) {
            if (this.currentNode == null) {
                this.preInfo.add(new ProcessingInstructionInfo(target, data));
            } else {
                this.currentNode.appendChild(this.document.createProcessingInstruction(target, data));
            }
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inDTD) {
            String str = new String(ch, start, length);
            if (this.currentNode == null) {
                this.preInfo.add(new CommentInfo(str));
            } else {
                this.currentNode.appendChild(this.document.createComment(str));
            }
        }
    }

    static class TextInfo
    implements PreInfo {
        public String text;

        public TextInfo(String text) {
            this.text = text;
        }

        public Node createNode(Document doc) {
            return doc.createTextNode(this.text);
        }
    }

    static class CDataInfo
    implements PreInfo {
        public String cdata;

        public CDataInfo(String cdata) {
            this.cdata = cdata;
        }

        public Node createNode(Document doc) {
            return doc.createCDATASection(this.cdata);
        }
    }

    static class CommentInfo
    implements PreInfo {
        public String comment;

        public CommentInfo(String comment) {
            this.comment = comment;
        }

        public Node createNode(Document doc) {
            return doc.createComment(this.comment);
        }
    }

    static class ProcessingInstructionInfo
    implements PreInfo {
        public String target;
        public String data;

        public ProcessingInstructionInfo(String target, String data) {
            this.target = target;
            this.data = data;
        }

        public Node createNode(Document doc) {
            return doc.createProcessingInstruction(this.target, this.data);
        }
    }

    static interface PreInfo {
        public Node createNode(Document var1);
    }
}

