/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.batik.transcoder.wmf.WMFConstants;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.RecordStore;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class WMFRecordStore
extends RecordStore
implements WMFConstants {
    private byte[] js2B = new byte[2];
    private byte[] js4B = new byte[4];

    private short readShort(DataInputStream is) throws IOException {
        is.read(this.js2B);
        int iTemp = (0xFF & this.js2B[1]) << 8;
        short i = (short)(0xFFFF & iTemp);
        i = (short)(i | 0xFF & this.js2B[0]);
        return i;
    }

    private int readInt(DataInputStream is) throws IOException {
        is.read(this.js4B);
        int i = (0xFF & this.js4B[3]) << 24;
        i |= (0xFF & this.js4B[2]) << 16;
        i |= (0xFF & this.js4B[1]) << 8;
        return i |= 0xFF & this.js4B[0];
    }

    public boolean read(DataInputStream is) throws IOException {
        this.reset();
        this.setReading(true);
        int dwIsAldus = this.readInt(is);
        if (dwIsAldus != -1698247209) {
            System.out.println("Unable to read file, it is not a Aldus Placable Metafile");
            this.setReading(false);
            return false;
        }
        int key = dwIsAldus;
        short hmf = this.readShort(is);
        short left = this.readShort(is);
        short top = this.readShort(is);
        short right = this.readShort(is);
        short bottom = this.readShort(is);
        short inch = this.readShort(is);
        int reserved = this.readInt(is);
        short checksum = this.readShort(is);
        short mtType = this.readShort(is);
        short mtHeaderSize = this.readShort(is);
        short mtVersion = this.readShort(is);
        int mtSize = this.readInt(is);
        short mtNoObjects = this.readShort(is);
        int mtMaxRecord = this.readInt(is);
        short mtNoParameters = this.readShort(is);
        int functionId = 1;
        int recSize = 0;
        this.numRecords = 0;
        this.numObjects = mtNoObjects;
        this.objectVector.ensureCapacity(this.numObjects);
        int i = 0;
        while (i < this.numObjects) {
            this.objectVector.addElement(new GdiObject(i, false));
            ++i;
        }
        while (functionId > 0) {
            recSize = this.readInt(is);
            recSize -= 3;
            functionId = this.readShort(is);
            if (functionId <= 0) break;
            MetaRecord mr = new MetaRecord();
            switch (functionId) {
                case 1583: {
                    int i2 = 0;
                    while (i2 < recSize) {
                        short recData = this.readShort(is);
                        ++i2;
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    int lenText = this.readInt(is);
                    int len = 2 * (recSize - 4);
                    byte[] bstr = new byte[lenText];
                    int i3 = 0;
                    while (i3 < lenText) {
                        bstr[i3] = is.readByte();
                        ++i3;
                    }
                    while (i3 < len) {
                        is.readByte();
                        ++i3;
                    }
                    String str = new String(bstr);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    this.records.addElement(mr);
                    break;
                }
                case 1313: {
                    int len = this.readShort(is);
                    byte[] bstr = new byte[len];
                    int i4 = 0;
                    while (i4 < len) {
                        bstr[i4] = is.readByte();
                        ++i4;
                    }
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    String str = new String(bstr);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    this.records.addElement(mr);
                    break;
                }
                case 763: {
                    short lfHeight = this.readShort(is);
                    short lfWidth = this.readShort(is);
                    short lfEscapement = this.readShort(is);
                    short lfOrientation = this.readShort(is);
                    short lfWeight = this.readShort(is);
                    byte lfItalic = is.readByte();
                    byte lfUnderline = is.readByte();
                    byte lfStrikeOut = is.readByte();
                    byte lfCharSet = is.readByte();
                    byte lfOutPrecision = is.readByte();
                    byte lfClipPrecision = is.readByte();
                    byte lfQuality = is.readByte();
                    byte lfPitchAndFamily = is.readByte();
                    int len = 2 * (recSize - 9);
                    byte[] lfFaceName = new byte[len];
                    int i5 = 0;
                    while (i5 < len) {
                        lfFaceName[i5] = is.readByte();
                        ++i5;
                    }
                    String str = new String(lfFaceName);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(lfHeight));
                    mr.AddElement(new Integer(lfItalic));
                    mr.AddElement(new Integer(lfWeight));
                    this.records.addElement(mr);
                    break;
                }
                case 523: 
                case 524: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 764: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(this.readShort(is)));
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(this.readShort(is)));
                    this.records.addElement(mr);
                    break;
                }
                case 762: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    Integer style = new Integer(this.readShort(is));
                    mr.AddElement(style);
                    short width = this.readShort(is);
                    int colorref = this.readInt(is);
                    short height = this.readShort(is);
                    int j = 5;
                    while (j < recSize) {
                        this.readShort(is);
                        ++j;
                    }
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(width));
                    this.records.addElement(mr);
                    break;
                }
                case 513: 
                case 521: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    this.records.addElement(mr);
                    break;
                }
                case 531: 
                case 532: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 1336: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    int[] pts = new int[count];
                    int ptCount = 0;
                    int i6 = 0;
                    while (i6 < count) {
                        pts[i6] = this.readShort(is);
                        ptCount += pts[i6];
                        ++i6;
                    }
                    mr.AddElement(new Integer(count));
                    int i7 = 0;
                    while (i7 < count) {
                        mr.AddElement(new Integer(pts[i7]));
                        ++i7;
                    }
                    int offset = count + 1;
                    int i8 = 0;
                    while (i8 < count) {
                        int j = 0;
                        while (j < pts[i8]) {
                            mr.AddElement(new Integer(this.readShort(is)));
                            mr.AddElement(new Integer(this.readShort(is)));
                            ++j;
                        }
                        ++i8;
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 804: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    mr.AddElement(new Integer(count));
                    int i9 = 0;
                    while (i9 < count) {
                        mr.AddElement(new Integer(this.readShort(is)));
                        mr.AddElement(new Integer(this.readShort(is)));
                        ++i9;
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 1564: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    short i4 = this.readShort(is);
                    short i5 = this.readShort(is);
                    mr.AddElement(new Integer(i5));
                    mr.AddElement(new Integer(i4));
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 2071: 
                case 2074: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    short i4 = this.readShort(is);
                    short i5 = this.readShort(is);
                    short i6 = this.readShort(is);
                    short i7 = this.readShort(is);
                    mr.AddElement(new Integer(i7));
                    mr.AddElement(new Integer(i6));
                    mr.AddElement(new Integer(i5));
                    mr.AddElement(new Integer(i4));
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                default: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int j = 0;
                    while (j < recSize) {
                        mr.AddElement(new Integer(this.readShort(is)));
                        ++j;
                    }
                    this.records.addElement(mr);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int type, Object obj) {
        int startIdx;
        int i = startIdx = 0;
        while (i < this.numObjects) {
            GdiObject gdi = (GdiObject)this.objectVector.elementAt(i);
            if (!gdi.used) {
                gdi.Setup(type, obj);
                this.lastObjectIdx = i;
                break;
            }
            ++i;
        }
    }
}

