/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.Description;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.PatternChanges;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenefitToken
extends AbstractToken
implements CDOMPrimaryToken<Ability> {
    public String getTokenName() {
        return "BENEFIT";
    }

    public boolean parse(LoadContext loadContext, Ability ability, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        if (".CLEAR".equals(string)) {
            loadContext.getObjectContext().removeList((CDOMObject)ability, ListKey.BENEFIT);
            return true;
        }
        if (string.startsWith(".CLEAR.")) {
            loadContext.getObjectContext().removePatternFromList((CDOMObject)ability, ListKey.BENEFIT, string.substring(7));
            return true;
        }
        Description description = this.parseBenefit(string);
        if (description == null) {
            return false;
        }
        loadContext.getObjectContext().addToList((CDOMObject)ability, ListKey.BENEFIT, (Object)description);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Ability ability) {
        PatternChanges patternChanges = loadContext.getObjectContext().getListPatternChanges((CDOMObject)ability, ListKey.BENEFIT);
        if (patternChanges == null || patternChanges.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = patternChanges.getRemoved();
        if (patternChanges.includesGlobalClear()) {
            if (collection != null && !collection.isEmpty()) {
                loadContext.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            arrayList.add(".CLEAR");
        } else if (collection != null && !collection.isEmpty()) {
            for (Object object : collection) {
                arrayList.add(".CLEAR." + (String)object);
            }
        }
        Collection collection2 = patternChanges.getAdded();
        if (collection2 != null && !collection2.isEmpty()) {
            Object object;
            object = collection2.iterator();
            while (object.hasNext()) {
                Description description = (Description)object.next();
                arrayList.add(description.getPCCText());
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Description parseBenefit(String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (PreParserFactory.isPreReqString((String)string2)) {
            Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + string));
            Logging.errorPrint((String)"  PRExxx can not be only value");
            return null;
        }
        String string3 = EntityEncoder.decode((String)string2);
        if (!StringUtil.hasBalancedParens((String)string3)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " encountered imbalanced Parenthesis: " + string));
            return null;
        }
        Description description = new Description(string3);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (PreParserFactory.isPreReqString((String)string4)) {
                Prerequisite prerequisite = this.getPrerequisite(string4);
                if (prerequisite == null) {
                    Logging.errorPrint((String)(this.getTokenName() + " had invalid prerequisite : " + string4));
                    return null;
                }
                description.addPrerequisite(prerequisite);
                bl = true;
                continue;
            }
            if (bl) {
                Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + string));
                Logging.errorPrint((String)"  PRExxx must be at the END of the Token");
                return null;
            }
            description.addVariable(string4);
        }
        return description;
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

