/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class LevelToken
extends Token {
    public static final String TOKENNAME = "LEVEL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        PCLevelInfo pCLevelInfo = null;
        Object object = playerCharacter.getLevelInfo().iterator();
        while (object.hasNext() && (pCLevelInfo = (PCLevelInfo)object.next()).getLevel() != n) {
        }
        if (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("CLASSNAME")) {
                string2 = LevelToken.getLevelClassName(playerCharacter, pCLevelInfo);
            }
            if (((String)object).equals("CLASSLEVEL")) {
                string2 = LevelToken.getLevelClassLevel(playerCharacter, pCLevelInfo);
            }
            if (((String)object).equals("FEATLIST")) {
                string2 = LevelToken.getLevelFeatList(playerCharacter, pCLevelInfo);
            }
            if (((String)object).equals("HP")) {
                string2 = LevelToken.getLevelHP(playerCharacter, pCLevelInfo);
            }
            if (((String)object).equals("SKILLPOINTS")) {
                string2 = LevelToken.getLevelSkillPoints(pCLevelInfo);
            }
        }
        return string2;
    }

    public static String getLevelClassName(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        return pCLevelInfo.getClassKeyName();
    }

    public static String getLevelClassLevel(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        return Integer.toString(pCLevelInfo.getLevel());
    }

    public static String getLevelFeatList(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        return "";
    }

    public static String getLevelHP(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        String string = pCLevelInfo.getClassKeyName();
        PCClass pCClass = playerCharacter.getClassKeyed(string);
        if (pCClass == null && (pCClass = (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string)) != null) {
            CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)pCClass.get(ObjectKey.EX_CLASS);
            pCClass = playerCharacter.getClassKeyed(((PCClass)cDOMSingleRef.resolvesTo()).getKeyName());
        }
        if (pCClass != null) {
            return String.valueOf(pCClass.getHitPoint(pCLevelInfo.getLevel() - 1));
        }
        return "";
    }

    public static String getLevelSkillPoints(PCLevelInfo pCLevelInfo) {
        return Integer.toString(pCLevelInfo.getSkillPointsGained());
    }
}

