/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltcritmultToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ALTCRITMULT";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        Integer n;
        block7: {
            if (this.isEmpty(string)) {
                return false;
            }
            n = null;
            if (string.length() > 0 && string.charAt(0) == 'x') {
                try {
                    n = Integer.valueOf(string.substring(1));
                    if (n <= 0) {
                        Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " cannot be <= 0"));
                        return false;
                    }
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " was expecting an Integer: " + string));
                    return false;
                }
            }
            if ("-".equals(string)) {
                n = -1;
            }
        }
        if (n == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " was expecting x followed by an integer " + "or the special value '-' (representing no value)"));
            return false;
        }
        EquipmentHead equipmentHead = equipment.getEquipmentHead(2);
        loadContext.getObjectContext().put((CDOMObject)equipmentHead, IntegerKey.CRIT_MULT, n);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        EquipmentHead equipmentHead = equipment.getEquipmentHeadReference(2);
        if (equipmentHead == null) {
            return null;
        }
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)equipmentHead, IntegerKey.CRIT_MULT);
        if (n == null) {
            return null;
        }
        int n2 = n;
        String string = n2 == -1 ? "-" : "x" + n2;
        return new String[]{string};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

