/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.StatList;
import pcgen.io.exporttoken.StatToken;
import plugin.charactersheet.gui.CharacterPanel;

public class AttributePane
extends JPanel {
    private PlayerCharacter pc;
    private List<Attribute> attrList = new ArrayList<Attribute>();
    private static final Font FONT_EIGHT = new Font("Dialog", 0, 8);
    private static final Font FONT_BFOURTEEN = new Font("Dialog", 1, 14);
    private static final Font FONT_FOURTEEN = new Font("Dialog", 0, 14);
    private static final FlowLayout FLOWCENTER = new FlowLayout(1, 1, 1);
    private static final String ABILITY = "Ability";
    private static final String BASE = "Base";
    private static final String CURR = "Curr";
    private static final String TEMP = "Temp";
    private static final String NAME = "Name";
    private static final String SCORE = "Score";
    private static final String MOD = "Mod";
    private static final String SPACE = " ";

    public AttributePane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new GridBoxLayout(0, 7, 2, 2));
        JLabel jLabel = new JLabel(ABILITY);
        jLabel.setFont(FONT_EIGHT);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel(BASE);
        jLabel2.setFont(FONT_EIGHT);
        this.add(jLabel2);
        this.add(new JLabel());
        JLabel jLabel3 = new JLabel(CURR);
        jLabel3.setFont(FONT_EIGHT);
        this.add(jLabel3);
        this.add(new JLabel());
        JLabel jLabel4 = new JLabel(TEMP);
        jLabel4.setFont(FONT_EIGHT);
        this.add(jLabel4);
        this.add(new JLabel());
        JLabel jLabel5 = new JLabel(NAME);
        jLabel5.setFont(FONT_EIGHT);
        this.add(jLabel5);
        JLabel jLabel6 = new JLabel(SCORE);
        jLabel6.setFont(FONT_EIGHT);
        this.add(jLabel6);
        JLabel jLabel7 = new JLabel(MOD);
        jLabel7.setFont(FONT_EIGHT);
        this.add(jLabel7);
        JLabel jLabel8 = new JLabel(SCORE);
        jLabel8.setFont(FONT_EIGHT);
        this.add(jLabel8);
        JLabel jLabel9 = new JLabel(MOD);
        jLabel9.setFont(FONT_EIGHT);
        this.add(jLabel9);
        JLabel jLabel10 = new JLabel(SCORE);
        jLabel10.setFont(FONT_EIGHT);
        this.add(jLabel10);
        JLabel jLabel11 = new JLabel(MOD);
        jLabel11.setFont(FONT_EIGHT);
        this.add(jLabel11);
    }

    public void setColor() {
        this.setLocalColor();
        for (Attribute attribute : this.attrList) {
            attribute.setColor();
        }
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setVisible(true);
        StatList statList = playerCharacter.getStatList();
        this.destruct();
        for (int i = 0; i < statList.size(); ++i) {
            Attribute attribute = new Attribute(i);
            this.attrList.add(attribute);
        }
    }

    public void refresh() {
        Globals.setCurrentPC((PlayerCharacter)this.pc);
        for (Attribute attribute : this.attrList) {
            attribute.refresh();
        }
    }

    public void destruct() {
        for (Attribute attribute : this.attrList) {
            attribute.destruct();
        }
        this.attrList.clear();
    }

    protected class Attribute {
        int index;
        private JLabel attrAbbrev;
        private JPanel attrPanel;
        private JLabel baseAttr;
        private JPanel baseAttrPanel;
        private JLabel baseBonus;
        private JPanel baseBonusPanel;
        private JLabel modifiedAttr;
        private JPanel modifiedAttrPanel;
        private JLabel modifiedBonus;
        private JPanel modifiedBonusPanel;
        private JLabel tempAttr;
        private JPanel tempAttrPanel;
        private JLabel tempBonus;
        private JPanel tempBonusPanel;

        public Attribute(int n) {
            this.index = n;
            this.initComponents();
            this.setColor();
        }

        protected void initComponents() {
            this.attrPanel = new JPanel();
            this.attrPanel.setLayout(FLOWCENTER);
            this.attrAbbrev = new JLabel();
            this.attrAbbrev.setFont(FONT_BFOURTEEN);
            this.attrAbbrev.setText(AttributePane.SPACE);
            this.attrPanel.add(this.attrAbbrev);
            AttributePane.this.add(this.attrPanel);
            this.baseAttrPanel = new JPanel();
            this.baseAttrPanel.setLayout(FLOWCENTER);
            this.baseAttr = new JLabel();
            this.baseAttr.setFont(FONT_FOURTEEN);
            this.baseAttr.setText(AttributePane.SPACE);
            this.baseAttrPanel.add(this.baseAttr);
            AttributePane.this.add(this.baseAttrPanel);
            this.baseBonusPanel = new JPanel();
            this.baseBonusPanel.setLayout(FLOWCENTER);
            this.baseBonus = new JLabel();
            this.baseBonus.setFont(FONT_FOURTEEN);
            this.baseBonus.setText(AttributePane.SPACE);
            this.baseBonusPanel.add(this.baseBonus);
            AttributePane.this.add(this.baseBonusPanel);
            this.modifiedAttrPanel = new JPanel();
            this.modifiedAttrPanel.setLayout(FLOWCENTER);
            this.modifiedAttr = new JLabel();
            this.modifiedAttr.setFont(FONT_FOURTEEN);
            this.modifiedAttr.setText(AttributePane.SPACE);
            this.modifiedAttrPanel.add(this.modifiedAttr);
            AttributePane.this.add(this.modifiedAttrPanel);
            this.modifiedBonusPanel = new JPanel();
            this.modifiedBonusPanel.setLayout(FLOWCENTER);
            this.modifiedBonus = new JLabel();
            this.modifiedBonus.setFont(FONT_FOURTEEN);
            this.modifiedBonus.setText(AttributePane.SPACE);
            this.modifiedBonusPanel.add(this.modifiedBonus);
            AttributePane.this.add(this.modifiedBonusPanel);
            this.tempAttrPanel = new JPanel();
            this.tempAttrPanel.setLayout(FLOWCENTER);
            this.tempAttr = new JLabel();
            this.tempAttr.setFont(FONT_FOURTEEN);
            this.tempAttr.setText(AttributePane.SPACE);
            this.tempAttrPanel.add(this.tempAttr);
            AttributePane.this.add(this.tempAttrPanel);
            this.tempBonusPanel = new JPanel();
            this.tempBonusPanel.setLayout(FLOWCENTER);
            this.tempBonus = new JLabel();
            this.tempBonus.setFont(FONT_FOURTEEN);
            this.tempBonus.setText(AttributePane.SPACE);
            this.tempBonusPanel.add(this.tempBonus);
            AttributePane.this.add(this.tempBonusPanel);
        }

        public void refresh() {
            this.attrAbbrev.setText(StatToken.getNameToken((PlayerCharacter)AttributePane.this.pc, (int)this.index));
            this.baseAttr.setText(StatToken.getStatToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)0));
            this.baseBonus.setText(StatToken.getModToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)0));
            this.modifiedAttr.setText(StatToken.getStatToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)0));
            this.modifiedBonus.setText(StatToken.getModToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)0));
            this.tempAttr.setText(StatToken.getStatToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (int)0));
            this.tempBonus.setText(StatToken.getModToken((PlayerCharacter)AttributePane.this.pc, (int)this.index, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (int)0));
        }

        public void setColor() {
            AttributePane.this.setBackground(CharacterPanel.white);
            this.attrPanel.setBackground(CharacterPanel.bodyDark);
            this.attrPanel.setBorder(new LineBorder(CharacterPanel.border, 2));
            this.baseAttrPanel.setBackground(CharacterPanel.white);
            this.baseAttrPanel.setBorder(new LineBorder(CharacterPanel.border, 2));
            this.baseBonusPanel.setBackground(CharacterPanel.white);
            this.baseBonusPanel.setBorder(new LineBorder(CharacterPanel.border, 2));
            this.modifiedAttrPanel.setBackground(CharacterPanel.bodyLight);
            this.modifiedAttrPanel.setBorder(new LineBorder(CharacterPanel.border, 2));
            this.modifiedBonusPanel.setBackground(CharacterPanel.bodyLight);
            this.modifiedBonusPanel.setBorder(new LineBorder(CharacterPanel.border, 2));
            this.tempAttrPanel.setBackground(CharacterPanel.white);
            this.tempAttrPanel.setBorder(new LineBorder(CharacterPanel.lightGrey, 2));
            this.tempBonusPanel.setBackground(CharacterPanel.white);
            this.tempBonusPanel.setBorder(new LineBorder(CharacterPanel.lightGrey, 2));
        }

        public void destruct() {
            AttributePane.this.remove(this.attrPanel);
            AttributePane.this.remove(this.baseAttrPanel);
            AttributePane.this.remove(this.baseBonusPanel);
            AttributePane.this.remove(this.modifiedAttrPanel);
            AttributePane.this.remove(this.modifiedBonusPanel);
            AttributePane.this.remove(this.tempAttrPanel);
            AttributePane.this.remove(this.tempBonusPanel);
        }
    }
}

