/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Properties;
import javax.swing.JPanel;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.CharacterSheetUtils;
import plugin.charactersheet.gui.ArmorPane;
import plugin.charactersheet.gui.AttributePane;
import plugin.charactersheet.gui.BaseAttackPane;
import plugin.charactersheet.gui.CharacterPanel;
import plugin.charactersheet.gui.CombatPane1;
import plugin.charactersheet.gui.CombatPane2;
import plugin.charactersheet.gui.DetailsPane;
import plugin.charactersheet.gui.MasterTurnPane;
import plugin.charactersheet.gui.MusicPane;
import plugin.charactersheet.gui.PerDayPane;
import plugin.charactersheet.gui.RagePane;
import plugin.charactersheet.gui.SavingThrowPane;
import plugin.charactersheet.gui.SkillsPane;
import plugin.charactersheet.gui.UnarmedPane;
import plugin.charactersheet.gui.WeaponListPane;

public class Page1Panel
extends JPanel {
    private PlayerCharacter pc;
    private ArmorPane armorPane = new ArmorPane();
    private ArmorPane shieldPane = new ArmorPane();
    private ArmorPane itemPane = new ArmorPane();
    private AttributePane attributePane = new AttributePane();
    private BaseAttackPane baseAttackPane = new BaseAttackPane();
    private CombatPane1 combatPane1 = new CombatPane1();
    private CombatPane2 combatPane2 = new CombatPane2();
    private DetailsPane detailsPane = new DetailsPane();
    private MusicPane musicPane = new MusicPane();
    private PerDayPane layOnHandsPane = new PerDayPane();
    private PerDayPane stunningFistPane = new PerDayPane();
    private PerDayPane wholenessPane = new PerDayPane();
    private PerDayPane wildshapePane = new PerDayPane();
    private RagePane ragePane = new RagePane();
    private SavingThrowPane savingThrowPane = new SavingThrowPane();
    private SkillsPane skillsPane = new SkillsPane();
    private MasterTurnPane turnPane = new MasterTurnPane();
    private UnarmedPane unarmedPane = new UnarmedPane();
    private WeaponListPane weaponListPane = new WeaponListPane();
    private JPanel col2Panel = new JPanel();
    private JPanel bufferPanel = new JPanel();
    private int serial = 0;
    private int bufferSize = 1;

    public Page1Panel() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                Page1Panel.this.updateBuffer();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                Page1Panel.this.updateBuffer();
            }

            public void componentResized(ComponentEvent componentEvent) {
                Page1Panel.this.updateBuffer();
            }

            public void componentShown(ComponentEvent componentEvent) {
                Page1Panel.this.updateBuffer();
            }
        });
        CharacterSheetUtils.addGbComponentCell(this, this.detailsPane, 0, 0, 1, 3, new Insets(0, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this, this.attributePane, 0, 1, 3, 1, new Insets(0, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.combatPane1, 1, 1, 1, 2, new Insets(5, 3, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.combatPane2, 1, 2, 1, 1, new Insets(0, 3, 0, 0), 0, 18);
        CharacterSheetUtils.addGbComponentCell(this, this.savingThrowPane, 0, 4, 1, 2, new Insets(1, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.baseAttackPane, 0, 5, 1, 2, new Insets(1, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.unarmedPane, 0, 6, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.weaponListPane, 0, 7, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.armorPane, 0, 8, 1, 2, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.shieldPane, 0, 9, 1, 2, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.itemPane, 0, 10, 1, 2, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.ragePane, 0, 11, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.layOnHandsPane, 0, 12, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.stunningFistPane, 0, 13, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.wholenessPane, 0, 14, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        CharacterSheetUtils.addGbComponentCell(this, this.wildshapePane, 0, 15, 1, 2, new Insets(5, 0, 0, 0), 2, 17);
        this.col2Panel.setLayout(new GridBagLayout());
        CharacterSheetUtils.addGbComponentCell(this, this.col2Panel, 2, 2, 14, 1, new Insets(5, 5, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this.col2Panel, this.skillsPane, 0, 0, 1, 1, new Insets(0, 0, 0, 0), 0, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2Panel, this.turnPane, 0, 1, 1, 1, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this.col2Panel, this.musicPane, 0, 2, 1, 1, new Insets(5, 0, 0, 0), 2, 17);
        this.bufferPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.bufferPanel.setPreferredSize(new Dimension(20, this.bufferSize));
        CharacterSheetUtils.addGbComponentCell(this.col2Panel, this.bufferPanel, 0, 3, 1, 1, new Insets(5, 0, 0, 0), 0, 17);
    }

    public void setColor() {
        this.setLocalColor();
        this.armorPane.setColor();
        this.shieldPane.setColor();
        this.itemPane.setColor();
        this.attributePane.setColor();
        this.baseAttackPane.setColor();
        this.combatPane1.setColor();
        this.combatPane2.setColor();
        this.detailsPane.setColor();
        this.musicPane.setColor();
        this.layOnHandsPane.setColor();
        this.stunningFistPane.setColor();
        this.wholenessPane.setColor();
        this.wildshapePane.setColor();
        this.ragePane.setColor();
        this.savingThrowPane.setColor();
        this.skillsPane.setColor();
        this.turnPane.setColor();
        this.unarmedPane.setColor();
        this.weaponListPane.setColor();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.col2Panel.setBackground(CharacterPanel.white);
        this.bufferPanel.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.armorPane.setPc(playerCharacter, "ARMOR");
            this.shieldPane.setPc(playerCharacter, "SHIELD");
            this.attributePane.setPc(playerCharacter);
            this.baseAttackPane.setPc(playerCharacter);
            this.combatPane1.setPc(playerCharacter, properties);
            this.combatPane2.setPc(playerCharacter);
            this.detailsPane.setPc(playerCharacter);
            this.itemPane.setPc(playerCharacter, "ITEM");
            this.layOnHandsPane.setPc(playerCharacter, properties, "LayOnHands", "LAY ON HANDS", "HP per day");
            this.musicPane.setPc(playerCharacter, properties);
            this.ragePane.setPc(playerCharacter, properties);
            this.savingThrowPane.setPc(playerCharacter);
            this.skillsPane.setPc(playerCharacter);
            this.stunningFistPane.setPc(playerCharacter, properties, "StunningFistAttack", "StunningFistDC", "STUNNING FIST", "DC");
            this.turnPane.setPc(playerCharacter, properties);
            this.unarmedPane.setPc(playerCharacter);
            this.weaponListPane.setPc(playerCharacter);
            this.wholenessPane.setPc(playerCharacter, properties, "WholenessBody", "WHOLENESS OF BODY", "HP per day");
            this.wildshapePane.setPc(playerCharacter, properties, "Wildshape", "DRUID WILDSHAPE", "Uses per day");
            this.updateBuffer();
        }
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.armorPane.refresh();
            this.shieldPane.refresh();
            this.attributePane.refresh();
            this.baseAttackPane.refresh();
            this.combatPane1.refresh();
            this.combatPane2.refresh();
            this.detailsPane.refresh();
            this.itemPane.refresh();
            this.layOnHandsPane.refresh();
            this.musicPane.refresh();
            this.ragePane.refresh();
            this.savingThrowPane.refresh();
            this.skillsPane.refresh();
            this.stunningFistPane.refresh();
            this.turnPane.refresh();
            this.unarmedPane.refresh();
            this.weaponListPane.refresh();
            this.wholenessPane.refresh();
            this.wildshapePane.refresh();
            this.serial = this.pc.getSerial();
        }
        this.updateBuffer();
    }

    public void updateProperties() {
        this.combatPane1.updateProperties();
        this.turnPane.updateProperties();
        this.ragePane.updateProperties();
        this.musicPane.updateProperties();
        this.layOnHandsPane.updateProperties();
        this.stunningFistPane.updateProperties();
        this.wholenessPane.updateProperties();
        this.wildshapePane.updateProperties();
    }

    private void updateBuffer() {
        int n = this.skillsPane.getHeight() + this.turnPane.getHeight() + this.musicPane.getHeight() + this.combatPane1.getHeight() - this.attributePane.getHeight();
        int n2 = this.savingThrowPane.getHeight() + this.baseAttackPane.getHeight() + this.unarmedPane.getHeight() + this.weaponListPane.getHeight() + this.armorPane.getHeight() + this.shieldPane.getHeight() + this.itemPane.getHeight() + this.ragePane.getHeight() + this.layOnHandsPane.getHeight() + this.stunningFistPane.getHeight() + this.wholenessPane.getHeight() + this.wildshapePane.getHeight();
        int n3 = n2 - n;
        if (n3 > 0) {
            this.bufferSize = n3;
            this.bufferPanel.setBackground(CharacterPanel.white);
            this.bufferPanel.setPreferredSize(new Dimension(20, this.bufferSize + 10));
        }
    }

    public void destruct() {
        this.armorPane.destruct();
        this.shieldPane.destruct();
        this.itemPane.destruct();
        this.attributePane.destruct();
        this.baseAttackPane.destruct();
        this.combatPane1.destruct();
        this.combatPane2.destruct();
        this.detailsPane.destruct();
        this.musicPane.destruct();
        this.layOnHandsPane.destruct();
        this.stunningFistPane.destruct();
        this.wholenessPane.destruct();
        this.wildshapePane.destruct();
        this.ragePane.destruct();
        this.savingThrowPane.destruct();
        this.skillsPane.destruct();
        this.turnPane.destruct();
        this.unarmedPane.destruct();
        this.weaponListPane.destruct();
        this.armorPane = null;
        this.shieldPane = null;
        this.itemPane = null;
        this.attributePane = null;
        this.baseAttackPane = null;
        this.combatPane1 = null;
        this.combatPane2 = null;
        this.detailsPane = null;
        this.musicPane = null;
        this.layOnHandsPane = null;
        this.stunningFistPane = null;
        this.wholenessPane = null;
        this.wildshapePane = null;
        this.ragePane = null;
        this.savingThrowPane = null;
        this.skillsPane = null;
        this.turnPane = null;
        this.unarmedPane = null;
        this.weaponListPane = null;
        this.removeAll();
    }

    public void clear() {
        this.weaponListPane.clear();
    }
}

