/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.plugin.PlayerCharacterOutput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SkillUtilities;
import pcgen.core.analysis.QualifiedName;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.util.enumeration.Visibility;
import plugin.charactersheet.CharacterSheetUtils;
import plugin.charactersheet.gui.CharacterPanel;

public class SkillsPane
extends JPanel {
    private PlayerCharacter pc;
    private List<Component> componentList = new ArrayList<Component>();
    private static final String BLANK = "";
    private static final String STAR = "*";
    private static final String PLUS = "+";
    private static final String EQUALS = "=";
    private static final String X = "X";
    private static final String SKILLS = "SKILLS";
    private static final String MAX_RANKS = "Max Ranks";
    private static final String N14_7 = "14/7";
    private static final String KEY = "Key";
    private static final String SKILL = "Skill";
    private static final String ABILITY = "Ability";
    private static final String MISC = "Misc";
    private static final String SKILL_NAME = "SKILL NAME";
    private static final String MOD = "Mod";
    private static final String RANKS = "Ranks";
    private static final String SKILL_TOKEN = "SKILL";
    private static final String ABMOD_TOKEN = "ABMOD";
    private static final String MISC_TOKEN = "MISC";
    private static final Font FONT_SIXTEEN = new Font("Dialog", 1, 16);
    private static final Font FONT_TWELVE = new Font("Dialog", 0, 12);
    private static final Font FONT_TEN = new Font("Dialog", 0, 10);
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel11;
    private JPanel jPanel13;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;

    public SkillsPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel22 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jPanel23 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jPanel21 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel16 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jPanel17 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jPanel18 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jPanel19 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel20 = new JPanel();
        this.jLabel12 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 1000));
        this.jPanel5.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel2.setFont(FONT_SIXTEEN);
        this.jLabel2.setText(SKILLS);
        this.jPanel5.add(this.jLabel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel22.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel14.setFont(FONT_TEN);
        this.jLabel14.setText(MAX_RANKS);
        this.jPanel22.add(this.jLabel14);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jPanel22, gridBagConstraints);
        this.jPanel23.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel15.setText(N14_7);
        this.jPanel23.add(this.jLabel15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.jPanel23, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel6.setFont(FONT_TEN);
        this.jLabel6.setText(KEY);
        this.jPanel9.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel11.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel4.setFont(FONT_TEN);
        this.jLabel4.setText(SKILL);
        this.jPanel11.add(this.jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel13.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel7.setFont(FONT_TEN);
        this.jLabel7.setText(ABILITY);
        this.jPanel13.add(this.jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jPanel13, gridBagConstraints);
        this.jPanel21.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel13.setFont(FONT_TEN);
        this.jLabel13.setText(MISC);
        this.jPanel21.add(this.jLabel13);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jPanel21, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel5.setFont(FONT_TWELVE);
        this.jLabel5.setText(SKILL_NAME);
        this.jPanel6.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel16.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel16.setFont(FONT_TEN);
        this.jLabel16.setText(ABILITY);
        this.jPanel16.add(this.jLabel16);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jPanel16, gridBagConstraints);
        this.jPanel17.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel9.setFont(FONT_TEN);
        this.jLabel9.setText(MOD);
        this.jPanel17.add(this.jLabel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel17, gridBagConstraints);
        this.jPanel18.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel10.setFont(FONT_TEN);
        this.jLabel10.setText(MOD);
        this.jPanel18.add(this.jLabel10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel18, gridBagConstraints);
        this.jPanel19.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel11.setFont(FONT_TEN);
        this.jLabel11.setText(RANKS);
        this.jPanel19.add(this.jLabel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel19, gridBagConstraints);
        this.jPanel20.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel12.setFont(FONT_TEN);
        this.jLabel12.setText(MOD);
        this.jPanel20.add(this.jLabel12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel20, gridBagConstraints);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.header);
        this.setBorder(new LineBorder(CharacterPanel.border, 2));
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel22.setBackground(CharacterPanel.header);
        this.jPanel23.setBackground(CharacterPanel.header);
        this.jPanel9.setBackground(CharacterPanel.header);
        this.jPanel11.setBackground(CharacterPanel.header);
        this.jPanel13.setBackground(CharacterPanel.header);
        this.jPanel21.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.jPanel16.setBackground(CharacterPanel.header);
        this.jPanel17.setBackground(CharacterPanel.header);
        this.jPanel18.setBackground(CharacterPanel.header);
        this.jPanel19.setBackground(CharacterPanel.header);
        this.jPanel20.setBackground(CharacterPanel.header);
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    public synchronized void refresh() {
        int n;
        PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(this.pc);
        String string = SkillUtilities.maxCrossClassSkillForLevel((int)this.pc.getTotalLevels(), (PlayerCharacter)this.pc).toString();
        String string2 = SkillUtilities.maxClassSkillForLevel((int)this.pc.getTotalLevels(), (PlayerCharacter)this.pc).toString();
        this.jLabel15.setText(string2 + '/' + string);
        int n2 = SettingsHandler.getIncludeSkills();
        if (n2 == 3) {
            n2 = SettingsHandler.getSkillsTab_IncludeSkills();
        }
        this.pc.populateSkills(n2);
        List list = this.pc.getSkillListInOutputOrder(this.pc.getPartialSkillList(Visibility.OUTPUT_ONLY));
        for (n = 0; n < this.componentList.size(); n += 1) {
            Component component = this.componentList.get(n);
            if (component == null) continue;
            this.remove(component);
        }
        this.componentList.clear();
        n = 1;
        int n3 = 3;
        for (int i = 0; i < list.size(); ++i) {
            Skill skill = (Skill)list.get(i);
            String string3 = BLANK;
            if (((Boolean)skill.getSafe(ObjectKey.USE_UNTRAINED)).booleanValue()) {
                string3 = STAR;
            } else if (((Boolean)skill.getSafe(ObjectKey.EXCLUSIVE)).booleanValue()) {
                string3 = X;
            }
            String string4 = QualifiedName.qualifiedName((PlayerCharacter)this.pc, (Skill)skill);
            String string5 = skill.getKeyStatAbb();
            String string6 = Integer.toString(SkillRankControl.getTotalRank((PlayerCharacter)this.pc, (Skill)skill).intValue() + SkillModifier.modifier((Skill)skill, (PlayerCharacter)this.pc));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SKILL_TOKEN).append('.').append(i).append('.').append(ABMOD_TOKEN);
            String string7 = playerCharacterOutput.getExportToken(stringBuffer.toString());
            String string8 = SkillRankControl.getTotalRank((PlayerCharacter)this.pc, (Skill)skill).toString();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(SKILL_TOKEN).append('.').append(i).append('.').append(MISC_TOKEN);
            String string9 = playerCharacterOutput.getExportToken(stringBuffer2.toString());
            n3 = this.addLine(n != 0, n3, string3, CharacterSheetUtils.getTitle(string4), CharacterSheetUtils.getSubTitle(string4), string5, string6, string7, string8, string9);
            n = n != 0 ? 0 : 1;
            ++n3;
        }
        this.pc.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills());
        this.revalidate();
        this.repaint();
    }

    private int addLine(boolean bl, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Color color;
        Color color2;
        if (bl) {
            color2 = CharacterPanel.bodyLight;
            color = CharacterPanel.bodyMedLight;
        } else {
            color2 = CharacterPanel.bodyMedLight;
            color = CharacterPanel.bodyMedDark;
        }
        CharacterSheetUtils.addGbCell(this, string, 0, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string2, 1, n, 1, 1, 1, 17, 0, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string4, 2, n, 1, 1, 1, 13, 2, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string5, 3, n, 1, 1, 1, 10, 1, color, this.componentList);
        CharacterSheetUtils.addGbCell(this, EQUALS, 4, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string6, 5, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, PLUS, 6, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string7, 7, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, PLUS, 8, n, 1, 1, 1, 10, 1, color2, this.componentList);
        CharacterSheetUtils.addGbCell(this, string8, 9, n, 1, 1, 1, 10, 1, color2, this.componentList);
        if (!string3.equals(BLANK)) {
            CharacterSheetUtils.addGbCell(this, BLANK, 0, ++n, 1, 1, 1, 10, 1, color2, this.componentList);
            CharacterSheetUtils.addGbCell(this, string3, 1, n, 1, 2, 1, 17, 0, color2, this.componentList);
            CharacterSheetUtils.addGbCell(this, BLANK, 3, n, 1, 1, 1, 10, 1, color, this.componentList);
            CharacterSheetUtils.addGbCell(this, BLANK, 4, n, 1, 7, 1, 10, 1, color2, this.componentList);
        }
        return n;
    }

    public void destruct() {
    }
}

