/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.WeightToken;
import plugin.charactersheet.gui.CharacterPanel;

public class WeightPane
extends JPanel {
    private PlayerCharacter pc;
    private JPanel weightAllowancePanel;
    private JPanel weightPanel;
    private JPanel lightPanel;
    private JPanel lightValuePanel;
    private JLabel light;
    private JPanel mediumPanel;
    private JPanel mediumValuePanel;
    private JLabel medium;
    private JPanel heavyPanel;
    private JPanel heavyValuePanel;
    private JLabel heavy;
    private JPanel liftHeadPanel;
    private JPanel liftHeadValuePanel;
    private JLabel liftHead;
    private JPanel liftGroundPanel;
    private JPanel liftGroundValuePanel;
    private JLabel liftGround;
    private JPanel dragPanel;
    private JPanel dragValuePanel;
    private JLabel drag;
    private static final String DIALOG = "Dialog";
    private static final String SPACE = " ";
    private static final String WEIGHT_ALLOWANCE = "WEIGHT ALLOWANCE";
    private static final String LIGHT = "Light";
    private static final String MEDIUM = "Medium";
    private static final String HEAVY = "Heavy";
    private static final String LIFT_HEAD = "Lift Over Head";
    private static final String LIFT_GROUND = "Lift Off Ground";
    private static final String PUSH_DRAG = "Push / Drag";
    private static final Font FONT_TEN = new Font("Dialog", 0, 10);

    public WeightPane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.weightAllowancePanel = new JPanel();
        this.weightPanel = new JPanel();
        this.lightPanel = new JPanel();
        this.lightValuePanel = new JPanel();
        this.light = new JLabel();
        this.mediumPanel = new JPanel();
        this.mediumValuePanel = new JPanel();
        this.medium = new JLabel();
        this.heavyPanel = new JPanel();
        this.heavyValuePanel = new JPanel();
        this.heavy = new JLabel();
        this.liftHeadPanel = new JPanel();
        this.liftHeadValuePanel = new JPanel();
        this.liftHead = new JLabel();
        this.liftGroundPanel = new JPanel();
        this.liftGroundValuePanel = new JPanel();
        this.liftGround = new JLabel();
        this.dragPanel = new JPanel();
        this.dragValuePanel = new JPanel();
        this.drag = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel();
        this.weightAllowancePanel.setLayout(new FlowLayout(1, 0, 0));
        jLabel.setFont(new Font(DIALOG, 1, 14));
        jLabel.setText(WEIGHT_ALLOWANCE);
        this.weightAllowancePanel.add(jLabel);
        this.add(this.weightAllowancePanel);
        this.weightPanel.setLayout((LayoutManager)new GridBoxLayout(2, 6));
        JLabel jLabel2 = new JLabel();
        this.lightPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel2.setFont(FONT_TEN);
        jLabel2.setText(LIGHT);
        this.lightPanel.add(jLabel2);
        this.weightPanel.add(this.lightPanel);
        this.lightValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.light.setFont(FONT_TEN);
        this.light.setText(SPACE);
        this.lightValuePanel.add(this.light);
        this.weightPanel.add(this.lightValuePanel);
        JLabel jLabel3 = new JLabel();
        this.mediumPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel3.setFont(FONT_TEN);
        jLabel3.setText(MEDIUM);
        this.mediumPanel.add(jLabel3);
        this.weightPanel.add(this.mediumPanel);
        this.mediumValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.medium.setFont(FONT_TEN);
        this.medium.setText(SPACE);
        this.mediumValuePanel.add(this.medium);
        this.weightPanel.add(this.mediumValuePanel);
        JLabel jLabel4 = new JLabel();
        this.heavyPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel4.setFont(FONT_TEN);
        jLabel4.setText(HEAVY);
        this.heavyPanel.add(jLabel4);
        this.weightPanel.add(this.heavyPanel);
        this.heavyValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.heavy.setFont(FONT_TEN);
        this.heavy.setText(SPACE);
        this.heavyValuePanel.add(this.heavy);
        this.weightPanel.add(this.heavyValuePanel);
        JLabel jLabel5 = new JLabel();
        this.liftHeadPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel5.setFont(FONT_TEN);
        jLabel5.setText(LIFT_HEAD);
        this.liftHeadPanel.add(jLabel5);
        this.weightPanel.add(this.liftHeadPanel);
        this.liftHeadValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.liftHead.setFont(new Font(DIALOG, 0, 10));
        this.liftHead.setText(SPACE);
        this.liftHeadValuePanel.add(this.liftHead);
        this.weightPanel.add(this.liftHeadValuePanel);
        JLabel jLabel6 = new JLabel();
        this.liftGroundPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel6.setFont(FONT_TEN);
        jLabel6.setText(LIFT_GROUND);
        this.liftGroundPanel.add(jLabel6);
        this.weightPanel.add(this.liftGroundPanel);
        this.liftGroundValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.liftGround.setFont(FONT_TEN);
        this.liftGround.setText(SPACE);
        this.liftGroundValuePanel.add(this.liftGround);
        this.weightPanel.add(this.liftGroundValuePanel);
        JLabel jLabel7 = new JLabel();
        this.dragPanel.setLayout(new FlowLayout(2, 3, 0));
        jLabel7.setFont(FONT_TEN);
        jLabel7.setText(PUSH_DRAG);
        this.dragPanel.add(jLabel7);
        this.weightPanel.add(this.dragPanel);
        this.dragValuePanel.setLayout(new FlowLayout(0, 3, 0));
        this.drag.setFont(FONT_TEN);
        this.drag.setText(SPACE);
        this.dragValuePanel.add(this.drag);
        this.weightPanel.add(this.dragValuePanel);
        this.add(this.weightPanel);
    }

    public void setColor() {
        this.setBackground(CharacterPanel.header);
        this.weightPanel.setBackground(CharacterPanel.border);
        this.weightAllowancePanel.setBackground(CharacterPanel.header);
        this.lightPanel.setBackground(CharacterPanel.bodyMedLight);
        this.liftHeadPanel.setBackground(CharacterPanel.bodyMedLight);
        this.lightValuePanel.setBackground(CharacterPanel.bodyLight);
        this.liftHeadValuePanel.setBackground(CharacterPanel.bodyLight);
        this.mediumPanel.setBackground(CharacterPanel.bodyMedLight);
        this.liftGroundPanel.setBackground(CharacterPanel.bodyMedLight);
        this.mediumValuePanel.setBackground(CharacterPanel.bodyLight);
        this.liftGroundValuePanel.setBackground(CharacterPanel.bodyLight);
        this.heavyPanel.setBackground(CharacterPanel.bodyMedLight);
        this.dragPanel.setBackground(CharacterPanel.bodyMedLight);
        this.heavyValuePanel.setBackground(CharacterPanel.bodyLight);
        this.dragValuePanel.setBackground(CharacterPanel.bodyLight);
        this.weightAllowancePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.lightPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.liftHeadPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.lightValuePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.liftHeadValuePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.mediumPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.liftGroundPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.mediumValuePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.liftGroundValuePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.heavyPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.dragPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.heavyValuePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.dragValuePanel.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    public void refresh() {
        this.light.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)LIGHT, (PlayerCharacter)this.pc)).doubleValue()));
        this.medium.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)MEDIUM, (PlayerCharacter)this.pc)).doubleValue()));
        this.heavy.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)HEAVY, (PlayerCharacter)this.pc)).doubleValue()));
        this.liftHead.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)"OverHead", (PlayerCharacter)this.pc)).doubleValue()));
        this.liftGround.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)"OffGround", (PlayerCharacter)this.pc)).doubleValue()));
        this.drag.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(new Double(WeightToken.getLoadToken((String)"PushDrag", (PlayerCharacter)this.pc)).doubleValue()));
    }

    public void destruct() {
    }
}

