/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import plugin.initiative.AttackModel;
import plugin.initiative.CheckModel;
import plugin.initiative.DiceRollModel;
import plugin.initiative.SaveModel;
import plugin.initiative.SkillModel;
import plugin.initiative.SpellModel;

public abstract class PObjectModel {
    protected static final int SEGMENT_POSITION_NAME = 0;
    private static final String TYPE_PREFIX_SKILL = "skill:";
    private static final String TYPE_PREFIX_CHECK = "check:";
    private static final String TYPE_PREFIX_ATTACK = "attack:";
    private static final String TYPE_PREFIX_SPELL = "spell:";
    private static final String TYPE_PREFIX_SAVE = "save:";
    private static final String TYPE_PREFIX_DICE_ROLL = "dice:";
    protected String m_name = null;
    protected String[] outputTokens = null;

    public PObjectModel(String string) {
        this.outputTokens = string.split("\\\\");
        this.m_name = this.getStringValue(this.outputTokens, 0);
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public static PObjectModel Factory(String string) {
        PObjectModel pObjectModel = null;
        if (string != null) {
            if (string.startsWith(TYPE_PREFIX_SKILL)) {
                pObjectModel = new SkillModel(string.substring(TYPE_PREFIX_SKILL.length()));
            } else if (string.startsWith(TYPE_PREFIX_CHECK)) {
                pObjectModel = new CheckModel(string.substring(TYPE_PREFIX_CHECK.length()));
            } else if (string.startsWith(TYPE_PREFIX_ATTACK)) {
                pObjectModel = new AttackModel(string.substring(TYPE_PREFIX_ATTACK.length()));
            } else if (string.startsWith(TYPE_PREFIX_SPELL)) {
                pObjectModel = new SpellModel(string.substring(TYPE_PREFIX_SPELL.length()));
            } else if (string.startsWith(TYPE_PREFIX_SAVE)) {
                pObjectModel = new SaveModel(string.substring(TYPE_PREFIX_SAVE.length()));
            } else if (string.startsWith(TYPE_PREFIX_DICE_ROLL)) {
                pObjectModel = new DiceRollModel(string.substring(TYPE_PREFIX_DICE_ROLL.length()));
            }
        }
        return pObjectModel;
    }

    public String toString() {
        return this.getName();
    }

    protected static int getInt(String string) {
        int n = 0;
        try {
            n = string.startsWith("+") ? Integer.parseInt(string.substring(1)) : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected String getStringValue(String[] stringArray, int n) {
        String string = "";
        if (stringArray.length > n) {
            string = stringArray[n];
        }
        return string;
    }
}

