/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.io.SimpleFileFilter;
import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.Event;
import gmgen.plugin.InfoCharacterDetails;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.Spell;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.CombatantUpdatedMessage;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.NumberFormatter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.util.Logging;
import plugin.initiative.AttackModel;
import plugin.initiative.CheckModel;
import plugin.initiative.DiceRollModel;
import plugin.initiative.InitOutputter;
import plugin.initiative.PObjectModel;
import plugin.initiative.SaveModel;
import plugin.initiative.SpellModel;
import plugin.initiative.XMLCombatant;
import plugin.initiative.gui.AddCombatant;
import plugin.initiative.gui.AttackDialog;
import plugin.initiative.gui.CastSpell;
import plugin.initiative.gui.CheckDialog;
import plugin.initiative.gui.DamageDialog;
import plugin.initiative.gui.DiceRollDialog;
import plugin.initiative.gui.OpposedCheckDialog;
import plugin.initiative.gui.SavingThrowDialog;
import plugin.initiative.gui.StartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initiative
extends JPanel {
    public InitHolderList initList = new InitHolderList();
    private Combatant copyCombatant;
    private JButton bAddCombatant;
    private JButton bCast = new JButton();
    private JButton bOpposedSkill = new JButton();
    private JButton bCombatantReRoll;
    private JButton bDamage = new JButton();
    private JButton bDelete;
    private JButton bEvent = new JButton();
    private JButton bHeal = new JButton();
    private JButton bKill = new JButton();
    private JButton bNextInit;
    private JButton bRaise = new JButton();
    private JButton bRefocus;
    private JButton bRoll;
    private JButton bRefresh = new JButton();
    private JButton bDuplicateCombatant = new JButton();
    private JButton bSave = new JButton();
    private JButton bStabilize = new JButton();
    private JCheckBox showDead = new JCheckBox();
    private JCheckBox showEvents = new JCheckBox();
    private JCheckBoxMenuItem tablePopupCBDuration;
    private JCheckBoxMenuItem tablePopupCBHP;
    private JCheckBoxMenuItem tablePopupCBHPMax;
    private JCheckBoxMenuItem tablePopupCBInitiative;
    private JCheckBoxMenuItem tablePopupCBName;
    private JCheckBoxMenuItem tablePopupCBNumber;
    private JCheckBoxMenuItem tablePopupCBPlayer;
    private JCheckBoxMenuItem tablePopupCBPlus;
    private JCheckBoxMenuItem tablePopupCBStatus;
    private JCheckBoxMenuItem tablePopupCBType;
    private JLabel lCounter;
    private JPanel buttonPanelTop;
    private JPanel jPanel2;
    private JPopupMenu tablePopup;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollEvents;
    private FlippingSplitPane jSplitPane1;
    private JTabbedPane tpaneInfo;
    private JTable combatantTable;
    private JTextArea tpCombatInfo;
    private JToolBar topToolbar;
    private JToolBar bottomToolbar;
    private List columnList = new ArrayList();
    private LogUtilities log;
    private int currentCombat = 1;
    private int currentInit = -1;
    private int round = 0;

    public Initiative() {
        this.initComponents();
        this.initDynamicComponents();
        this.initPrefs();
        this.initTable();
        this.initLast();
        this.addTableListener();
        this.jSplitPane1.setOneTouchExpandable(true);
    }

    public void setCurrentInit(int n) {
        this.currentInit = n;
        if (this.currentInit > 0) {
            this.lCounter.setText(this.round + " (" + n + ")");
        } else {
            this.lCounter.setText("");
        }
        this.refreshTable();
    }

    public void setExitPrefs() {
        SettingsHandler.setGMGenOption((String)"Initiative.ShowDead", (boolean)this.showDead.isSelected());
        SettingsHandler.setGMGenOption((String)"Initiative.ShowEvents", (boolean)this.showEvents.isSelected());
        SettingsHandler.setGMGenOption((String)"Initiative.DividerLocation", (int)this.jSplitPane1.getDividerLocation());
    }

    public void setLog(LogUtilities logUtilities) {
        this.log = logUtilities;
        if (this.tpaneInfo.getTitleAt(0).equals("Combat")) {
            this.tpaneInfo.remove(0);
        }
    }

    public boolean isPastable() {
        return this.copyCombatant != null;
    }

    public List<InitHolder> getSelected() {
        ArrayList<InitHolder> arrayList = new ArrayList<InitHolder>();
        int n = -1;
        for (int i = 0; i < this.combatantTable.getRowCount(); ++i) {
            InitHolder initHolder;
            if ((initHolder = (InitHolder)this.initList.get(++n)).getStatus().equals("Dead") && !this.showDead.isSelected()) {
                --i;
                continue;
            }
            if (initHolder instanceof Event && !this.showEvents.isSelected()) {
                --i;
                continue;
            }
            if (!this.combatantTable.isRowSelected(i)) continue;
            arrayList.add(initHolder);
        }
        return arrayList;
    }

    public List<InitHolder> getUnSelected() {
        ArrayList<InitHolder> arrayList = new ArrayList<InitHolder>();
        int n = -1;
        for (int i = 0; i < this.combatantTable.getRowCount(); ++i) {
            InitHolder initHolder;
            if ((initHolder = (InitHolder)this.initList.get(++n)).getStatus().equals("Dead") && !this.showDead.isSelected()) {
                --i;
                continue;
            }
            if (initHolder instanceof Event && !this.showEvents.isSelected()) {
                --i;
                continue;
            }
            if (this.combatantTable.isRowSelected(i)) continue;
            arrayList.add(initHolder);
        }
        return arrayList;
    }

    public int getSelectedCount() {
        return this.getSelected().size();
    }

    public boolean isXMLCombatantSelected() {
        List<InitHolder> list = this.getSelected();
        if (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            return initHolder instanceof XMLCombatant;
        }
        return false;
    }

    public void addCombatant() {
        AddCombatant addCombatant = new AddCombatant(JOptionPane.getFrameForComponent(this), true, this);
        addCombatant.setVisible(true);
        this.refreshTable();
    }

    public void addInitHolder(InitHolder initHolder) {
        if (initHolder instanceof Combatant) {
            Combatant combatant = (Combatant)initHolder;
            if (!this.initList.isUniqueName(combatant.getName())) {
                combatant.setName(this.initList.getUniqueName(combatant.getName()));
            }
            this.addTab(combatant);
        }
        this.initList.add(initHolder);
    }

    public void addPcgCombatant(PlayerCharacter playerCharacter, String string) {
        String string2 = this.initList.getUniqueName(playerCharacter.getName());
        if (!string2.equals(playerCharacter.getName())) {
            playerCharacter.setName(string2);
            playerCharacter.setFileName("");
        }
        PcgCombatant pcgCombatant = new PcgCombatant(playerCharacter, string);
        this.initList.add((InitHolder)pcgCombatant);
        this.addTab((Combatant)pcgCombatant);
    }

    public void addTab(final Combatant combatant) {
        JTextPane jTextPane = new JTextPane();
        InfoCharacterDetails infoCharacterDetails = new InfoCharacterDetails(combatant, jTextPane);
        this.tpaneInfo.addTab(combatant.getName(), infoCharacterDetails.getScrollPane());
        jTextPane.setEditable(false);
        jTextPane.addHyperlinkListener(new HyperlinkListener(){
            private Combatant combatant;
            {
                this.combatant = combatant;
            }

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                Initiative.this.hyperLinkSelected(hyperlinkEvent, this.combatant);
            }
        });
    }

    public void applyPrefs() {
        if (SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bSave)) {
            this.bottomToolbar.add(this.bSave);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bSave)) {
            this.bottomToolbar.remove(this.bSave);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bCast)) {
            this.bottomToolbar.add(this.bCast);
            this.bottomToolbar.add(this.bEvent);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bCast)) {
            this.bottomToolbar.remove(this.bCast);
            this.bottomToolbar.remove(this.bEvent);
            this.bottomToolbar.add(this.showEvents);
        }
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true), "Dur");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true), "Status");
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bDamage)) {
            this.bottomToolbar.add(this.bDamage);
            this.bottomToolbar.add(this.bHeal);
            this.bottomToolbar.add(this.bStabilize);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bDamage)) {
            this.bottomToolbar.remove(this.bDamage);
            this.bottomToolbar.remove(this.bHeal);
            this.bottomToolbar.remove(this.bStabilize);
        }
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true), "HP");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true), "HP Max");
        this.checkAndFixColumns(SettingsHandler.getGMGenOption((String)"Initiative.doNumber", (boolean)true), "#");
        if (SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) && !this.bottomToolbar.isAncestorOf(this.bKill)) {
            this.bottomToolbar.add(this.bKill);
            this.bottomToolbar.add(this.showDead);
        }
        if (!SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) && this.bottomToolbar.isAncestorOf(this.bKill)) {
            this.bottomToolbar.remove(this.bKill);
            this.bottomToolbar.remove(this.showDead);
        }
        this.initTable();
        this.refreshTable();
        this.repaint();
    }

    public void castSpell() {
        this.castSpell("");
    }

    public void castSpell(String string) {
        List<InitHolder> list = this.getSelected();
        if (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            this.castSpell(string, initHolder, null);
            return;
        }
        this.initList.sort();
        this.refreshTable();
        this.castSpell(string, null, null);
    }

    public void castSpell(String string, InitHolder initHolder, SpellModel spellModel) {
        CastSpell castSpell = initHolder == null ? new CastSpell(JOptionPane.getFrameForComponent(this), true, this) : new CastSpell(JOptionPane.getFrameForComponent(this), true, this, initHolder.getPlayer(), initHolder.getInitiative().getCurrentInitiative());
        if (string != null) {
            castSpell.setSpellName(string);
        }
        if (spellModel != null) {
            castSpell.setSpellModel(spellModel);
        }
        castSpell.setVisible(true);
        this.refreshTable();
    }

    public void checkDeadTabs() {
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder initHolder = (InitHolder)this.initList.get(i);
            if (!initHolder.getStatus().equals("Dead")) continue;
            if (this.showDead.isSelected() && initHolder instanceof Combatant && this.tpaneInfo.indexOfTab(initHolder.getName()) == -1) {
                Combatant combatant = (Combatant)initHolder;
                this.addTab(combatant);
                continue;
            }
            this.removeTab(initHolder);
        }
    }

    public void combatantDied(InitHolder initHolder) {
        this.writeToCombatTabWithRound(initHolder.getName() + " (" + initHolder.getPlayer() + ") Killed");
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder initHolder2 = (InitHolder)this.initList.get(i);
            String string = "";
            if (initHolder2 instanceof Combatant) {
                Combatant combatant = (Combatant)initHolder2;
                string = combatant.getCombatantType();
            }
            if (!string.equals("Enemy") || initHolder2.getStatus().equals("Dead")) continue;
            return;
        }
        this.writeToCombatTabWithRound("Combat finished, all enemies killed");
        this.checkDeadTabs();
    }

    public void copy() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            this.copyCombatant = (Combatant)initHolder;
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void damageCombatant() {
        int n = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Subdual", (int)1);
        DamageDialog damageDialog = new DamageDialog((Frame)GMGenSystem.inst, true);
        damageDialog.setVisible(true);
        damageDialog.dispose();
        int n2 = damageDialog.getReturn();
        if (n2 == 0) {
            int n3 = damageDialog.getDamage();
            if (damageDialog.getSubdual()) {
                if (n == 1) {
                    this.doSubdual(n3);
                } else if (n == 2) {
                    this.doNonLethal(n3);
                }
            } else {
                this.doDamage(n3);
            }
        }
    }

    public void deleteCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            try {
                InitHolder initHolder = list.remove(0);
                this.initList.remove((Object)initHolder);
                this.removeTab(initHolder);
            }
            catch (Exception exception) {}
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doDamage(int n) {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            this.doDamage(n, list.remove(0));
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doDamage(int n, InitHolder initHolder) {
        if (initHolder instanceof Combatant) {
            Combatant combatant = (Combatant)initHolder;
            String string = combatant.getStatus();
            combatant.damage(n);
            String string2 = combatant.getStatus();
            this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Took " + n + " Damage: " + combatant.getHP().getCurrent() + "/" + combatant.getHP().getMax());
            this.doMassiveDamage(combatant, n);
            if (!string.equals(string2) && string2.equals("Dead")) {
                this.combatantDied((InitHolder)combatant);
            }
        }
    }

    public void doHeal(int n) {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.heal(n);
            Initiative.combatantUpdated(combatant);
            this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Gained " + n + " Healing: " + combatant.getHP().getCurrent() + "/" + combatant.getHP().getMax());
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doMassiveDamage(Combatant combatant, int n) {
        int n2 = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Massive.Type", (int)2);
        boolean bl = false;
        if (n2 == 2) {
            bl = SystemHP.isDndMassive((Combatant)combatant, (int)n);
        } else if (n2 == 3) {
            bl = SystemHP.isD20ModernMassive((Combatant)combatant, (int)n);
        } else if (n2 == 4) {
            bl = SystemHP.isHouseHalfMassive((Combatant)combatant, (int)n);
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            SavingThrowDialog savingThrowDialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, combatant, 15, 1);
            savingThrowDialog.setVisible(true);
            savingThrowDialog.dispose();
            int n3 = savingThrowDialog.getReturnValue();
            int n4 = savingThrowDialog.getRoll();
            int n5 = savingThrowDialog.getTotal();
            int n6 = savingThrowDialog.getDC();
            stringBuffer.append(savingThrowDialog.getSaveAbbrev(savingThrowDialog.getSaveType()));
            stringBuffer.append(" save DC " + n6);
            if (n4 > 0) {
                stringBuffer.append(" with a roll of " + (n4 + n5));
                stringBuffer.append(" (" + n5 + " + Roll: " + n4 + ")");
            }
            if (n3 == 1) {
                this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Passed a " + stringBuffer + " to avoid massive damage effects");
            } else if (n3 == 2) {
                this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Failed a " + stringBuffer + " to avoid massive damage effects");
                int n7 = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Massive.Effect", (int)1);
                if (n7 == 1) {
                    combatant.kill();
                    this.combatantDied((InitHolder)combatant);
                } else if (n7 == 2) {
                    SystemHP systemHP = combatant.getHP();
                    int n8 = systemHP.getCurrent();
                    combatant.damage(n8 + 1);
                } else if (n7 == 3) {
                    SystemHP systemHP = combatant.getHP();
                    int n9 = systemHP.getMax();
                    combatant.damage(n9 / 2);
                } else if (n7 == 4) {
                    SystemHP systemHP = combatant.getHP();
                    int n10 = systemHP.getCurrent();
                    combatant.damage(n10 / 2);
                }
            }
        }
        Initiative.combatantUpdated(combatant);
    }

    public void doNonLethal(int n) {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            this.doNonLethal(n, initHolder);
        }
    }

    public void doNonLethal(int n, InitHolder initHolder) {
        if (initHolder instanceof Combatant) {
            Object object;
            Object object2;
            Combatant combatant = (Combatant)initHolder;
            boolean bl = false;
            if (combatant instanceof XMLCombatant && n > (object2 = (XMLCombatant)combatant).getHP().getAttribute().getValue()) {
                bl = true;
            }
            if (combatant instanceof PcgCombatant) {
                object2 = (PcgCombatant)combatant;
                object = object2.getPC();
                Globals.setCurrentPC((PlayerCharacter)object);
                StatList statList = object.getStatList();
                if (n > statList.getTotalStatFor("CON")) {
                    bl = true;
                }
            }
            if (bl) {
                object2 = new StringBuffer();
                object = new SavingThrowDialog((Frame)GMGenSystem.inst, true, combatant, 15, 1);
                ((Dialog)object).setVisible(true);
                ((Window)object).dispose();
                int n2 = ((SavingThrowDialog)object).getReturnValue();
                int n3 = ((SavingThrowDialog)object).getRoll();
                int n4 = ((SavingThrowDialog)object).getTotal();
                int n5 = ((SavingThrowDialog)object).getDC();
                ((StringBuffer)object2).append(((SavingThrowDialog)object).getSaveAbbrev(((SavingThrowDialog)object).getSaveType()));
                ((StringBuffer)object2).append(" save DC " + n5);
                if (n3 > 0) {
                    ((StringBuffer)object2).append(" with a roll of " + (n3 + n4));
                    ((StringBuffer)object2).append(" (" + n4 + " + Roll: " + n3 + ")");
                }
                if (n2 == 1) {
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Passed a " + object2 + " to avoid unconsiousness");
                    combatant.nonLethalDamage(false);
                } else if (n2 == 2) {
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Failed a " + object2 + " to avoid unconsiousness");
                    combatant.nonLethalDamage(true);
                }
            }
            Initiative.combatantUpdated(combatant);
        }
    }

    public void doSetCombatantType(String string) {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.setCombatantType(string);
            Initiative.combatantUpdated(combatant);
        }
        this.refreshTable();
    }

    public void doSubdual(int n) {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            this.doSubdual(n, initHolder);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void doSubdual(int n, InitHolder initHolder) {
        if (initHolder instanceof Combatant) {
            Combatant combatant = (Combatant)initHolder;
            combatant.subdualDamage(n);
            Initiative.combatantUpdated(combatant);
            this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Took " + n + " Subdual Damage: " + combatant.getHP().getCurrent() + "(" + combatant.getHP().getSubdual() + "s)/" + combatant.getHP().getMax());
        }
    }

    public void focusNextInit() {
        this.bNextInit.grabFocus();
    }

    public void focusRoll() {
        this.bRoll.grabFocus();
    }

    public void healCombatant() {
        String string = JOptionPane.showInputDialog(this, "Heal", Integer.toString(1));
        if (string != null) {
            try {
                this.doHeal(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.healCombatant();
            }
        }
    }

    public void initLast() {
        int n = SettingsHandler.getGMGenOption((String)"Initiative.DividerLocation", (int)400);
        this.jSplitPane1.setDividerLocation(n);
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true)) {
            this.bottomToolbar.add(this.bCast);
            this.bottomToolbar.add(this.bEvent);
            this.bottomToolbar.add(this.showEvents);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doCombat", (boolean)true)) {
            this.bottomToolbar.add(this.bSave);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.bottomToolbar.add(this.bDamage);
            this.bottomToolbar.add(this.bHeal);
            this.bottomToolbar.add(this.bStabilize);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true)) {
            this.bottomToolbar.add(this.bKill);
            this.bottomToolbar.add(this.bRaise);
            this.bottomToolbar.add(this.showDead);
        }
        boolean bl = SettingsHandler.getGMGenOption((String)"Initiative.ShowDead", (boolean)false);
        this.showDead.setSelected(bl);
        boolean bl2 = SettingsHandler.getGMGenOption((String)"Initiative.ShowEvents", (boolean)true);
        this.showEvents.setSelected(bl2);
    }

    public void initPrefs() {
        Double d;
        boolean bl = SettingsHandler.getGMGenOption((String)"Initiative.arePrefsSet", (boolean)false);
        if (!bl) {
            SettingsHandler.setGMGenOption((String)"Initiative.arePrefsSet", (boolean)true);
        }
        if ((d = SettingsHandler.getGMGenOption((String)"Initiative.Version", (double)0.0)) < 1.0 || !bl) {
            SettingsHandler.setGMGenOption((String)"Initiative.doSpells", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doDeath", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doHP", (boolean)true);
            SettingsHandler.setGMGenOption((String)"Initiative.doMaxHP", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.doMaxNum", (int)20);
            SettingsHandler.setGMGenOption((String)"Initiative.doNum", (int)20);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.0", (String)"#");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.0", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.1", (String)"Name");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.1", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.2", (String)"Player");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.2", (int)100);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.3", (String)"Status");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.3", (int)75);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.4", (String)"+");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.4", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.5", (String)"Init");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.5", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.6", (String)"Dur");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.6", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.7", (String)"HP");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.7", (int)25);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.8", (String)"HP Max");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.8", (int)50);
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnName.9", (String)"Type");
            SettingsHandler.setGMGenOption((String)"Initiative.ColumnWidth.9", (int)50);
            SettingsHandler.setGMGenOption((String)"Initiative.NumberOfColumns", (int)10);
            SettingsHandler.setGMGenOption((String)"Initiative.DividerLocation", (int)450);
            SettingsHandler.setGMGenOption((String)"Initiative.SubVersion", (double)1.0);
            SettingsHandler.setGMGenOption((String)"Initiative.Version", (double)1.0);
        }
    }

    public void killCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.kill();
            this.combatantDied((InitHolder)combatant);
            Initiative.combatantUpdated(combatant);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void loadFromDocument(Document document, GMBComponent gMBComponent) {
        if (document.getRootElement().getName().equals("Party")) {
            Event event;
            PcgCombatant pcgCombatant;
            XMLCombatant xMLCombatant;
            Element element = document.getRootElement();
            List list = element.getChildren("Character");
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                xMLCombatant = new XMLCombatant(element2);
                this.initList.add((InitHolder)xMLCombatant);
            }
            List list2 = element.getChildren("PcgCombatant");
            for (int i = 0; i < list2.size(); ++i) {
                xMLCombatant = (Element)list2.get(i);
                pcgCombatant = new PcgCombatant((Element)xMLCombatant, gMBComponent);
                this.initList.add((InitHolder)pcgCombatant);
                this.addTab((Combatant)pcgCombatant);
            }
            List list3 = element.getChildren("Event");
            for (int i = 0; i < list3.size(); ++i) {
                pcgCombatant = (Element)list3.get(i);
                event = new Event((Element)pcgCombatant);
                this.initList.add((InitHolder)event);
            }
            List list4 = element.getChildren("Spell");
            for (int i = 0; i < list4.size(); ++i) {
                event = (Element)list4.get(i);
                Spell spell = new Spell((Element)event);
                this.initList.add((InitHolder)spell);
            }
            this.initList.calculateNumberField();
        } else if (document.getRootElement().getName().equals("Character")) {
            Element element = document.getRootElement();
            XMLCombatant xMLCombatant = new XMLCombatant(element);
            this.initList.add((InitHolder)xMLCombatant);
        }
    }

    public void loadINIT(File file, GMBComponent gMBComponent) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            this.loadFromDocument(document, gMBComponent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "File load error: " + file.getName());
            Logging.errorPrint((String)("File Load Error" + file.getName()));
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void nextInit() {
        Event event;
        int n;
        int n2 = this.currentInit;
        this.setCurrentInit(this.currentInit - 1);
        int n3 = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Dying", (int)1);
        for (n = 0; n < this.initList.size(); ++n) {
            int n4;
            InitHolder initHolder = (InitHolder)this.initList.get(n);
            if (initHolder instanceof Event) {
                int n5;
                event = (Event)initHolder;
                n4 = event.getInitiative().getCurrentInitiative();
                if (n2 != n4 || (n5 = event.decDuration()) >= 0) continue;
                this.writeToCombatTabWithRound(event.getPlayer() + "'s " + event.getName() + " ended");
                if (event.isAlert()) {
                    JOptionPane.showMessageDialog(this, event.getEndText());
                }
                this.initList.remove(n);
                continue;
            }
            if (!(initHolder instanceof Combatant) || n2 != (n4 = (event = (Combatant)initHolder).getInitiative().getCurrentInitiative())) continue;
            event.decDuration();
            if (n3 != 2) continue;
            this.bleed((Combatant)initHolder);
        }
        if (this.currentInit <= 0) {
            n = this.initList.getMaxInit();
            this.setCurrentInit(n);
            for (int i = 0; i < this.initList.size(); ++i) {
                event = (InitHolder)this.initList.get(i);
                if (n3 == 1 && event instanceof Combatant) {
                    this.bleed((Combatant)event);
                }
                event.endRound();
            }
            ++this.round;
            this.writeToCombatTab("Round " + this.round);
            this.setCurrentInit(n);
        } else if (!this.initList.initValid(this.currentInit)) {
            this.nextInit();
        }
        this.refreshTable();
    }

    public void pasteNew(Combatant combatant) {
        Object object;
        if (combatant instanceof XMLCombatant) {
            XMLCombatant xMLCombatant = (XMLCombatant)combatant;
            SystemInitiative systemInitiative = xMLCombatant.getInitiative();
            SystemHP systemHP = xMLCombatant.getHP();
            String string = this.initList.getUniqueName(xMLCombatant.getName());
            object = new XMLCombatant(string, combatant.getPlayer(), systemInitiative.getAttribute().getValue(), systemHP.getAttribute().getValue(), systemHP.getMax(), systemHP.getCurrent(), systemHP.getSubdual(), systemInitiative.getBonus(), xMLCombatant.getCombatantType(), xMLCombatant.getCR());
            this.initList.add((InitHolder)object);
        }
        if (combatant instanceof PcgCombatant) {
            object = (PcgCombatant)combatant;
            PCGen_Frame1.getInst().loadPCFromFile(new File(object.getPC().getFileName()), false, true);
        }
        this.refreshTable();
    }

    public void pasteNew(Combatant combatant, int n) {
        for (int i = 0; i < n; ++i) {
            this.pasteNew(combatant);
        }
    }

    public void pasteNew(int n) {
        this.pasteNew(this.copyCombatant, n);
    }

    public void pasteNew() {
        this.pasteNew(this.copyCombatant);
    }

    public void performAttack(AttackModel attackModel, PcgCombatant pcgCombatant) {
        Vector<Object> vector = new Vector<Object>(this.initList.size());
        for (int i = 0; i < this.initList.size(); ++i) {
            if (!(this.initList.get(i) instanceof PcgCombatant) || this.initList.get(i) == pcgCombatant || ((InitHolder)this.initList.get(i)).getStatus().equals("Dead") && !this.showDead.isSelected()) continue;
            vector.add(this.initList.get(i));
        }
        AttackDialog attackDialog = new AttackDialog(attackModel, vector);
        attackDialog.setModal(true);
        attackDialog.setVisible(true);
        List<Integer> list = attackDialog.getDamageList();
        List list2 = attackDialog.getDamagedCombatants();
        if (list != null && list2 != null && list.size() > 0 && list2.size() > 0) {
            this.writeToCombatTabWithRound(pcgCombatant.getName() + " successfully attacks using " + attackModel);
            for (int i = 0; i < list.size() && i < list2.size(); ++i) {
                if (attackDialog.isSubdual()) {
                    int n = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Subdual", (int)1);
                    if (n == 1) {
                        this.doSubdual(list.get(i), (InitHolder)((PcgCombatant)list2.get(i)));
                        continue;
                    }
                    if (n != 2) continue;
                    this.doNonLethal(list.get(i), (InitHolder)((PcgCombatant)list2.get(i)));
                    continue;
                }
                this.doDamage(list.get(i), (InitHolder)((PcgCombatant)list2.get(i)));
            }
            this.initList.sort();
            this.refreshTable();
        } else if (list != null && list.size() > 0) {
            this.writeToCombatTabWithRound(pcgCombatant.getName() + " successfully attacks using " + attackModel);
        } else {
            this.writeToCombatTabWithRound(pcgCombatant.getName() + " fails with attack using " + attackModel);
        }
        attackDialog.dispose();
    }

    public void raiseCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            this.writeToCombatTabWithRound(initHolder.getName() + " (" + combatant.getPlayer() + ") Raised");
            combatant.raise();
            Initiative.combatantUpdated(combatant);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void refocusCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.init.refocus();
            Initiative.combatantUpdated(combatant);
            this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Refocused");
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void refreshTable() {
        this.combatantTable.clearSelection();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.combatantTable.getModel();
        defaultTableModel.setNumRows(0);
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder initHolder = (InitHolder)this.initList.get(i);
            if (initHolder.getStatus().equals("Dead") && !this.showDead.isSelected() || initHolder instanceof Event && !this.showEvents.isSelected()) continue;
            Vector vector = this.initList.getRowVector(i, this.columnList);
            defaultTableModel.addRow(vector);
            int n3 = initHolder.getInitiative().getCurrentInitiative();
            if (n3 == this.currentInit) {
                if (n == -1) {
                    n = n2;
                }
                this.combatantTable.setRowSelectionInterval(n, n2);
            }
            ++n2;
        }
        this.refreshEventTab();
    }

    public void refreshTabs() {
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder initHolder = (InitHolder)this.initList.get(i);
            if (initHolder.getStatus().equals("Dead") && !this.showDead.isSelected() || !(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            this.removeTab((InitHolder)combatant);
            this.addTab(combatant);
        }
    }

    public void removePcgCombatant(PlayerCharacter playerCharacter) {
        for (int i = 0; i < this.initList.size(); ++i) {
            PcgCombatant pcgCombatant;
            InitHolder initHolder = (InitHolder)this.initList.get(i);
            if (!(initHolder instanceof PcgCombatant) || (pcgCombatant = (PcgCombatant)initHolder).getPC() != playerCharacter) continue;
            this.initList.remove((Object)initHolder);
            this.removeTab(initHolder);
        }
    }

    public void removeTab(InitHolder initHolder) {
        try {
            this.tpaneInfo.removeTabAt(this.tpaneInfo.indexOfTab(initHolder.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeTab(String string) {
        try {
            this.tpaneInfo.removeTabAt(this.tpaneInfo.indexOfTab(string));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void rerollCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.init.check();
            this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Rerolled");
            Initiative.combatantUpdated(combatant);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void roll() {
        this.round = 0;
        this.initList.check();
        int n = this.initList.getMaxInit();
        this.writeToCombatTab("Combat Number " + this.currentCombat + ": ");
        this.writeToCombatTab("Round 1");
        ++this.currentCombat;
        this.round = 1;
        this.setCurrentInit(n);
    }

    public void rollSave() {
        List<InitHolder> list = this.getSelected();
        SaveModel saveModel = new SaveModel();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            saveModel = this.performSave(saveModel, initHolder);
        }
        this.refreshTable();
    }

    private SaveModel performSave(SaveModel saveModel, InitHolder initHolder) {
        Combatant combatant = (Combatant)initHolder;
        SavingThrowDialog savingThrowDialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, combatant, saveModel);
        savingThrowDialog.setVisible(true);
        savingThrowDialog.dispose();
        int n = savingThrowDialog.getReturnValue();
        int n2 = savingThrowDialog.getRoll();
        int n3 = savingThrowDialog.getTotal();
        saveModel = savingThrowDialog.getSaveModel();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(savingThrowDialog.getSaveAbbrev(savingThrowDialog.getSaveType()));
        stringBuffer.append(" save DC " + saveModel.getDc());
        if (n2 > 0) {
            stringBuffer.append(" with a roll of " + (n2 + n3));
            stringBuffer.append(" (" + n3 + " + Roll: " + n2 + ")");
        }
        if (n == 1) {
            this.writeToCombatTabWithRound(initHolder.getName() + " (" + initHolder.getPlayer() + ") Passed a " + stringBuffer);
        } else if (n == 2) {
            this.writeToCombatTabWithRound(initHolder.getName() + " (" + initHolder.getPlayer() + ") Failed a " + stringBuffer);
        }
        return saveModel;
    }

    public void saveToDocument(File file) throws Exception {
        Object object;
        Element element = new Element("Party");
        element.setAttribute("filever", "1.0");
        element.setAttribute("filetype", "initsave");
        for (int i = 0; i < this.initList.size(); ++i) {
            object = (InitHolder)this.initList.get(i);
            element.addContent(object.getSaveElement());
        }
        Document document = new Document(element);
        object = new InitOutputter();
        object.setEncoding("US-ASCII");
        FileWriter fileWriter = new FileWriter(file);
        object.output(document, (Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    public void saveToFile() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = SettingsHandler.getPcgPath();
        if (file.exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        String[] stringArray = new String[]{"gmi", "init"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "GMGen Initiative/Encounter Export");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        try {
            if (n == 0) {
                File file2;
                String string = jFileChooser.getSelectedFile().getName();
                String string2 = "";
                if (!string.endsWith(".gmi")) {
                    string2 = ".gmi";
                }
                if ((file2 = new File(jFileChooser.getSelectedFile().getParent() + File.separator + string + string2)).exists()) {
                    int n2 = JOptionPane.showConfirmDialog(this, "File Exists, Overwrite?", "File Exists", 0, 3);
                    if (n2 == 0) {
                        SettingsHandler.ensurePathExists((File)file2.getParentFile());
                        this.saveToDocument(file2);
                    }
                } else {
                    SettingsHandler.ensurePathExists((File)file2.getParentFile());
                    this.saveToDocument(file2);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error Writing File");
            Logging.errorPrint((String)"Error Writing File");
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void showPreferences() {
    }

    public void stabilizeCombatant() {
        List<InitHolder> list = this.getSelected();
        while (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            this.writeToCombatTabWithRound(initHolder.getName() + " (" + combatant.getPlayer() + ") Stabilized");
            combatant.stabilize();
            Initiative.combatantUpdated(combatant);
        }
        this.initList.sort();
        this.refreshTable();
    }

    public void startEvent() {
        List<InitHolder> list = this.getSelected();
        if (!list.isEmpty()) {
            InitHolder initHolder = list.remove(0);
            StartEvent startEvent = new StartEvent(JOptionPane.getFrameForComponent(this), true, this, initHolder.getPlayer(), initHolder.getInitiative().getCurrentInitiative());
            startEvent.setVisible(true);
            this.refreshTable();
            return;
        }
        this.initList.sort();
        this.refreshTable();
        StartEvent startEvent = new StartEvent(JOptionPane.getFrameForComponent(this), true, this);
        startEvent.setVisible(true);
        this.refreshTable();
    }

    public void writeToCombatTab(String string) {
        this.log.logMessage("Initiative", string);
    }

    public void writeToCombatTabWithRound(String string) {
        this.writeToCombatTab(" (Round: " + this.round + ", Init: " + this.currentInit + "): " + string);
    }

    protected void hyperLinkSelected(HyperlinkEvent hyperlinkEvent, Combatant combatant) {
        PObjectModel pObjectModel;
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (pObjectModel = PObjectModel.Factory(hyperlinkEvent.getDescription())) != null) {
            if (pObjectModel instanceof AttackModel && combatant instanceof PcgCombatant) {
                PcgCombatant pcgCombatant = (PcgCombatant)combatant;
                this.performAttack((AttackModel)pObjectModel, pcgCombatant);
            } else if (pObjectModel instanceof CheckModel) {
                this.performCheck((CheckModel)pObjectModel);
            } else if (pObjectModel instanceof SpellModel) {
                this.castSpell((SpellModel)pObjectModel, combatant);
            } else if (pObjectModel instanceof SaveModel) {
                this.performSave((SaveModel)pObjectModel, (InitHolder)combatant);
            } else if (pObjectModel instanceof DiceRollModel && combatant instanceof PcgCombatant) {
                this.performDiceRoll((DiceRollModel)pObjectModel);
            }
        }
    }

    private void performDiceRoll(DiceRollModel diceRollModel) {
        DiceRollDialog diceRollDialog = new DiceRollDialog(diceRollModel);
        diceRollDialog.setModal(true);
        diceRollDialog.setVisible(true);
        diceRollDialog.dispose();
    }

    protected void listSelectionChaned(ListSelectionEvent listSelectionEvent) {
        String string;
        int n = this.combatantTable.getSelectedRow();
        if (n >= 0 && (string = (String)this.combatantTable.getValueAt(n, this.combatantTable.getColumnModel().getColumnIndex("Name"))) != null && string.length() > 0 && this.tpaneInfo.indexOfTab(string) >= 0) {
            this.tpaneInfo.setSelectedIndex(this.tpaneInfo.indexOfTab(string));
        }
    }

    private List getColumnOrder() {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            arrayList.add(tableColumnModel.getColumn(i).getHeaderValue());
        }
        return arrayList;
    }

    private void setColumnWidths(int[] nArray) {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    private void TablePopupActionPerformed(ActionEvent actionEvent) {
        this.checkAndFixColumns(this.tablePopupCBName.getState(), "Name");
        this.checkAndFixColumns(this.tablePopupCBPlayer.getState(), "Player");
        this.checkAndFixColumns(this.tablePopupCBStatus.getState(), "Status");
        this.checkAndFixColumns(this.tablePopupCBPlus.getState(), "+");
        this.checkAndFixColumns(this.tablePopupCBInitiative.getState(), "Init");
        this.checkAndFixColumns(this.tablePopupCBDuration.getState(), "Dur");
        this.checkAndFixColumns(this.tablePopupCBHP.getState(), "HP");
        this.checkAndFixColumns(this.tablePopupCBHPMax.getState(), "HP Max");
        this.checkAndFixColumns(this.tablePopupCBNumber.getState(), "#");
        this.checkAndFixColumns(this.tablePopupCBType.getState(), "Type");
        this.refreshTable();
    }

    private void addColumn(String string, int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.combatantTable.getModel();
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        defaultTableModel.addColumn(string);
        TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1);
        tableColumn.setPreferredWidth(n);
        tableColumn.setWidth(n);
        tableColumn.setIdentifier(string);
        this.columnList = this.getColumnOrder();
    }

    private void addTableListener() {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        tableColumnModel.addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                Initiative.this.colModAdded(tableColumnModelEvent);
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                Initiative.this.colModMarginChanged(changeEvent);
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                Initiative.this.colModMoved(tableColumnModelEvent);
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                Initiative.this.colModRemoved(tableColumnModelEvent);
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                Initiative.this.colModSelectionChanged(listSelectionEvent);
            }
        });
    }

    private void bAddCombatantActionPerformed(ActionEvent actionEvent) {
        this.addCombatant();
    }

    private void bCastActionPerformed(ActionEvent actionEvent) {
        this.castSpell();
        this.focusNextInit();
    }

    private void bCombatantReRollActionPerformed(ActionEvent actionEvent) {
        this.rerollCombatant();
        this.focusNextInit();
    }

    private void bDamageActionPerformed(ActionEvent actionEvent) {
        this.damageCombatant();
        this.focusNextInit();
    }

    private void bDeleteActionPerformed(ActionEvent actionEvent) {
        this.deleteCombatant();
        this.focusNextInit();
    }

    private void bEventActionPerformed(ActionEvent actionEvent) {
        this.startEvent();
        this.focusNextInit();
    }

    private void bHealActionPerformed(ActionEvent actionEvent) {
        this.healCombatant();
        this.focusNextInit();
    }

    private void bKillActionPerformed(ActionEvent actionEvent) {
        this.killCombatant();
        this.focusNextInit();
    }

    private void bNextInitActionPerformed(ActionEvent actionEvent) {
        this.nextInit();
    }

    private void bRaiseActionPerformed(ActionEvent actionEvent) {
        this.raiseCombatant();
        this.refreshTable();
        this.focusNextInit();
    }

    private void bRefocusActionPerformed(ActionEvent actionEvent) {
        this.refocusCombatant();
        this.focusNextInit();
    }

    private void bRollActionPerformed(ActionEvent actionEvent) {
        this.roll();
        this.focusNextInit();
    }

    private void bSaveActionPerformed(ActionEvent actionEvent) {
        this.rollSave();
    }

    private void bStabilizeActionPerformed(ActionEvent actionEvent) {
        this.stabilizeCombatant();
        this.refreshTable();
        this.focusNextInit();
    }

    private void bleed(Combatant combatant) {
        if (combatant.getStatus().equals("Bleeding")) {
            int n = SettingsHandler.getGMGenOption((String)"Initiative.Damage.Stable", (int)1);
            if (n == 1) {
                int n2 = new Dice(1, 100).roll();
                if (n2 <= 10) {
                    combatant.stabilize();
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") auto-stabilized  (" + n2 + "%)");
                } else {
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") failed to auto-stabilize (" + n2 + "%)");
                }
            } else if (n == 2) {
                SavingThrowDialog savingThrowDialog = new SavingThrowDialog((Frame)GMGenSystem.inst, true, combatant, 20, 1);
                savingThrowDialog.setVisible(true);
                savingThrowDialog.dispose();
                int n3 = savingThrowDialog.getReturnValue();
                int n4 = savingThrowDialog.getRoll();
                int n5 = savingThrowDialog.getTotal();
                int n6 = savingThrowDialog.getDC();
                if (savingThrowDialog.getReturnValue() == 1) {
                    combatant.stabilize();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(savingThrowDialog.getSaveAbbrev(savingThrowDialog.getSaveType()));
                stringBuffer.append(" save DC " + n6);
                if (n4 > 0) {
                    stringBuffer.append(" with a roll of " + (n4 + n5));
                    stringBuffer.append(" (" + n5 + " + Roll: " + n4 + ")");
                }
                if (n3 == 1) {
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Passed a " + stringBuffer + " to auto-stabilize");
                } else if (n3 == 2) {
                    this.writeToCombatTabWithRound(combatant.getName() + " (" + combatant.getPlayer() + ") Failed a " + stringBuffer + " to auto-stabilize");
                }
            }
            String string = combatant.getStatus();
            combatant.bleed();
            Initiative.combatantUpdated(combatant);
            String string2 = combatant.getStatus();
            if (!string.equals(string2) && string2.equals("Dead")) {
                this.combatantDied((InitHolder)combatant);
            }
        }
    }

    private void castSpell(SpellModel spellModel, Combatant combatant) {
        this.castSpell(spellModel.getName(), (InitHolder)combatant, spellModel);
    }

    private void checkAndFixColumns(boolean bl, String string) {
        if (bl && !this.getColumnOrder().contains(string)) {
            this.addColumn(string, 100);
            this.trackTable();
        } else if (!bl && this.getColumnOrder().contains(string)) {
            this.removeColumn(string);
        }
    }

    private void performCheck(CheckModel checkModel) {
        CheckDialog checkDialog = new CheckDialog(checkModel);
        checkDialog.setModal(true);
        checkDialog.setVisible(true);
        checkDialog.dispose();
    }

    private void colModAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    private void colModMarginChanged(ChangeEvent changeEvent) {
        this.trackTable();
    }

    private void colModMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.trackTable();
    }

    private void colModRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    private void colModSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void combatantTableMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.initTablePopup();
            this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void combatantTableMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.initTablePopup();
            this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void combatantTablePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.editTableRow();
        this.refreshTable();
    }

    private void editTable(int n, int n2) {
        InitHolder initHolder = (InitHolder)this.initList.get(n);
        String string = initHolder.getName();
        Object object = this.combatantTable.getValueAt(n, n2);
        boolean bl = this.currentInit == this.initList.getMaxInit();
        initHolder.editRow(this.columnList, n2, object);
        if (!initHolder.getName().equals(string) && initHolder instanceof Combatant) {
            this.removeTab(string);
            this.addTab((Combatant)initHolder);
        }
        Initiative.initHolderUpdated(initHolder);
        this.initList.sort();
        if (bl) {
            this.setCurrentInit(this.initList.getMaxInit());
        }
        this.refreshTable();
    }

    private void editTableRow() {
        int n = this.combatantTable.getEditingRow();
        int n2 = this.combatantTable.getEditingColumn();
        if (n > -1 && n2 > -1) {
            this.editTable(n, n2);
        }
    }

    private void initComponents() {
        this.tablePopup = new JPopupMenu();
        this.tablePopupCBNumber = new JCheckBoxMenuItem();
        this.tablePopupCBName = new JCheckBoxMenuItem();
        this.tablePopupCBPlayer = new JCheckBoxMenuItem();
        this.tablePopupCBStatus = new JCheckBoxMenuItem();
        this.tablePopupCBPlus = new JCheckBoxMenuItem();
        this.tablePopupCBInitiative = new JCheckBoxMenuItem();
        this.tablePopupCBDuration = new JCheckBoxMenuItem();
        this.tablePopupCBHP = new JCheckBoxMenuItem();
        this.tablePopupCBHPMax = new JCheckBoxMenuItem();
        this.tablePopupCBType = new JCheckBoxMenuItem();
        this.topToolbar = new JToolBar();
        this.buttonPanelTop = new JPanel();
        this.bRoll = new JButton();
        this.bAddCombatant = new JButton();
        this.bNextInit = new JButton();
        this.bRefocus = new JButton();
        this.bCombatantReRoll = new JButton();
        this.bDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.lCounter = new JLabel();
        this.jSplitPane1 = new FlippingSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollEvents = new JScrollPane();
        this.combatantTable = new JTable();
        this.tpaneInfo = new JTabbedPane();
        this.tpCombatInfo = new JTextArea();
        this.tpCombatInfo.setName("Events");
        this.bottomToolbar = new JToolBar();
        this.tablePopupCBNumber.setText("#");
        this.tablePopupCBNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBNumber);
        this.tablePopupCBName.setText("Name");
        this.tablePopupCBName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBName);
        this.tablePopupCBPlayer.setText("Player");
        this.tablePopupCBPlayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBPlayer);
        this.tablePopupCBStatus.setText("Status");
        this.tablePopupCBStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBStatus);
        this.tablePopupCBPlus.setText("Plus");
        this.tablePopupCBPlus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBPlus);
        this.tablePopupCBInitiative.setText("Initiative");
        this.tablePopupCBInitiative.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBInitiative);
        this.tablePopupCBDuration.setText("Duration");
        this.tablePopupCBDuration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBDuration);
        this.tablePopupCBHP.setText("HP");
        this.tablePopupCBHP.setEnabled(false);
        this.tablePopupCBHP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBHP);
        this.tablePopupCBHPMax.setText("HP Max");
        this.tablePopupCBHPMax.setEnabled(false);
        this.tablePopupCBHPMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBHPMax);
        this.tablePopupCBType.setText("Type");
        this.tablePopupCBType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.TablePopupActionPerformed(actionEvent);
            }
        });
        this.tablePopup.add(this.tablePopupCBType);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(700, 600));
        this.buttonPanelTop.setLayout(new BoxLayout(this.buttonPanelTop, 0));
        this.bRoll.setText("Start Combat");
        this.bRoll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bRollActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bRoll);
        this.bAddCombatant.setText("Add Combatant");
        this.bAddCombatant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bAddCombatantActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bAddCombatant);
        this.bDuplicateCombatant.setText("Duplicate");
        this.bDuplicateCombatant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bDuplicateCombatantActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bDuplicateCombatant);
        this.bNextInit.setText("Next Initiative");
        this.bNextInit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bNextInitActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bNextInit);
        this.bRefocus.setText("Refocus");
        this.bRefocus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bRefocusActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bRefocus);
        this.bCombatantReRoll.setText("Roll");
        this.bCombatantReRoll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bCombatantReRollActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bCombatantReRoll);
        this.bDelete.setText("Delete");
        this.bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bDeleteActionPerformed(actionEvent);
            }
        });
        this.buttonPanelTop.add(this.bDelete);
        this.bRefresh.setText("Refresh Tabs");
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.refreshTable();
                Initiative.this.refreshTabs();
            }
        });
        this.buttonPanelTop.add(this.bRefresh);
        this.topToolbar.add(this.buttonPanelTop);
        this.topToolbar.add(this.jPanel2);
        this.lCounter.setFont(new Font("Dialog", 0, 18));
        this.topToolbar.add(this.lCounter);
        this.add((Component)this.topToolbar, "North");
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(800, 405));
        this.combatantTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Initiative.this.combatantTableMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Initiative.this.combatantTableMouseReleased(mouseEvent);
            }
        });
        this.combatantTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Initiative.this.combatantTablePropertyChange(propertyChangeEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.combatantTable);
        this.jScrollEvents.setViewportView(this.tpCombatInfo);
        this.jSplitPane1.setLeftComponent((Component)this.jScrollPane1);
        this.tpaneInfo.addTab("Events", this.jScrollEvents);
        this.jSplitPane1.setRightComponent((Component)this.tpaneInfo);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.bottomToolbar, "South");
        this.bottomToolbar.add(this.bOpposedSkill);
    }

    protected void bDuplicateCombatantActionPerformed(ActionEvent actionEvent) {
        NumberFormatter numberFormatter = new NumberFormatter();
        numberFormatter.setAllowsInvalid(false);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setValueClass(Integer.class);
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setValue(1);
        int n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, jFormattedTextField, "How many copies?", 2);
        if (n == 2) {
            return;
        }
        int n2 = ((Number)jFormattedTextField.getValue()).intValue();
        for (InitHolder initHolder : this.getSelected()) {
            if (initHolder instanceof XMLCombatant || initHolder instanceof PcgCombatant) {
                if (initHolder instanceof PcgCombatant) {
                    if (((PcgCombatant)initHolder).getPC().getFileName() != null && ((PcgCombatant)initHolder).getPC().getFileName().length() > 0) {
                        this.pasteNew((Combatant)initHolder, n2);
                        continue;
                    }
                    JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "Combatant " + initHolder.getName() + " cannot be duplicated because it has not been saved to a valid .pcg file.", "Cannot Duplicate", 2);
                    continue;
                }
                this.pasteNew((Combatant)initHolder, n2);
                continue;
            }
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "Combatant " + initHolder.getName() + " cannot be duplicated because it is not a PCGen or XML combatant.", "Cannot Duplicate", 2);
        }
    }

    private void initDynamicComponents() {
        this.bSave.setText("Roll Save");
        this.bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bSaveActionPerformed(actionEvent);
            }
        });
        this.bCast.setText("Cast Spell");
        this.bCast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bCastActionPerformed(actionEvent);
            }
        });
        this.bEvent.setText("Start Event");
        this.bEvent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bEventActionPerformed(actionEvent);
            }
        });
        this.bKill.setText("Kill");
        this.bKill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bKillActionPerformed(actionEvent);
            }
        });
        this.bDamage.setText("Damage");
        this.bDamage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bDamageActionPerformed(actionEvent);
            }
        });
        this.bHeal.setText("Heal");
        this.bHeal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bHealActionPerformed(actionEvent);
            }
        });
        this.bStabilize.setText("Stabilize");
        this.bStabilize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bStabilizeActionPerformed(actionEvent);
            }
        });
        this.bRaise.setText("Raise");
        this.bRaise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.bRaiseActionPerformed(actionEvent);
            }
        });
        this.showDead.setSelected(true);
        this.showDead.setText("Show Dead");
        this.showDead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.showDeadActionPerformed(actionEvent);
            }
        });
        this.showEvents.setSelected(true);
        this.showEvents.setText("Show Events");
        this.showEvents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.showEventsActionPerformed(actionEvent);
            }
        });
        this.bOpposedSkill.setText("Mass Skill Check");
        this.bOpposedSkill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Initiative.this.opposedSkillActionPerformed(actionEvent);
            }
        });
    }

    protected void opposedSkillActionPerformed(ActionEvent actionEvent) {
        List<InitHolder> list = this.getSelected();
        List<InitHolder> list2 = this.getUnSelected();
        OpposedCheckDialog opposedCheckDialog = new OpposedCheckDialog((Frame)GMGenSystem.inst, list, list2);
        opposedCheckDialog.setModal(true);
        opposedCheckDialog.setVisible(true);
        opposedCheckDialog.dispose();
    }

    private void initTable() {
        this.initTableColumns();
        JTableHeader jTableHeader = this.combatantTable.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Initiative.this.combatantTableMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Initiative.this.combatantTableMouseReleased(mouseEvent);
            }
        });
        this.columnList = this.getColumnOrder();
        this.combatantTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Initiative.this.listSelectionChaned(listSelectionEvent);
            }
        });
        TableColumn tableColumn = this.combatantTable.getColumn("Type");
        String[] stringArray = new String[]{"PC", "Enemy", "Ally", "Non Combatant"};
        tableColumn.setCellEditor(new TypeEditor(stringArray));
    }

    private void initTableColumns() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.combatantTable.getModel();
        defaultTableModel.setColumnCount(0);
        int n = SettingsHandler.getGMGenOption((String)"Initiative.NumberOfColumns", (int)0);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            String string = SettingsHandler.getGMGenOption((String)("Initiative.ColumnName." + i), (String)"");
            int n2 = SettingsHandler.getGMGenOption((String)("Initiative.ColumnWidth." + i), (int)100);
            this.addColumn(string, n2);
            nArray[i] = n2;
        }
        this.setColumnWidths(nArray);
    }

    private void initTablePopup() {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        this.tablePopupCBName.setSelected(false);
        this.tablePopupCBPlayer.setSelected(false);
        this.tablePopupCBStatus.setSelected(false);
        this.tablePopupCBPlus.setSelected(false);
        this.tablePopupCBInitiative.setSelected(false);
        this.tablePopupCBDuration.setSelected(false);
        this.tablePopupCBHP.setSelected(false);
        this.tablePopupCBHPMax.setSelected(false);
        this.tablePopupCBNumber.setSelected(false);
        this.tablePopupCBType.setSelected(false);
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            String string = tableColumn.getIdentifier().toString();
            if (string.equals("Name")) {
                this.tablePopupCBName.setSelected(true);
                continue;
            }
            if (string.equals("Player")) {
                this.tablePopupCBPlayer.setSelected(true);
                continue;
            }
            if (string.equals("Status")) {
                this.tablePopupCBStatus.setSelected(true);
                continue;
            }
            if (string.equals("+")) {
                this.tablePopupCBPlus.setSelected(true);
                continue;
            }
            if (string.equals("Init")) {
                this.tablePopupCBInitiative.setSelected(true);
                continue;
            }
            if (string.equals("Dur")) {
                this.tablePopupCBDuration.setSelected(true);
                continue;
            }
            if (string.equals("HP")) {
                this.tablePopupCBHP.setSelected(true);
                continue;
            }
            if (string.equals("HP Max")) {
                this.tablePopupCBHPMax.setSelected(true);
                continue;
            }
            if (string.equals("#")) {
                this.tablePopupCBNumber.setSelected(true);
                continue;
            }
            if (!string.equals("Type")) continue;
            this.tablePopupCBType.setSelected(true);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doSpells", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doDeath", (boolean)true) || SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.tablePopupCBDuration.setEnabled(true);
        } else {
            this.tablePopupCBDuration.setEnabled(false);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doHP", (boolean)true)) {
            this.tablePopupCBHP.setEnabled(true);
            this.tablePopupCBHPMax.setEnabled(true);
        } else {
            this.tablePopupCBHP.setEnabled(false);
            this.tablePopupCBHPMax.setEnabled(false);
        }
        if (SettingsHandler.getGMGenOption((String)"Initiative.doNumber", (boolean)true)) {
            this.tablePopupCBNumber.setEnabled(true);
        }
    }

    private void refreshEventTab() {
        this.tpCombatInfo.setText("");
        for (int i = 0; i < this.initList.size(); ++i) {
            InitHolder initHolder = (InitHolder)this.initList.get(i);
            StringBuffer stringBuffer = new StringBuffer();
            if (initHolder instanceof Event) {
                Event event = (Event)initHolder;
                stringBuffer.append(event.getName() + " (" + event.getPlayer() + ")\n");
                stringBuffer.append("Duration: " + event.getDuration() + "\n");
                if (event.getEffect().length() > 0) {
                    stringBuffer.append(event.getEffect() + "\n\n");
                } else {
                    stringBuffer.append("\n");
                }
            }
            this.tpCombatInfo.setText(this.tpCombatInfo.getText() + stringBuffer);
        }
    }

    private void removeColumn(String string) {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (!tableColumn.getHeaderValue().toString().equals(string)) continue;
            tableColumnModel.removeColumn(tableColumn);
        }
        this.trackTable();
        this.initTable();
        this.columnList = this.getColumnOrder();
    }

    private void showDeadActionPerformed(ActionEvent actionEvent) {
        this.checkDeadTabs();
        this.refreshTable();
        this.focusNextInit();
    }

    private void showEventsActionPerformed(ActionEvent actionEvent) {
        this.refreshTable();
        this.focusNextInit();
        SettingsHandler.setGMGenOption((String)"Initiative.ShowEvents", (boolean)this.showEvents.isSelected());
    }

    private void trackTable() {
        TableColumnModel tableColumnModel = this.combatantTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        SettingsHandler.setGMGenOption((String)"Initiative.NumberOfColumns", (int)n);
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            String string = tableColumn.getIdentifier().toString();
            SettingsHandler.setGMGenOption((String)("Initiative.ColumnName." + i), (String)string);
            SettingsHandler.setGMGenOption((String)("Initiative.ColumnWidth." + i), (int)tableColumn.getWidth());
        }
    }

    public static void initHolderUpdated(InitHolder initHolder) {
        if (initHolder instanceof Combatant) {
            Initiative.combatantUpdated((Combatant)initHolder);
        }
    }

    public static void combatantUpdated(Combatant combatant) {
        GMBus.send((GMBMessage)new CombatantUpdatedMessage((GMBComponent)GMGenSystem.inst, combatant));
    }

    public static class TypeRenderer
    extends JComboBox
    implements TableCellRenderer {
        public TypeRenderer(String[] stringArray) {
            super(stringArray);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelectedItem(object);
            return this;
        }
    }

    public static class TypeEditor
    extends DefaultCellEditor {
        public TypeEditor(String[] stringArray) {
            super(new JComboBox<String>(stringArray));
        }
    }
}

