/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.PcgCombatant;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import pcgen.core.Globals;
import pcgen.core.Skill;
import plugin.initiative.OpposedSkillBasicModel;
import plugin.initiative.OpposedSkillModel;
import plugin.initiative.OpposedSkillTypeModel;

public class OpposedCheckDialog
extends JDialog {
    private CombatantTransferHandler transferHandler = new CombatantTransferHandler();
    private JLabel availableLabel = null;
    private JScrollPane availableScrollPane = null;
    private JTable availableTable = null;
    private OpposedSkillTypeModel ivjAvailableModel = null;
    private OpposedSkillModel ivjOpposedSkillModel = null;
    private OpposedSkillModel ivjRollingSkillModel = null;
    private JPanel jContentPane = null;
    private JButton okButton = null;
    private JComboBox opposingComboBox = null;
    private JLabel opposingGroupLabel = null;
    private JScrollPane opposingGroupScrollPane = null;
    private JTable opposingGroupTable = null;
    private JButton rollButton = null;
    private JComboBox rollingComboBox = null;
    private JLabel rollingGroupLabel = null;
    private JScrollPane rollingGroupScrollPane = null;
    private JTable rollingGroupTable = null;
    private TreeSet<String> skillNames = new TreeSet();

    public OpposedCheckDialog() {
        this.skillNames.add("Hide");
        this.skillNames.add("Move Silently");
        this.skillNames.add("Listen");
        this.skillNames.add("Spot");
        this.initialize();
    }

    public OpposedCheckDialog(Dialog dialog, List list, List list2) throws HeadlessException {
        super(dialog);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog dialog, boolean bl, List list, List list2) throws HeadlessException {
        super(dialog, bl);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog dialog, String string, List list, List list2) throws HeadlessException {
        super(dialog, string);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog dialog, String string, boolean bl, List list, List list2) throws HeadlessException {
        super(dialog, string, bl);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration, List list, List list2) throws HeadlessException {
        super(dialog, string, bl, graphicsConfiguration);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Frame frame, List list, List list2) throws HeadlessException {
        super(frame);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Frame frame, boolean bl, List list, List list2) throws HeadlessException {
        super(frame, bl);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Frame frame, String string, List list, List list2) throws HeadlessException {
        super(frame, string);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Frame frame, String string, boolean bl, List list, List list2) throws HeadlessException {
        super(frame, string, bl);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration, List list, List list2) {
        super(frame, string, bl, graphicsConfiguration);
        this.initializeLists(list, list2);
        this.initialize();
    }

    public OpposedCheckDialog(List list, List list2) {
        this.initializeLists(list, list2);
        this.initialize();
    }

    private void initializeLists(List list, List list2) {
        for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            this.skillNames.add(skill.toString());
        }
        this.ivjAvailableModel = new OpposedSkillTypeModel(list2);
        this.ivjRollingSkillModel = new OpposedSkillModel(list);
        this.ivjOpposedSkillModel = new OpposedSkillModel();
    }

    private JLabel getAvailableLabel() {
        if (this.availableLabel == null) {
            this.availableLabel = new JLabel();
            this.availableLabel.setText("Available Combatants");
        }
        return this.availableLabel;
    }

    private JScrollPane getAvailableScrollPane() {
        if (this.availableScrollPane == null) {
            this.availableScrollPane = new JScrollPane();
            this.availableScrollPane.setViewportView(this.getAvailableTable());
            this.availableScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.availableScrollPane;
    }

    private JTable getAvailableTable() {
        if (this.availableTable == null) {
            this.availableTable = new JTable();
            this.availableTable.setModel(this.getIvjAvailableModel());
            this.availableTable.setDragEnabled(true);
            this.availableTable.setTransferHandler(this.transferHandler);
            this.availableTable.setName("availableTable");
        }
        return this.availableTable;
    }

    private OpposedSkillBasicModel getIvjAvailableModel() {
        if (this.ivjAvailableModel == null) {
            this.ivjAvailableModel = new OpposedSkillTypeModel();
        }
        return this.ivjAvailableModel;
    }

    private OpposedSkillModel getIvjOpposedSkillModel() {
        if (this.ivjOpposedSkillModel == null) {
            this.ivjOpposedSkillModel = new OpposedSkillModel();
        }
        return this.ivjOpposedSkillModel;
    }

    private OpposedSkillModel getIvjRollingSkillModel() {
        if (this.ivjRollingSkillModel == null) {
            this.ivjRollingSkillModel = new OpposedSkillModel();
        }
        return this.ivjRollingSkillModel;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 4;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 5;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 5;
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            this.jContentPane.add((Component)this.getAvailableScrollPane(), gridBagConstraints10);
            this.jContentPane.add((Component)this.getRollingGroupScrollPane(), gridBagConstraints9);
            this.jContentPane.add((Component)this.getOpposingComboBox(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getOpposingGroupScrollPane(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getRollingComboBox(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getRollButton(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getOkButton(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getRollingGroupLabel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getOpposingGroupLabel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getAvailableLabel(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpposedCheckDialog.this.okButtonActionPerformed(actionEvent);
                }
            });
        }
        return this.okButton;
    }

    private JComboBox getOpposingComboBox() {
        if (this.opposingComboBox == null) {
            this.opposingComboBox = new JComboBox<Object>(this.skillNames.toArray());
            this.opposingComboBox.setSelectedIndex(-1);
            this.opposingComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpposedCheckDialog.this.opposingComboBoxActionPerformed(actionEvent);
                }
            });
        }
        return this.opposingComboBox;
    }

    private JLabel getOpposingGroupLabel() {
        if (this.opposingGroupLabel == null) {
            this.opposingGroupLabel = new JLabel();
            this.opposingGroupLabel.setText("Opposing Group");
        }
        return this.opposingGroupLabel;
    }

    private JScrollPane getOpposingGroupScrollPane() {
        if (this.opposingGroupScrollPane == null) {
            this.opposingGroupScrollPane = new JScrollPane();
            this.opposingGroupScrollPane.setViewportView(this.getOpposingGroupTable());
            this.opposingGroupScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.opposingGroupScrollPane;
    }

    private JTable getOpposingGroupTable() {
        if (this.opposingGroupTable == null) {
            this.opposingGroupTable = new JTable();
            this.opposingGroupTable.setModel(this.getIvjOpposedSkillModel());
            this.opposingGroupTable.setDragEnabled(true);
            this.opposingGroupTable.setTransferHandler(this.transferHandler);
            this.opposingGroupTable.setName("opposingGroupTable");
        }
        return this.opposingGroupTable;
    }

    private JButton getRollButton() {
        if (this.rollButton == null) {
            this.rollButton = new JButton();
            this.rollButton.setText("Roll");
            this.rollButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpposedCheckDialog.this.rollButtonActionPerformed(actionEvent);
                }
            });
        }
        return this.rollButton;
    }

    private JComboBox getRollingComboBox() {
        if (this.rollingComboBox == null) {
            this.rollingComboBox = new JComboBox<Object>(this.skillNames.toArray());
            this.rollingComboBox.setSelectedIndex(-1);
            this.rollingComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpposedCheckDialog.this.rollingComboBoxActionPerformed(actionEvent);
                }
            });
        }
        return this.rollingComboBox;
    }

    private JLabel getRollingGroupLabel() {
        if (this.rollingGroupLabel == null) {
            this.rollingGroupLabel = new JLabel();
            this.rollingGroupLabel.setText("Rolling Group");
        }
        return this.rollingGroupLabel;
    }

    private JScrollPane getRollingGroupScrollPane() {
        if (this.rollingGroupScrollPane == null) {
            this.rollingGroupScrollPane = new JScrollPane();
            this.rollingGroupScrollPane.setViewportView(this.getRollingGroupTable());
            this.rollingGroupScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.rollingGroupScrollPane;
    }

    private JTable getRollingGroupTable() {
        if (this.rollingGroupTable == null) {
            this.rollingGroupTable = new JTable();
            this.rollingGroupTable.setModel(this.getIvjRollingSkillModel());
            this.rollingGroupTable.setDragEnabled(true);
            this.rollingGroupTable.setTransferHandler(this.transferHandler);
            this.rollingGroupTable.setName("rollingGroupTable");
        }
        return this.rollingGroupTable;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.setLocationRelativeTo((Component)GMGenSystem.inst);
    }

    protected void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    protected void opposingComboBoxActionPerformed(ActionEvent actionEvent) {
        this.ivjOpposedSkillModel.setSkill(this.opposingComboBox.getSelectedItem().toString());
    }

    protected void rollButtonActionPerformed(ActionEvent actionEvent) {
        this.ivjOpposedSkillModel.rollAll();
        this.ivjRollingSkillModel.rollAll();
    }

    protected void rollingComboBoxActionPerformed(ActionEvent actionEvent) {
        this.ivjRollingSkillModel.setSkill(this.rollingComboBox.getSelectedItem().toString());
    }

    private static class CombatantTransferHandler
    extends TransferHandler {
        private DataFlavor combatantFlavor = null;
        private String mimeType = "application/x-java-jvm-local-objectref;class=gmgen.plugin.PcgCombatant";
        private OpposedSkillBasicModel sourceModel = null;
        private JTable sourceTable = null;

        public CombatantTransferHandler() {
            try {
                this.combatantFlavor = new DataFlavor(this.mimeType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (this.sourceTable == null || jComponent == null || this.sourceTable.getName().equals(jComponent.getName())) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!this.combatantFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                this.sourceModel = (OpposedSkillBasicModel)((JTable)jComponent).getModel();
                this.sourceTable = (JTable)jComponent;
                return new CombatantTransferable((JTable)jComponent);
            }
            return null;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                try {
                    List list = (List)transferable.getTransferData(this.combatantFlavor);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.sourceModel.removeCombatant(((PcgCombatant)iterator.next()).getName());
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.sourceModel = null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                JTable jTable = (JTable)jComponent;
                OpposedSkillBasicModel opposedSkillBasicModel = (OpposedSkillBasicModel)jTable.getModel();
                try {
                    List list = (List)transferable.getTransferData(this.combatantFlavor);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        opposedSkillBasicModel.addCombatant((PcgCombatant)iterator.next());
                    }
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        class CombatantTransferable
        implements Transferable {
            private List<PcgCombatant> items = null;

            public CombatantTransferable(JTable jTable) {
                int[] nArray = jTable.getSelectedRows();
                if (nArray != null && nArray.length > 0) {
                    OpposedSkillBasicModel opposedSkillBasicModel = (OpposedSkillBasicModel)jTable.getModel();
                    this.items = new ArrayList<PcgCombatant>();
                    for (int i = 0; i < nArray.length; ++i) {
                        this.items.add(opposedSkillBasicModel.getCombatant(nArray[i]));
                    }
                }
            }

            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.items;
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{CombatantTransferHandler.this.combatantFlavor};
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return CombatantTransferHandler.this.combatantFlavor.equals(dataFlavor);
            }
        }
    }
}

