/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainsToken
extends AbstractToken
implements CDOMPrimaryToken<Spell> {
    private static final Class<DomainSpellList> SPELLLIST_CLASS = DomainSpellList.class;

    public String getTokenName() {
        return "DOMAINS";
    }

    public boolean parse(LoadContext loadContext, Spell spell, String string) {
        String string2;
        if (".CLEARALL".equals(string)) {
            loadContext.getListContext().clearAllMasterLists(this.getTokenName(), (CDOMObject)spell);
            return true;
        }
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        Prerequisite prerequisite = null;
        int n = string.indexOf(91);
        if (n == -1) {
            string2 = string;
        } else {
            if (string.lastIndexOf(93) != string.length() - 1) {
                Logging.errorPrint((String)("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag"));
                return false;
            }
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            if (string3.length() == 0) {
                Logging.errorPrint((String)(this.getTokenName() + " cannot have empty prerequisite : " + string));
                return false;
            }
            prerequisite = this.getPrerequisite(string3);
            if (prerequisite == null) {
                Logging.errorPrint((String)(this.getTokenName() + " had invalid prerequisite : " + string3));
                return false;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Integer n2;
            String string4 = stringTokenizer.nextToken();
            int n3 = string4.indexOf("=");
            if (n3 == -1) {
                Logging.errorPrint((String)("Malformed " + this.getTokenName() + " Token (expecting an =): " + string4));
                Logging.errorPrint((String)("Line was: " + string));
                return false;
            }
            if (n3 != string4.lastIndexOf("=")) {
                Logging.errorPrint((String)("Malformed " + this.getTokenName() + " Token (more than one =): " + string4));
                Logging.errorPrint((String)("Line was: " + string));
                return false;
            }
            String string5 = string4.substring(0, n3);
            String string6 = string4.substring(n3 + 1);
            try {
                n2 = Integer.valueOf(string6);
                if (n2 < -1) {
                    Logging.errorPrint((String)(this.getTokenName() + " may not use a negative level: " + string));
                    return false;
                }
                if (n2 == -1 && prerequisite != null) {
                    Logging.errorPrint((String)(this.getTokenName() + " may not use -1 with a PREREQ: " + string));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Malformed Level in " + this.getTokenName() + " (expected an Integer): " + string6));
                Logging.errorPrint((String)("Line was: " + string));
                return false;
            }
            if (this.hasIllegalSeparator(',', string5)) {
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                CDOMGroupRef cDOMGroupRef;
                String string7 = stringTokenizer2.nextToken();
                if ("ALL".equals(string7)) {
                    bl = true;
                    cDOMGroupRef = loadContext.ref.getCDOMAllReference(SPELLLIST_CLASS);
                } else {
                    bl2 = true;
                    cDOMGroupRef = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, SPELLLIST_CLASS, (String)string7);
                }
                if (cDOMGroupRef == null) {
                    Logging.errorPrint((String)("  error was in " + this.getTokenName()));
                    return false;
                }
                if (n2 == -1) {
                    if (prerequisite != null) {
                        Logging.errorPrint((String)("Cannot use Prerequisiste on effective CLEAR (using level == -1) in " + this.getTokenName()));
                        return false;
                    }
                    loadContext.getListContext().removeFromMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)cDOMGroupRef, (CDOMObject)spell);
                    continue;
                }
                AssociatedPrereqObject associatedPrereqObject = loadContext.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)cDOMGroupRef, (CDOMObject)spell);
                associatedPrereqObject.setAssociation(AssociationKey.SPELL_LEVEL, (Object)n2);
                if (prerequisite == null) continue;
                associatedPrereqObject.addPrerequisite(prerequisite);
            }
        }
        if (bl && bl2) {
            Logging.errorPrint((String)("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Spell spell) {
        Object object9;
        Object object2;
        Object object3;
        Object object42;
        DoubleKeyMapToList doubleKeyMapToList = new DoubleKeyMapToList();
        ArrayList<String> arrayList = new ArrayList<String>();
        Changes changes = loadContext.getListContext().getMasterListChanges(this.getTokenName(), (CDOMObject)spell, SPELLLIST_CLASS);
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEARALL");
        }
        if (changes.hasRemovedItems()) {
            for (Object object42 : changes.getRemoved()) {
                object3 = loadContext.getListContext().getChangesInMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)object42);
                object2 = object3.getRemovedAssociations();
                if (object2 == null || object2.isEmpty()) continue;
                for (Object object5 : object2.getKeySet()) {
                    if (!spell.getLSTformat().equals(object5.getLSTformat())) {
                        loadContext.addWriteMessage("Spell " + this.getTokenName() + " token cannot remove another Spell " + "(must only remove itself)");
                        return null;
                    }
                    for (Object object6 : object2.getListFor(object5)) {
                        object9 = object6.getPrerequisiteList();
                        if (object9 != null && object9.size() != 0) {
                            loadContext.addWriteMessage("Incoming Remove Edge to " + spell.getKeyName() + " had a " + "Prerequisite: " + object9.size());
                            return null;
                        }
                        doubleKeyMapToList.addToListFor(null, (Object)-1, object42);
                    }
                }
            }
        }
        for (Object object42 : changes.getAdded()) {
            object3 = loadContext.getListContext().getChangesInMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)object42);
            object2 = object3.getRemoved();
            if (object2 != null && !object2.isEmpty() || object3.includesGlobalClear()) {
                loadContext.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
                return null;
            }
            Object object7 = object3.getAddedAssociations();
            if (object7 == null || object7.isEmpty()) continue;
            for (Object object8 : object7.getKeySet()) {
                if (!spell.getLSTformat().equals(object8.getLSTformat())) {
                    loadContext.addWriteMessage("Spell " + this.getTokenName() + " token cannot allow another Spell " + "(must only allow itself)");
                    return null;
                }
                for (Object object9 : object7.getListFor(object8)) {
                    Prerequisite prerequisite;
                    List list = object9.getPrerequisiteList();
                    if (list == null || list.size() == 0) {
                        prerequisite = null;
                    } else if (list.size() == 1) {
                        prerequisite = (Prerequisite)list.get(0);
                    } else {
                        loadContext.addWriteMessage("Incoming Edge to " + spell.getKeyName() + " had more than one " + "Prerequisite: " + list.size());
                        return null;
                    }
                    Integer n = (Integer)object9.getAssociation(AssociationKey.SPELL_LEVEL);
                    if (n == null) {
                        loadContext.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had no Spell Level defined");
                        return null;
                    }
                    if (n < 0) {
                        loadContext.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had invalid Level: " + n + ". Must be >= 0.");
                        return null;
                    }
                    doubleKeyMapToList.addToListFor((Object)prerequisite, (Object)n, object42);
                }
            }
        }
        if (doubleKeyMapToList.isEmpty()) {
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
        object42 = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        object3 = new TreeSet();
        for (Object object7 : doubleKeyMapToList.getKeySet()) {
            Object object6;
            Object object5;
            object5 = new StringBuilder();
            boolean bl = false;
            object3.clear();
            object3.addAll(doubleKeyMapToList.getSecondaryKeySet(object7));
            object6 = object3.iterator();
            while (object6.hasNext()) {
                object9 = (Integer)object6.next();
                object42.clear();
                object42.addAll(doubleKeyMapToList.getListFor(object7, object9));
                if (bl) {
                    ((StringBuilder)object5).append("|");
                }
                ((StringBuilder)object5).append(ReferenceUtilities.joinLstFormat((Collection)object42, (String)","));
                ((StringBuilder)object5).append('=').append(object9);
                bl = true;
            }
            if (object7 != null) {
                ((StringBuilder)object5).append('[');
                object6 = new StringWriter();
                try {
                    prerequisiteWriter.write((Writer)object6, (Prerequisite)object7);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    loadContext.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)persistenceLayerException));
                    return null;
                }
                ((StringBuilder)object5).append(((StringWriter)object6).toString());
                ((StringBuilder)object5).append(']');
            }
            arrayList.add(((StringBuilder)object5).toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

