/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.util.HtmlUtils;

public class EscapedErrors
implements Errors {
    private final Errors source;

    public EscapedErrors(Errors source) {
        if (source == null) {
            throw new IllegalArgumentException("Cannot wrap a null instance");
        }
        this.source = source;
    }

    public Errors getSource() {
        return this.source;
    }

    public String getObjectName() {
        return this.source.getObjectName();
    }

    public void setNestedPath(String nestedPath) {
        this.source.setNestedPath(nestedPath);
    }

    public String getNestedPath() {
        return this.source.getNestedPath();
    }

    public void pushNestedPath(String subPath) {
        this.source.pushNestedPath(subPath);
    }

    public void popNestedPath() throws IllegalStateException {
        this.source.popNestedPath();
    }

    public void reject(String errorCode) {
        this.source.reject(errorCode);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.source.reject(errorCode, defaultMessage);
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.source.reject(errorCode, errorArgs, defaultMessage);
    }

    public void rejectValue(String field, String errorCode) {
        this.source.rejectValue(field, errorCode);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.source.rejectValue(field, errorCode, defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.source.rejectValue(field, errorCode, errorArgs, defaultMessage);
    }

    public void addAllErrors(Errors errors) {
        this.source.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.source.hasErrors();
    }

    public int getErrorCount() {
        return this.source.getErrorCount();
    }

    public List getAllErrors() {
        return this.escapeObjectErrors(this.source.getAllErrors());
    }

    public boolean hasGlobalErrors() {
        return this.source.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.source.getGlobalErrorCount();
    }

    public List getGlobalErrors() {
        return this.escapeObjectErrors(this.source.getGlobalErrors());
    }

    public ObjectError getGlobalError() {
        return this.escapeObjectError(this.source.getGlobalError());
    }

    public boolean hasFieldErrors(String field) {
        return this.source.hasFieldErrors(field);
    }

    public int getFieldErrorCount(String field) {
        return this.source.getFieldErrorCount(field);
    }

    public List getFieldErrors(String field) {
        return this.escapeObjectErrors(this.source.getFieldErrors(field));
    }

    public FieldError getFieldError(String field) {
        return (FieldError)this.escapeObjectError((ObjectError)this.source.getFieldError(field));
    }

    public Object getFieldValue(String field) {
        Object value = this.source.getFieldValue(field);
        return value instanceof String ? HtmlUtils.htmlEscape((String)value) : value;
    }

    private ObjectError escapeObjectError(ObjectError source) {
        if (source == null) {
            return null;
        }
        if (source instanceof FieldError) {
            FieldError fieldError = (FieldError)source;
            Object value = fieldError.getRejectedValue();
            if (value instanceof String) {
                value = HtmlUtils.htmlEscape((String)value);
            }
            return new FieldError(fieldError.getObjectName(), fieldError.getField(), value, fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), HtmlUtils.htmlEscape(fieldError.getDefaultMessage()));
        }
        return new ObjectError(source.getObjectName(), source.getCodes(), source.getArguments(), HtmlUtils.htmlEscape(source.getDefaultMessage()));
    }

    private List escapeObjectErrors(List source) {
        ArrayList<ObjectError> escaped = new ArrayList<ObjectError>(source.size());
        Iterator it = source.iterator();
        while (it.hasNext()) {
            ObjectError objectError = (ObjectError)it.next();
            escaped.add(this.escapeObjectError(objectError));
        }
        return escaped;
    }
}

