/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Random;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.util.HitMonitor;
import org.directwebremoting.util.Logger;

public class DefaultServerLoadMonitor
implements ServerLoadMonitor {
    protected Random random = new Random();
    protected int maxWaitingThreads = 100;
    protected int maxPollHitsPerSecond = 40;
    protected int preStreamWaitTime = 29000;
    protected int postStreamWaitTime = 1000;
    protected int timeToNextPoll = 3000;
    protected static final int MIN_TIME_TO_NEXT_POLL = 3000;
    protected static final int MAX_PRE_STREAM_WAIT_TIME = 29000;
    protected static final int MAX_POST_STREAM_WAIT_TIME = 1000;
    protected static final int SECONDS_MONITORED = 5;
    protected HitMonitor hitMonitor = new HitMonitor(5000);
    protected int waitingThreads = 0;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultServerLoadMonitor == null ? (class$org$directwebremoting$impl$DefaultServerLoadMonitor = DefaultServerLoadMonitor.class$("org.directwebremoting.impl.DefaultServerLoadMonitor")) : class$org$directwebremoting$impl$DefaultServerLoadMonitor);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultServerLoadMonitor;

    public long getPreStreamWaitTime() {
        return this.preStreamWaitTime;
    }

    public long getPostStreamWaitTime() {
        return this.postStreamWaitTime;
    }

    public int getTimeToNextPoll() {
        this.hitMonitor.recordHit();
        this.checkLoading();
        return this.random.nextInt(this.timeToNextPoll);
    }

    public void threadWaitStarting() {
        ++this.waitingThreads;
    }

    public void threadWaitEnding() {
        --this.waitingThreads;
    }

    private void checkLoading() {
        int hitsPerSecond = this.hitMonitor.getHitsInLastPeriod() / 5;
        this.timeToNextPoll = hitsPerSecond == 0 ? 0 : this.timeToNextPoll * this.maxPollHitsPerSecond / hitsPerSecond;
        if (this.timeToNextPoll < 3000) {
            this.timeToNextPoll = 3000;
        }
        int totalPollTime = this.preStreamWaitTime + this.postStreamWaitTime;
        if (this.waitingThreads != 0) {
            totalPollTime = totalPollTime * this.maxWaitingThreads / this.waitingThreads;
        }
        if (totalPollTime > 30000) {
            this.preStreamWaitTime = totalPollTime - 1000;
            this.postStreamWaitTime = 1000;
            if (this.preStreamWaitTime > 29000) {
                this.preStreamWaitTime = 29000;
            }
        } else {
            this.preStreamWaitTime = 0;
            this.postStreamWaitTime = totalPollTime;
        }
        log.debug("hitsPerSecond=" + hitsPerSecond);
        log.debug("waitingThreads=" + this.waitingThreads);
        log.debug("timeToNextPoll=" + this.timeToNextPoll);
        log.debug("preStreamWaitTime=" + this.preStreamWaitTime);
        log.debug("postStreamWaitTime=" + this.postStreamWaitTime);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

