/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.util.Continuation;

public class ExceptionHandler
implements Handler {
    private Exception cause;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Continuation.rethrowIfContinuation(this.cause);
        UrlProcessor.log.warn("Error: " + this.cause);
        if (this.cause instanceof SecurityException && UrlProcessor.log.isDebugEnabled()) {
            UrlProcessor.log.debug("- User Agent: " + request.getHeader("User-Agent"));
            UrlProcessor.log.debug("- Remote IP:  " + request.getRemoteAddr());
            UrlProcessor.log.debug("- Request URL:" + request.getRequestURL());
            UrlProcessor.log.debug("- Query:      " + request.getQueryString());
            UrlProcessor.log.debug("- Method:     " + request.getMethod());
        }
        response.setStatus(501);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println(this.cause.getMessage());
        UrlProcessor.log.warn("Sent 501", this.cause);
    }

    public void setException(Exception cause) {
        this.cause = cause;
    }
}

