/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.directwebremoting.util.Logger;

public class JavascriptUtil {
    public static final int COMPRESS_STRIP_SL_COMMENTS = 1;
    public static final int COMPRESS_STRIP_ML_COMMENTS = 2;
    public static final int COMPRESS_TRIM_LINES = 4;
    public static final int COMPRESS_STRIP_BLANKLINES = 8;
    public static final int COMPRESS_SHRINK_VARS = 16;
    public static final int COMPRESS_REMOVE_NEWLINES = 32;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_DEBUGGABLE = 7;
    public static final int LEVEL_NORMAL = 31;
    public static final int LEVEL_ULTRA = 63;
    private static final String[] RESERVED_ARRAY = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "is", "namespace", "new", "null", "package", "private", "public", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "void", "while", "with", "abstract", "debugger", "enum", "goto", "implements", "interface", "native", "protected", "synchronized", "throws", "transient", "volatile", "boolean", "byte", "char", "double", "final", "float", "int", "long", "short", "static"};
    private static SortedSet reserved = new TreeSet();
    private static final String SPACE = " ";
    private static final String COMMENT_ML_START = "/*";
    private static final String COMMENT_ML_END = "*/";
    private static final String COMMENT_SL_START = "//";
    private static final String COMMENT_RETAIN = "#DWR";
    private static final Logger log;
    static /* synthetic */ Class class$org$directwebremoting$util$JavascriptUtil;

    public static String compress(String text, int level) {
        String reply = text;
        if ((level & 2) != 0) {
            reply = JavascriptUtil.stripMultiLineComments(text);
        }
        if ((level & 1) != 0) {
            reply = JavascriptUtil.stripSingleLineComments(reply);
        }
        if ((level & 4) != 0) {
            reply = JavascriptUtil.trimLines(reply);
        }
        if ((level & 8) != 0) {
            reply = JavascriptUtil.stripBlankLines(reply);
        }
        if ((level & 0x10) != 0) {
            reply = JavascriptUtil.shrinkVariableNames(reply);
        }
        if ((level & 0x20) != 0) {
            reply = JavascriptUtil.stripNewlines(reply);
        }
        return reply;
    }

    public static String trimLines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line.trim());
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException ex) {
            log.error("IOExecption unexpected.", ex);
            throw new IllegalArgumentException("IOExecption unexpected.");
        }
    }

    public static String stripSingleLineComments(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                int cstart;
                if (line.indexOf(COMMENT_RETAIN) == -1 && (cstart = line.indexOf(COMMENT_SL_START)) >= 0) {
                    line = line.substring(0, cstart);
                }
                output.append(line);
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException ex) {
            log.error("IOExecption unexpected.", ex);
            throw new IllegalArgumentException("IOExecption unexpected.");
        }
    }

    public static String stripMultiLineComments(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            boolean inMultiLine = false;
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                if (!inMultiLine) {
                    int cstart = line.indexOf(COMMENT_ML_START);
                    if (cstart >= 0) {
                        int cend = line.indexOf(COMMENT_ML_END, cstart + COMMENT_ML_START.length());
                        if (cend >= 0) {
                            line = line.substring(0, cstart) + SPACE + line.substring(cend + COMMENT_ML_END.length());
                        } else {
                            inMultiLine = true;
                            line = line.substring(0, cstart) + SPACE;
                        }
                    }
                } else {
                    int cend = line.indexOf(COMMENT_ML_END);
                    if (cend >= 0) {
                        line = line.substring(cend + COMMENT_ML_END.length());
                        inMultiLine = false;
                    } else {
                        line = SPACE;
                    }
                }
                output.append(line);
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException ex) {
            log.error("IOExecption unexpected.", ex);
            throw new IllegalArgumentException("IOExecption unexpected.");
        }
    }

    public static String stripBlankLines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean doneOneLine = false;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                output.append(line);
                output.append('\n');
                doneOneLine = true;
            }
            if (!doneOneLine) {
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException ex) {
            log.error("IOExecption unexpected.", ex);
            throw new IllegalArgumentException("IOExecption unexpected.");
        }
    }

    public static String stripNewlines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line);
                output.append(SPACE);
            }
            output.append('\n');
            return output.toString();
        }
        catch (IOException ex) {
            log.error("IOExecption unexpected.", ex);
            throw new IllegalArgumentException("IOExecption unexpected.");
        }
    }

    public static String shrinkVariableNames(String text) {
        if (text == null) {
            return null;
        }
        throw new UnsupportedOperationException("Variable name shrinking is not supported");
    }

    public static String escapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length() * 2);
        int sz = str.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                writer.append("\\u");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                writer.append("\\u0");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                writer.append("\\u00");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        writer.append('\\');
                        writer.append('b');
                        break;
                    }
                    case '\n': {
                        writer.append('\\');
                        writer.append('n');
                        break;
                    }
                    case '\t': {
                        writer.append('\\');
                        writer.append('t');
                        break;
                    }
                    case '\f': {
                        writer.append('\\');
                        writer.append('f');
                        break;
                    }
                    case '\r': {
                        writer.append('\\');
                        writer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer.append("\\u00");
                            writer.append(JavascriptUtil.hex(ch));
                            break;
                        }
                        writer.append("\\u000");
                        writer.append(JavascriptUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    writer.append('\\');
                    writer.append('\'');
                    continue block12;
                }
                case '\"': {
                    writer.append('\\');
                    writer.append('\"');
                    continue block12;
                }
                case '\\': {
                    writer.append('\\');
                    writer.append('\\');
                    continue block12;
                }
                default: {
                    writer.append(ch);
                }
            }
        }
        return writer.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static String unescapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length());
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    writer.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode + " cause: " + nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        writer.append('\\');
                        break;
                    }
                    case '\'': {
                        writer.append('\'');
                        break;
                    }
                    case '\"': {
                        writer.append('\"');
                        break;
                    }
                    case 'r': {
                        writer.append('\r');
                        break;
                    }
                    case 'f': {
                        writer.append('\f');
                        break;
                    }
                    case 't': {
                        writer.append('\t');
                        break;
                    }
                    case 'n': {
                        writer.append('\n');
                        break;
                    }
                    case 'b': {
                        writer.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        writer.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            writer.append(ch);
        }
        if (hadSlash) {
            writer.append('\\');
        }
        return writer.toString();
    }

    public static boolean isReservedWord(String name) {
        return reserved.contains(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        reserved.addAll(Arrays.asList(RESERVED_ARRAY));
        log = Logger.getLogger(class$org$directwebremoting$util$JavascriptUtil == null ? (class$org$directwebremoting$util$JavascriptUtil = JavascriptUtil.class$("org.directwebremoting.util.JavascriptUtil")) : class$org$directwebremoting$util$JavascriptUtil);
    }
}

