/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.Archive;
import net.sourceforge.cobertura.instrument.ClassInstrumenter;
import net.sourceforge.cobertura.instrument.ClassPattern;
import net.sourceforge.cobertura.instrument.CoberturaFile;
import net.sourceforge.cobertura.util.ArchiveUtil;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.IOUtil;
import net.sourceforge.cobertura.util.RegexUtil;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Main {
    private static final Logger logger = Logger.getLogger((Class)(class$net$sourceforge$cobertura$instrument$Main == null ? (class$net$sourceforge$cobertura$instrument$Main = Main.class$("net.sourceforge.cobertura.instrument.Main")) : class$net$sourceforge$cobertura$instrument$Main));
    private File destinationDirectory = null;
    private Collection ignoreRegexes = new Vector();
    private ClassPattern classPattern = new ClassPattern();
    private ProjectData projectData = null;
    static /* synthetic */ Class class$net$sourceforge$cobertura$instrument$Main;

    private static boolean isClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean addInstrumentationToArchive(CoberturaFile file, InputStream archive, OutputStream output) throws Exception {
        boolean bl;
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream(archive);
            zos = new ZipOutputStream(output);
            bl = this.addInstrumentationToArchive(file, zis, zos);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            zis = (ZipInputStream)IOUtil.closeInputStream(zis);
            zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
            throw throwable;
        }
        zis = (ZipInputStream)IOUtil.closeInputStream(zis);
        zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addInstrumentationToArchive(CoberturaFile file, ZipInputStream archive, ZipOutputStream output) throws Exception {
        ZipEntry entry;
        boolean modified = false;
        while ((entry = archive.getNextEntry()) != null) {
            void var5_5;
            try {
                String entryName = var5_5.getName();
                if (ArchiveUtil.isSignatureFile(var5_5.getName())) continue;
                ZipEntry outputEntry = new ZipEntry(var5_5.getName());
                outputEntry.setComment(var5_5.getComment());
                outputEntry.setExtra(var5_5.getExtra());
                outputEntry.setTime(var5_5.getTime());
                output.putNextEntry(outputEntry);
                byte[] entryBytes = IOUtil.createByteArrayFromInputStream(archive);
                if (this.classPattern.isSpecified() && ArchiveUtil.isArchive(entryName)) {
                    Archive archiveObj = new Archive(file, entryBytes);
                    this.addInstrumentationToArchive(archiveObj);
                    if (archiveObj.isModified()) {
                        modified = true;
                        entryBytes = archiveObj.getBytes();
                        outputEntry.setTime(System.currentTimeMillis());
                    }
                } else if (Main.isClass((ZipEntry)var5_5) && this.classPattern.matches(entryName)) {
                    ClassReader cr = new ClassReader(entryBytes);
                    ClassWriter cw = new ClassWriter(true);
                    ClassInstrumenter cv = new ClassInstrumenter(this.projectData, (ClassVisitor)cw, this.ignoreRegexes);
                    cr.accept((ClassVisitor)cv, false);
                    if (cv.isInstrumented()) {
                        logger.debug((Object)("Putting instrumented entry: " + var5_5.getName()));
                        entryBytes = cw.toByteArray();
                        modified = true;
                        outputEntry.setTime(System.currentTimeMillis());
                    }
                }
                output.write(entryBytes);
                output.closeEntry();
                archive.closeEntry();
            }
            catch (Exception e) {
                logger.warn((Object)("Problems with archive entry: " + var5_5));
                throw e;
            }
            ((FilterOutputStream)output).flush();
        }
        return modified;
    }

    private void addInstrumentationToArchive(Archive archive) throws Exception {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = archive.getInputStream();
            out = new ByteArrayOutputStream();
            boolean modified = this.addInstrumentationToArchive(archive.getCoberturaFile(), in, out);
            if (modified) {
                out.flush();
                byte[] bytes = out.toByteArray();
                archive.setModifiedBytes(bytes);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in = IOUtil.closeInputStream(in);
            out = (ByteArrayOutputStream)IOUtil.closeOutputStream(out);
            throw throwable;
        }
        in = IOUtil.closeInputStream(in);
        out = (ByteArrayOutputStream)IOUtil.closeOutputStream(out);
    }

    private void addInstrumentationToArchive(CoberturaFile archive) {
        logger.debug((Object)("Instrumenting archive " + archive.getAbsolutePath()));
        File outputFile = null;
        ZipInputStream input = null;
        ZipOutputStream output = null;
        boolean modified = false;
        try {
            try {
                input = new ZipInputStream(new FileInputStream(archive));
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)("Cannot open archive file: " + archive.getAbsolutePath()), (Throwable)e);
                Object var8_10 = null;
                input = (ZipInputStream)IOUtil.closeInputStream(input);
                output = (ZipOutputStream)IOUtil.closeOutputStream(output);
                return;
            }
            try {
                if (this.destinationDirectory != null) {
                    outputFile = new File(this.destinationDirectory, archive.getPathname());
                } else {
                    outputFile = File.createTempFile("CoberturaInstrumentedArchive", "jar");
                    outputFile.deleteOnExit();
                }
                output = new ZipOutputStream(new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                logger.warn((Object)("Cannot open file for instrumented archive: " + archive.getAbsolutePath()), (Throwable)e);
                Object var8_11 = null;
                input = (ZipInputStream)IOUtil.closeInputStream(input);
                output = (ZipOutputStream)IOUtil.closeOutputStream(output);
                return;
            }
            try {
                modified = this.addInstrumentationToArchive(archive, input, output);
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot instrument archive: " + archive.getAbsolutePath()), (Throwable)e);
                Object var8_12 = null;
                input = (ZipInputStream)IOUtil.closeInputStream(input);
                output = (ZipOutputStream)IOUtil.closeOutputStream(output);
                return;
            }
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            throw throwable;
        }
        input = (ZipInputStream)IOUtil.closeInputStream(input);
        output = (ZipOutputStream)IOUtil.closeOutputStream(output);
        if (modified && this.destinationDirectory == null) {
            try {
                logger.debug((Object)("Moving " + outputFile.getAbsolutePath() + " to " + archive.getAbsolutePath()));
                IOUtil.moveFile(outputFile, archive);
            }
            catch (IOException e) {
                logger.warn((Object)("Cannot instrument archive: " + archive.getAbsolutePath()), (Throwable)e);
                return;
            }
        }
        if (this.destinationDirectory != null && !modified) {
            outputFile.delete();
        }
    }

    private void addInstrumentationToSingleClass(File file) {
        ClassInstrumenter cv;
        ClassWriter cw;
        logger.debug((Object)("Instrumenting class " + file.getAbsolutePath()));
        InputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(file);
                ClassReader cr = new ClassReader(inputStream);
                cw = new ClassWriter(true);
                cv = new ClassInstrumenter(this.projectData, (ClassVisitor)cw, this.ignoreRegexes);
                cr.accept((ClassVisitor)cv, false);
            }
            catch (Throwable t) {
                logger.warn((Object)("Unable to instrument file " + file.getAbsolutePath()), t);
                Object var7_8 = null;
                inputStream = IOUtil.closeInputStream(inputStream);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            inputStream = IOUtil.closeInputStream(inputStream);
            throw throwable;
        }
        inputStream = IOUtil.closeInputStream(inputStream);
        OutputStream outputStream = null;
        try {
            block10: {
                try {
                    if (!cv.isInstrumented()) break block10;
                    File outputFile = this.destinationDirectory == null ? file : new File(this.destinationDirectory, cv.getClassName().replace('.', File.separatorChar) + ".class");
                    File parentFile = outputFile.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    byte[] instrumentedClass = cw.toByteArray();
                    outputStream = new FileOutputStream(outputFile);
                    outputStream.write(instrumentedClass);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Unable to instrument file " + file.getAbsolutePath()), t);
                    Object var10_15 = null;
                    outputStream = IOUtil.closeOutputStream(outputStream);
                    return;
                }
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            outputStream = IOUtil.closeOutputStream(outputStream);
            throw throwable;
        }
        outputStream = IOUtil.closeOutputStream(outputStream);
    }

    private void addInstrumentation(CoberturaFile coberturaFile) {
        if (coberturaFile.isClass() && this.classPattern.matches(coberturaFile.getPathname())) {
            this.addInstrumentationToSingleClass(coberturaFile);
        } else if (coberturaFile.isDirectory()) {
            String[] contents = coberturaFile.list();
            int i = 0;
            while (i < contents.length) {
                File relativeFile = new File(coberturaFile.getPathname(), contents[i]);
                CoberturaFile relativeCoberturaFile = new CoberturaFile(coberturaFile.getBaseDir(), relativeFile.toString());
                this.addInstrumentation(relativeCoberturaFile);
                ++i;
            }
        }
    }

    private void parseArguments(String[] args) {
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        ArrayList<CoberturaFile> filePaths = new ArrayList<CoberturaFile>();
        String baseDir = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--basedir")) {
                baseDir = args[++i];
            } else if (args[i].equals("--datafile")) {
                dataFile = new File(args[++i]);
            } else if (args[i].equals("--destination")) {
                this.destinationDirectory = new File(args[++i]);
            } else if (args[i].equals("--ignore")) {
                RegexUtil.addRegex(this.ignoreRegexes, args[++i]);
            } else if (args[i].equals("--includeClasses")) {
                this.classPattern.addIncludeClassesRegex(args[++i]);
            } else if (args[i].equals("--excludeClasses")) {
                this.classPattern.addExcludeClassesRegex(args[++i]);
            } else {
                CoberturaFile coberturaFile = new CoberturaFile(baseDir, args[i]);
                filePaths.add(coberturaFile);
            }
            ++i;
        }
        if (dataFile.isFile()) {
            this.projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (this.projectData == null) {
            this.projectData = new ProjectData();
        }
        System.out.println("Instrumenting " + filePaths.size() + " " + (filePaths.size() == 1 ? "file" : "files") + (this.destinationDirectory != null ? " to " + this.destinationDirectory.getAbsoluteFile() : ""));
        Iterator iter = filePaths.iterator();
        while (iter.hasNext()) {
            CoberturaFile coberturaFile = (CoberturaFile)iter.next();
            if (coberturaFile.isArchive()) {
                this.addInstrumentationToArchive(coberturaFile);
                continue;
            }
            this.addInstrumentation(coberturaFile);
        }
        CoverageDataFileHandler.saveCoverageData(this.projectData, dataFile);
    }

    public static void main(String[] args) {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        Main main = new Main();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            System.exit(1);
        }
        main.parseArguments(args);
        long stopTime = System.currentTimeMillis();
        System.out.println("Instrument time: " + (stopTime - startTime) + "ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

