/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server.impl;

import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.server.impl.FileBasedCollection;
import com.sun.syndication.propono.atom.server.impl.FileBasedWorkspace;
import com.sun.syndication.propono.utils.Utilities;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class FileBasedAtomService
extends AtomService {
    private String baseDir = null;
    private Map workspaceMap = new TreeMap();
    private Map collectionMap = new TreeMap();
    private static Properties cacheProps = new Properties();
    private boolean firstTime = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedAtomService(String userName, String baseDir, String appURI) throws Exception {
        String colnames;
        this.baseDir = baseDir;
        String workspaceHandle = userName;
        FileBasedWorkspace workspace = new FileBasedWorkspace(workspaceHandle, baseDir);
        this.workspaceMap.put(userName, workspace);
        if (this.firstTime) {
            Properties properties = cacheProps;
            synchronized (properties) {
                InputStream is = this.getClass().getResourceAsStream("/propono.properties");
                cacheProps.load(is);
                this.firstTime = false;
            }
        }
        if ((colnames = cacheProps.getProperty("propono.atomserver.filebased.collections")) != null) {
            String[] colarray = Utilities.stringToStringArray(colnames, ",");
            for (int i = 0; i < colarray.length; ++i) {
                String prefix = "propono.atomserver.filebased.collection." + colarray[i] + ".";
                String collectionTitle = cacheProps.getProperty(prefix + "title");
                String collectionSingular = cacheProps.getProperty(prefix + "singular");
                String collectionPlural = cacheProps.getProperty(prefix + "plural");
                String collectionAccept = cacheProps.getProperty(prefix + "accept");
                FileBasedCollection entries = new FileBasedCollection(collectionTitle, workspaceHandle, collectionPlural, collectionSingular, baseDir, collectionAccept, appURI);
                workspace.addCollection(entries);
                this.collectionMap.put(workspaceHandle + "|" + collectionSingular, entries);
                this.collectionMap.put(workspaceHandle + "|" + collectionPlural, entries);
            }
        } else {
            FileBasedCollection entries = new FileBasedCollection("Entries", workspaceHandle, "entries", "entry", baseDir, "entry", appURI);
            workspace.addCollection(entries);
            this.collectionMap.put(workspaceHandle + "|entry", entries);
            this.collectionMap.put(workspaceHandle + "|entries", entries);
            FileBasedCollection resources = new FileBasedCollection("Resources", workspaceHandle, "resources", "resource", baseDir, "*/*", appURI);
            workspace.addCollection(resources);
            this.collectionMap.put(workspaceHandle + "|resource", resources);
            this.collectionMap.put(workspaceHandle + "|resources", resources);
        }
        this.getWorkspaces().add(workspace);
    }

    FileBasedWorkspace findWorkspaceByHandle(String handle) {
        return (FileBasedWorkspace)this.workspaceMap.get(handle);
    }

    FileBasedCollection findCollectionByHandle(String handle, String collection) {
        return (FileBasedCollection)this.collectionMap.get(handle + "|" + collection);
    }
}

