/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Utilities {
    private static final String LS = System.getProperty("line.separator");

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static String streamToString(InputStream is) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append(LS);
        }
        return sb.toString();
    }

    public static void copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        byte[] buffer = new byte[8192];
        int count = 0;
        while (count != -1) {
            count = in.read(buffer, 0, 8192);
            if (count == -1) continue;
            out.write(buffer, 0, count);
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException ex) {
            throw new IOException("Closing file streams, " + ex.getMessage());
        }
    }

    public static String replaceNonAlphanumeric(String str, char subst) {
        StringBuffer ret = new StringBuffer(str.length());
        char[] testChars = str.toCharArray();
        for (int i = 0; i < testChars.length; ++i) {
            if (Character.isLetterOrDigit(testChars[i])) {
                ret.append(testChars[i]);
                continue;
            }
            ret.append(subst);
        }
        return ret.toString();
    }

    public static String[] stringToStringArray(String instr, String delim) throws NoSuchElementException, NumberFormatException {
        StringTokenizer toker = new StringTokenizer(instr, delim);
        String[] stringArray = new String[toker.countTokens()];
        int i = 0;
        while (toker.hasMoreTokens()) {
            stringArray[i++] = toker.nextToken();
        }
        return stringArray;
    }

    public static String stringArrayToString(String[] stringArray, String delim) {
        String ret = "";
        for (int i = 0; i < stringArray.length; ++i) {
            ret = ret.length() > 0 ? ret + delim + stringArray[i] : stringArray[i];
        }
        return ret;
    }
}

