/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.sound.wordtosound;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.sound.soundconfigurator.FreeTTSSoundConfigurator;
import com.octo.captcha.component.sound.soundconfigurator.SoundConfigurator;
import com.octo.captcha.component.sound.wordtosound.WordToSound;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.Locale;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class AbstractFreeTTSWordToSound
implements WordToSound {
    public static String defaultVoiceName = "kevin16";
    public static String defaultVoicePackage = "com.sun.speech.freetts.en.us.cmu_time_awb.AlanVoiceDirectory,com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory";
    private static String FREETTS_PROPERTIES_KEY = "freetts.voices";
    private int maxAcceptedWordLength;
    private int minAcceptedWordLength;
    private SoundConfigurator configurator = null;
    private Voice voice = null;
    private Voice defaultVoice = null;
    private Locale locale = null;
    private VoiceManager voiceManager = null;
    private boolean isInitiated = false;

    public AbstractFreeTTSWordToSound() {
        this.configurator = new FreeTTSSoundConfigurator(defaultVoiceName, defaultVoicePackage, 1.0f, 100.0f, 100.0f);
        this.minAcceptedWordLength = 4;
        this.maxAcceptedWordLength = 6;
        this.init();
    }

    public AbstractFreeTTSWordToSound(SoundConfigurator configurator, int minAcceptedWordLength, int maxAcceptedWordLength) {
        this.configurator = configurator;
        this.minAcceptedWordLength = minAcceptedWordLength;
        this.maxAcceptedWordLength = maxAcceptedWordLength;
        this.init();
    }

    public AudioInputStream getSound(String word) throws CaptchaException {
        this.voice = this.defaultVoice;
        return this.addEffects(this.stringToSound(word));
    }

    public AudioInputStream getSound(String word, Locale locale) throws CaptchaException {
        Voice[] voices = this.voiceManager.getVoices();
        Voice selectedVoice = null;
        if (this.defaultVoice.getLocale().equals(locale)) {
            this.voice = this.defaultVoice;
        } else {
            for (int i = 0; i < voices.length; ++i) {
                if (!voices[i].getLocale().equals(locale)) continue;
                selectedVoice = voices[i];
            }
            if (selectedVoice != null) {
                selectedVoice.allocate();
                this.voice = selectedVoice;
                this.configureVoice(this.voice);
            } else {
                throw new CaptchaException("No voice corresponding to the Locale");
            }
        }
        return this.addEffects(this.stringToSound(word));
    }

    public int getMaxAcceptedWordLength() {
        return this.maxAcceptedWordLength;
    }

    public int getMinAcceptedWordLength() {
        return this.minAcceptedWordLength;
    }

    public int getMaxAcceptedWordLenght() {
        return this.maxAcceptedWordLength;
    }

    public int getMinAcceptedWordLenght() {
        return this.minAcceptedWordLength;
    }

    protected abstract AudioInputStream addEffects(AudioInputStream var1);

    private void init() {
        if (!this.isInitiated) {
            AbstractFreeTTSWordToSound.addToSystemesPropetites(this.configurator.getLocation());
            this.voiceManager = VoiceManager.getInstance();
            this.defaultVoice = this.voiceManager.getVoice(this.configurator.getName());
            this.configureVoice(this.defaultVoice);
            this.defaultVoice.allocate();
            this.isInitiated = true;
        }
    }

    private static void addToSystemesPropetites(String soundPackage) {
        String packages = System.getProperty(FREETTS_PROPERTIES_KEY);
        if (packages == null) {
            packages = soundPackage;
        } else if (packages.indexOf(soundPackage) == -1) {
            packages = packages + "," + soundPackage;
        }
        System.getProperties().put(FREETTS_PROPERTIES_KEY, packages);
    }

    private void configureVoice(Voice voice) {
        voice.setPitch(this.configurator.getPitch());
        voice.setVolume(this.configurator.getVolume());
        voice.setRate(this.configurator.getRate());
    }

    public synchronized AudioInputStream stringToSound(String sentence) throws CaptchaException {
        InputStreamAudioPlayer audioPlayer = new InputStreamAudioPlayer();
        this.voice.setAudioPlayer((AudioPlayer)audioPlayer);
        this.voice.speak(sentence);
        AudioInputStream ais = audioPlayer.getAudioInputStream();
        return ais;
    }

    private class InputStreamAudioPlayer
    implements AudioPlayer {
        private boolean debug = Utilities.getBoolean((String)"com.sun.speech.freetts.audio.AudioPlayer.debug");
        private AudioFormat currentFormat = null;
        private byte[] outputData;
        private int curIndex = 0;
        private int totBytes = 0;
        private Vector outputList = new Vector();
        private AudioInputStream audioInputStream;

        public synchronized void setAudioFormat(AudioFormat format) {
            this.currentFormat = format;
        }

        public AudioFormat getAudioFormat() {
            return this.currentFormat;
        }

        public void pause() {
        }

        public synchronized void resume() {
        }

        public synchronized void cancel() {
        }

        public synchronized void reset() {
        }

        public void startFirstSampleTimer() {
        }

        public synchronized void close() {
            try {
                this.audioInputStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Problem while closing the audioInputSteam");
            }
        }

        public AudioInputStream getAudioInputStream() {
            SequenceInputStream tInputStream = new SequenceInputStream(this.outputList.elements());
            AudioInputStream tAudioInputStream = new AudioInputStream(tInputStream, this.currentFormat, this.totBytes / this.currentFormat.getFrameSize());
            return tAudioInputStream;
        }

        public float getVolume() {
            return 1.0f;
        }

        public void setVolume(float volume) {
        }

        public void begin(int size) {
            this.outputData = new byte[size];
            this.curIndex = 0;
        }

        public boolean end() {
            this.outputList.add(new ByteArrayInputStream(this.outputData));
            this.totBytes += this.outputData.length;
            return true;
        }

        public boolean drain() {
            return true;
        }

        public synchronized long getTime() {
            return -1L;
        }

        public synchronized void resetTime() {
        }

        public boolean write(byte[] audioData) {
            return this.write(audioData, 0, audioData.length);
        }

        public boolean write(byte[] bytes, int offset, int size) {
            System.arraycopy(bytes, offset, this.outputData, this.curIndex, size);
            this.curIndex += size;
            return true;
        }

        private synchronized boolean waitResume() {
            return true;
        }

        public String toString() {
            return "AudioInputStreamAudioPlayer";
        }

        private void debugPrint(String msg) {
            if (this.debug) {
                System.out.println(this.toString() + ": " + msg);
            }
        }

        public void showMetrics() {
        }
    }
}

