/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine.manager;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.engine.bufferedengine.ContainerConfiguration;
import com.octo.captcha.engine.bufferedengine.QuartzBufferedEngineContainer;
import com.octo.captcha.engine.bufferedengine.manager.BufferedEngineContainerManager;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzBufferedEngineManager
implements BufferedEngineContainerManager {
    private static final Log log = LogFactory.getLog((String)(class$com$octo$captcha$engine$bufferedengine$manager$QuartzBufferedEngineManager == null ? (class$com$octo$captcha$engine$bufferedengine$manager$QuartzBufferedEngineManager = QuartzBufferedEngineManager.class$("com.octo.captcha.engine.bufferedengine.manager.QuartzBufferedEngineManager")) : class$com$octo$captcha$engine$bufferedengine$manager$QuartzBufferedEngineManager).getName());
    private static QuartzBufferedEngineManager helperInstance = null;
    Scheduler schduler = null;
    CronTrigger cronFeeder = null;
    CronTrigger cronSwapper = null;
    QuartzBufferedEngineContainer container = null;
    ContainerConfiguration config = null;
    JobDetail jobFeeder = null;
    JobDetail jobSwapper = null;
    static /* synthetic */ Class class$com$octo$captcha$engine$bufferedengine$manager$QuartzBufferedEngineManager;

    public QuartzBufferedEngineManager(QuartzBufferedEngineContainer container, Scheduler factory, CronTrigger cronFeeder, CronTrigger cronSwapper, JobDetail jobFeeder, JobDetail jobSwapper) {
        this.cronFeeder = cronFeeder;
        this.cronSwapper = cronSwapper;
        this.jobFeeder = jobFeeder;
        this.jobSwapper = jobSwapper;
        this.schduler = factory;
        this.container = container;
        this.config = container.getConfig();
    }

    public synchronized void startToFeedPersistantBuffer() {
        try {
            String name = this.cronFeeder.getName();
            String groupeName = this.cronFeeder.getGroup();
            this.schduler.resumeTrigger(name, groupeName);
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public synchronized void stopToFeedPersistentBuffer() {
        try {
            String name = this.cronFeeder.getName();
            String groupeName = this.cronFeeder.getGroup();
            this.schduler.pauseTrigger(name, groupeName);
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public synchronized void startToSwapFromPersistentToVolatileMemory() {
        try {
            String name = this.cronSwapper.getName();
            String groupeName = this.cronSwapper.getGroup();
            this.schduler.resumeTrigger(name, groupeName);
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public void stopToSwapFromPersistentToVolatileMemory() {
        try {
            String name = this.cronSwapper.getName();
            String groupeName = this.cronSwapper.getGroup();
            this.schduler.pauseTrigger(name, groupeName);
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public void setFeedCronExpr(String feedCronExpr) {
        if (!this.cronFeeder.getCronExpression().equalsIgnoreCase(feedCronExpr)) {
            log.info((Object)"set new cron expr for feed");
            try {
                String name = this.cronFeeder.getName();
                String groupeName = this.cronFeeder.getGroup();
                this.schduler.unscheduleJob(name, groupeName);
                this.cronFeeder.setCronExpression(feedCronExpr);
                this.schduler.scheduleJob(this.jobFeeder, (Trigger)this.cronFeeder);
            }
            catch (ParseException e) {
                throw new CaptchaException(e);
            }
            catch (SchedulerException e) {
                throw new CaptchaException(e);
            }
        }
    }

    public void setSwapCronExpr(String swapCronExpr) {
        if (!this.cronSwapper.getCronExpression().equalsIgnoreCase(swapCronExpr)) {
            log.info((Object)"set new cron expr for swap");
            try {
                String name = this.cronSwapper.getName();
                String groupeName = this.cronSwapper.getGroup();
                this.schduler.unscheduleJob(name, groupeName);
                this.cronSwapper.setCronExpression(swapCronExpr);
                this.schduler.scheduleJob(this.jobSwapper, (Trigger)this.cronSwapper);
            }
            catch (ParseException e) {
                throw new CaptchaException(e);
            }
            catch (SchedulerException e) {
                throw new CaptchaException(e);
            }
        }
    }

    public String getFeedCronExpr() {
        return this.cronFeeder.getCronExpression();
    }

    public String getSwapCronExpr() {
        return this.cronSwapper.getCronExpression();
    }

    public void pause() {
        try {
            this.schduler.pause();
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public void resume() {
        try {
            this.schduler.start();
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public void shutdown() {
        try {
            this.schduler.shutdown(true);
            while (!this.schduler.isShutdown()) {
            }
            this.container.getPersistentBuffer().dispose();
        }
        catch (SchedulerException e) {
            throw new CaptchaException(e);
        }
    }

    public int getPersistentFeedings() {
        return this.container.getPersistentFeedings();
    }

    public int getPersistentMemoryHits() {
        return this.container.getPersistentMemoryHits();
    }

    public int getPersistentToVolatileSwaps() {
        return this.container.getPersistentToVolatileSwaps();
    }

    public int getVolatileMemoryHits() {
        return this.container.getVolatileMemoryHits();
    }

    public int getFeedSize() {
        return this.config.getFeedSize();
    }

    public void setFeedSize(int feedSize) {
        this.config.setFeedSize(new Integer(feedSize));
    }

    public HashedMap getLocaleRatio() {
        return this.config.getLocaleRatio();
    }

    public synchronized void setLocaleRatio(String localeName, double ratio) {
        Locale locale = this.getLocaleFromName(localeName);
        MapIterator it = this.config.getLocaleRatio().mapIterator();
        boolean isSet = false;
        double coef = ratio;
        double oldValue = 0.0;
        if (this.config.getLocaleRatio().containsKey((Object)locale)) {
            oldValue = (Double)this.config.getLocaleRatio().get((Object)locale);
            coef = ratio - oldValue;
        }
        while (it.hasNext()) {
            Locale tempLocale = (Locale)it.next();
            double value = (Double)it.getValue();
            if (locale.equals(tempLocale)) {
                it.setValue((Object)new Double(coef + value));
                isSet = true;
                continue;
            }
            if (coef < 0.0) {
                it.setValue((Object)new Double(value - coef * value / (1.0 - oldValue)));
                continue;
            }
            it.setValue((Object)new Double(value - value * coef));
        }
        if (!isSet) {
            this.config.getLocaleRatio().put((Object)locale, (Object)new Double(ratio));
        }
    }

    protected Locale getLocaleFromName(String localeName) {
        StringTokenizer tokenizer = new StringTokenizer(localeName, "_");
        int count = tokenizer.countTokens();
        switch (count) {
            case 2: {
                return new Locale(tokenizer.nextToken(), tokenizer.nextToken());
            }
            case 3: {
                return new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            }
        }
        return Locale.getDefault();
    }

    public synchronized void removeLocaleRatio(String localeName) {
        Locale locale = this.getLocaleFromName(localeName);
        if (this.config.getLocaleRatio().containsKey((Object)locale)) {
            this.setLocaleRatio(localeName, 0.0);
            this.config.getLocaleRatio().remove((Object)locale);
        }
    }

    public int getMaxPersistentMemorySize() {
        return this.config.getMaxPersistentMemorySize();
    }

    public void setMaxPersistentMemorySize(int maxPersistentMemorySize) {
        this.config.setMaxPersistentMemorySize(new Integer(maxPersistentMemorySize));
    }

    public int getMaxVolatileMemorySize() {
        return this.config.getMaxVolatileMemorySize();
    }

    public void setMaxVolatileMemorySize(int maxVolatileMemorySize) {
        this.config.setMaxVolatileMemorySize(new Integer(maxVolatileMemorySize));
    }

    public int getSwapSize() {
        return this.config.getSwapSize();
    }

    public void setSwapSize(int swapSize) {
        this.config.setSwapSize(new Integer(swapSize));
    }

    public int getVolatileBufferSize() {
        return this.container.getVolatileBuffer().size();
    }

    public HashedMap getVolatileBufferSizeByLocales() {
        HashedMap map = new HashedMap();
        Iterator it = this.container.getVolatileBuffer().getLocales().iterator();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            map.put((Object)locale, (Object)new Integer(this.container.getVolatileBuffer().size(locale)));
        }
        return map;
    }

    public int getPersistentBufferSize() {
        return this.container.getPersistentBuffer().size();
    }

    public HashedMap getPersistentBufferSizesByLocales() {
        HashedMap map = new HashedMap();
        Iterator it = this.container.getPersistentBuffer().getLocales().iterator();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            map.put((Object)locale, (Object)new Integer(this.container.getPersistentBuffer().size(locale)));
        }
        return map;
    }

    public void clearVolatileBuffer() {
        this.container.getVolatileBuffer().clear();
    }

    public void clearPersistentBuffer() {
        this.container.getPersistentBuffer().clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

