/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.atom.client.ClientWorkspace;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.rome.ROMEUtilities;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.utils.ProponoException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ClientAtomService
extends AtomService {
    private static Log logger = LogFactory.getLog(ClientAtomService.class);
    private String uri = null;
    private String username = null;
    private String password = null;
    private HttpClient httpClient = null;

    ClientAtomService(String uri, String username, String password) throws ProponoException {
        this.uri = uri;
        this.username = username;
        this.password = password;
        Document doc = null;
        GetMethod method = null;
        int code = -1;
        try {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            URL feedURL = new URL(uri);
            this.httpClient.getState().setCredentials(new AuthScope(feedURL.getHost(), feedURL.getPort()), (Credentials)creds);
            method = new GetMethod(uri);
            this.addAuthentication((HttpMethodBase)method);
            this.httpClient.executeMethod((HttpMethod)method);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(method.getResponseBodyAsStream());
        }
        catch (Throwable t) {
            String msg = "ERROR retrieving Atom Service Document, code: " + code;
            logger.debug((Object)msg, t);
            throw new ProponoException(msg, t);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        this.parseAtomServiceDocument(doc);
    }

    public ClientEntry getEntry(String uri) throws ProponoException {
        GetMethod method = new GetMethod(uri);
        this.addAuthentication((HttpMethodBase)method);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new BlogClientException("ERROR HTTP status code=" + method.getStatusCode());
            }
            Entry romeEntry = ROMEUtilities.parseEntry(new InputStreamReader(method.getResponseBodyAsStream()));
            if (!ROMEUtilities.isMediaEntry(romeEntry)) {
                ClientEntry clientEntry = new ClientEntry(this, null, romeEntry, false);
                return clientEntry;
            }
            ClientMediaEntry clientMediaEntry = new ClientMediaEntry(this, null, romeEntry, false);
            return clientMediaEntry;
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: getting or parsing entry/media", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    private void parseAtomServiceDocument(Document document) {
        Element root = document.getRootElement();
        List spaces = root.getChildren("workspace", AtomService.ATOM_PROTOCOL);
        for (Element e : spaces) {
            this.addWorkspace(new ClientWorkspace(e, this));
        }
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    void addAuthentication(HttpMethodBase method) {
        String pair = this.getUsername() + ":" + this.getPassword();
        String digest = new String(Base64.encodeBase64((byte[])pair.getBytes()));
        String header = "Basic " + digest;
        method.setRequestHeader("Authorization", header);
    }
}

