/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Collection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class Workspace {
    private String title = null;
    private String titleType = null;
    private List collections = new ArrayList();

    public Workspace(String title, String titleType) {
        this.title = title;
        this.titleType = titleType;
    }

    public List getCollections() {
        return this.collections;
    }

    public void addCollection(Collection col) {
        this.collections.add(col);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public void setTitleType(String titleType) {
        this.titleType = titleType;
    }

    public Collection findCollection(String title, String contentType) {
        for (Collection col : this.collections) {
            if (title != null && col.accepts(contentType)) {
                return col;
            }
            if (!col.accepts(contentType)) continue;
            return col;
        }
        return null;
    }

    public static Workspace elementToWorkspace(Element element) {
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        String newTitle = titleElem.getText();
        String newType = null;
        if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
            newType = titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue();
        }
        Workspace space = new Workspace(newTitle, newType);
        List collections = element.getChildren("collection", AtomService.ATOM_PROTOCOL);
        for (Element e : collections) {
            space.addCollection(Collection.elementToCollection(e));
        }
        return space;
    }

    public static Element workspaceToElement(Workspace space) {
        Element element = new Element("workspace", AtomService.ATOM_PROTOCOL);
        Element title = new Element("title", AtomService.ATOM_FORMAT);
        title.setText(space.getTitle());
        element.addContent((Content)title);
        if (space.getTitleType() != null && !space.getTitleType().equals("TEXT")) {
            element.setAttribute("type", space.getTitleType(), AtomService.ATOM_FORMAT);
        }
        for (Collection col : space.getCollections()) {
            element.addContent((Content)Collection.collectionToElement(col));
        }
        return element;
    }
}

