/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCacheException;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.concurrent.Mutex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatingSelfPopulatingCache
extends SelfPopulatingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache == null ? (class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache = UpdatingSelfPopulatingCache.class$("net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache")) : class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache).getName());
    private final LockManager lockManager = new LockManager();
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache;

    public UpdatingSelfPopulatingCache(String name, UpdatingCacheEntryFactory factory) throws CacheException {
        super(name, factory);
    }

    public UpdatingSelfPopulatingCache(String name, CacheManager mgr, CacheEntryFactory factory) throws CacheException {
        super(name, mgr, factory);
    }

    public Serializable get(Serializable key) throws BlockingCacheException {
        String oldThreadName = Thread.currentThread().getName();
        this.setThreadName("get", key);
        Serializable value = null;
        try {
            this.lockManager.acquireLock(key);
            Ehcache backingCache = this.getCache();
            Element element = backingCache.get(key);
            if (element == null) {
                value = super.get(key);
            } else {
                value = element.getValue();
                this.update(key);
            }
            Serializable serializable = value;
            return serializable;
        }
        catch (Throwable throwable) {
            this.setThreadName("put", key);
            this.put(key, null);
            try {
                throw new BlockingCacheException("Could not fetch object for cache entry \"" + key + "\".", throwable);
            }
            catch (NoSuchMethodError e) {
                throw new CacheException("Could not fetch object for cache entry \"" + key + "\".");
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
            this.lockManager.releaseLock(key);
        }
    }

    private void update(Serializable key) {
        try {
            Ehcache backingCache = this.getCache();
            Element element = backingCache.getQuiet(key);
            if (element == null && LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": entry with key " + key + " has been removed - skipping it"));
            }
            this.refreshElement(element, backingCache);
        }
        catch (Exception e) {
            LOG.warn((Object)(this.getName() + "Could not refresh element " + key), (Throwable)e);
        }
    }

    public void refresh() throws CacheException {
        throw new CacheException("UpdatingSelfPopulatingCache objects should not be refreshed.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LockManager {
        protected final Map locks = new HashMap();

        public void acquireLock(Serializable key) throws InterruptedException {
            Mutex lock = this.checkLockExistsForKey(key);
            lock.acquire();
        }

        public void releaseLock(Serializable key) {
            Mutex lock = this.checkLockExistsForKey(key);
            lock.release();
        }

        private synchronized Mutex checkLockExistsForKey(Serializable key) {
            Mutex lock = (Mutex)this.locks.get(key);
            if (lock == null) {
                lock = new Mutex();
                this.locks.put(key, lock);
            }
            return lock;
        }
    }
}

