/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import net.sf.ehcache.distribution.RMIAsynchronousCacheReplicator;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;

public final class RMICacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";

    public final CacheEventListener createCacheEventListener(Properties properties) {
        boolean replicatePuts = this.extractReplicatePuts(properties);
        boolean replicateUpdates = this.extractReplicateUpdates(properties);
        boolean replicateUpdatesViaCopy = this.extractReplicateUpdatesViaCopy(properties);
        boolean replicateRemovals = this.extractReplicateRemovals(properties);
        boolean replicateAsynchronously = this.extractReplicateAsynchronously(properties);
        if (replicateAsynchronously) {
            return new RMIAsynchronousCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
        }
        return new RMISynchronousCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
    }

    protected boolean extractReplicateAsynchronously(Properties properties) {
        String replicateAsynchronouslyString = PropertyUtil.extractAndLogProperty(REPLICATE_ASYNCHRONOUSLY, properties);
        boolean replicateAsynchronously = replicateAsynchronouslyString != null ? PropertyUtil.parseBoolean(replicateAsynchronouslyString) : true;
        return replicateAsynchronously;
    }

    protected boolean extractReplicateRemovals(Properties properties) {
        String replicateRemovalsString = PropertyUtil.extractAndLogProperty(REPLICATE_REMOVALS, properties);
        boolean replicateRemovals = replicateRemovalsString != null ? PropertyUtil.parseBoolean(replicateRemovalsString) : true;
        return replicateRemovals;
    }

    protected boolean extractReplicateUpdatesViaCopy(Properties properties) {
        String replicateUpdatesViaCopyString = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES_VIA_COPY, properties);
        boolean replicateUpdatesViaCopy = replicateUpdatesViaCopyString != null ? PropertyUtil.parseBoolean(replicateUpdatesViaCopyString) : true;
        return replicateUpdatesViaCopy;
    }

    protected boolean extractReplicateUpdates(Properties properties) {
        String replicateUpdatesString = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES, properties);
        boolean replicateUpdates = replicateUpdatesString != null ? PropertyUtil.parseBoolean(replicateUpdatesString) : true;
        return replicateUpdates;
    }

    protected boolean extractReplicatePuts(Properties properties) {
        String replicatePutsString = PropertyUtil.extractAndLogProperty(REPLICATE_PUTS, properties);
        boolean replicatePuts = replicatePutsString != null ? PropertyUtil.parseBoolean(replicatePutsString) : true;
        return replicatePuts;
    }
}

