/*
 * Copyright (c) 2003-2006, Simon Brown
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *
 *   - Neither the name of Pebble nor the names of its contributors may
 *     be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package net.sourceforge.pebble.dao.file;

import junit.framework.TestCase;
import net.sourceforge.pebble.dao.DAOFactory;

/**
 * Tests for the FileDAOFactory class.
 *
 * @author    Simon Brown
 */
public class FileDAOFactoryTest extends TestCase {

  private DAOFactory daoFactory = new FileDAOFactory();

  /**
   * Tests that the correct implementation of a BlogEntryDAO is created.
   */
  public void testGetBlogEntryDAO() {
    assertTrue(daoFactory.getBlogEntryDAO() instanceof FileBlogEntryDAO);
  }

  /**
   * Tests that the correct implementation of a CategoryDAO is created.
   */
  public void testGetCategoryDAO() {
    assertTrue(daoFactory.getCategoryDAO() instanceof FileCategoryDAO);
  }

  /**
   * Tests that the correct implementation of a RefererFilterDAO is created.
   */
  public void testGetRefererFilterDAO() {
    assertTrue(daoFactory.getRefererFilterDAO() instanceof FileRefererFilterDAO);
  }

}
