/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

public class Base32 {
    private static final char[] canonicalChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
    private static final int charDigitsBase = 50;
    private static final int[] charDigits = new int[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final String errorNonCanonicalLength = "non canonical Base32-encoded string length";
    private static final String errorInvalidChar = "invalid character in Base32-encoded string";
    private static final String errorNonCanonicalEnd = "non canonical bits at end of Base32-encoded string";

    public static String encode(byte[] bytes) {
        int bytesLen;
        int bytesOffset = 0;
        int charsOffset = 0;
        int charsLen = ((bytesLen << 3) + 4) / 5;
        char[] chars = new char[charsLen];
        for (bytesLen = bytes.length; bytesLen != 0; bytesLen -= 5) {
            int digit = bytes[bytesOffset] & 0xFF;
            chars[charsOffset] = canonicalChars[digit >>> 3];
            int lastDigit = (digit & 7) << 2;
            if (bytesLen == 1) {
                chars[charsOffset + 1] = canonicalChars[lastDigit];
                break;
            }
            digit = bytes[bytesOffset + 1] & 0xFF;
            chars[charsOffset + 1] = canonicalChars[digit >>> 6 | lastDigit];
            chars[charsOffset + 2] = canonicalChars[digit >>> 1 & 0x1F];
            lastDigit = (digit & 1) << 4;
            if (bytesLen == 2) {
                chars[charsOffset + 3] = canonicalChars[lastDigit];
                break;
            }
            digit = bytes[bytesOffset + 2] & 0xFF;
            chars[charsOffset + 3] = canonicalChars[digit >>> 4 | lastDigit];
            lastDigit = (digit & 0xF) << 1;
            if (bytesLen == 3) {
                chars[charsOffset + 4] = canonicalChars[lastDigit];
                break;
            }
            digit = bytes[bytesOffset + 3] & 0xFF;
            chars[charsOffset + 4] = canonicalChars[digit >>> 7 | lastDigit];
            chars[charsOffset + 5] = canonicalChars[digit >>> 2 & 0x1F];
            lastDigit = (digit & 3) << 3;
            if (bytesLen == 4) {
                chars[charsOffset + 6] = canonicalChars[lastDigit];
                break;
            }
            digit = bytes[bytesOffset + 4] & 0xFF;
            chars[charsOffset + 6] = canonicalChars[digit >>> 5 | lastDigit];
            chars[charsOffset + 7] = canonicalChars[digit & 0x1F];
            bytesOffset += 5;
            charsOffset += 8;
        }
        return new String(chars);
    }

    public static byte[] decode(String encoded) throws IllegalArgumentException {
        int charsLen;
        char[] chars = encoded.toCharArray();
        switch (charsLen & 7) {
            case 1: 
            case 3: 
            case 6: {
                throw new IllegalArgumentException(errorNonCanonicalLength);
            }
        }
        int charDigitsLen = charDigits.length;
        int bytesLen = charsLen * 5 >>> 3;
        byte[] bytes = new byte[bytesLen];
        int bytesOffset = 0;
        int charsOffset = 0;
        for (charsLen = chars.length; charsLen > 0; charsLen -= 8) {
            int digit = chars[charsOffset] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            int lastDigit = digit << 3;
            digit = chars[charsOffset + 1] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[bytesOffset] = (byte)(digit >> 2 | lastDigit);
            lastDigit = (digit & 3) << 6;
            if (charsLen == 2) {
                if (lastDigit == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            digit = chars[charsOffset + 2] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            lastDigit |= (byte)(digit << 1);
            digit = chars[charsOffset + 3] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[bytesOffset + 1] = (byte)(digit >> 4 | lastDigit);
            lastDigit = (byte)((digit & 0xF) << 4);
            if (charsLen == 4) {
                if (lastDigit == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            digit = chars[charsOffset + 4] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[bytesOffset + 2] = (byte)(digit >> 1 | lastDigit);
            lastDigit = (byte)((digit & 1) << 7);
            if (charsLen == 5) {
                if (lastDigit == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            digit = chars[charsOffset + 5] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            lastDigit |= (byte)(digit << 2);
            digit = chars[charsOffset + 6] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[bytesOffset + 3] = (byte)(digit >> 3 | lastDigit);
            lastDigit = (byte)((digit & 7) << 5);
            if (charsLen == 7) {
                if (lastDigit == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            digit = chars[charsOffset + 7] - 50;
            if (digit < 0 || digit >= charDigitsLen || (digit = charDigits[digit]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[bytesOffset + 4] = (byte)(digit | lastDigit);
            charsOffset += 8;
            bytesOffset += 5;
        }
        return bytes;
    }
}

