/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import java.security.DigestException;
import java.security.MessageDigest;

public final class SHA1
extends MessageDigest
implements Cloneable {
    private long bytes;
    private int padded;
    private byte[] pad = new byte[64];
    private int hA;
    private int hB;
    private int hC;
    private int hD;
    private int hE;

    public SHA1() {
        super("SHA-1");
        this.init();
    }

    public Object clone() throws CloneNotSupportedException {
        SHA1 that = (SHA1)super.clone();
        that.pad = (byte[])this.pad.clone();
        return that;
    }

    public void engineReset() {
        int i = 60;
        byte[] buf = this.pad;
        do {
            buf[i - 4] = 0;
            buf[i - 3] = 0;
            buf[i - 2] = 0;
            buf[i - 1] = 0;
            buf[i] = 0;
            buf[i + 1] = 0;
            buf[i + 2] = 0;
            buf[i + 3] = 0;
        } while ((i -= 8) >= 0);
        this.padded = 0;
        this.bytes = 0L;
        this.init();
    }

    protected void init() {
        this.hA = 1732584193;
        this.hB = -271733879;
        this.hC = -1732584194;
        this.hD = 271733878;
        this.hE = -1009589776;
    }

    public void engineUpdate(byte input) {
        ++this.bytes;
        if (this.padded < 63) {
            this.pad[this.padded++] = input;
            return;
        }
        this.pad[63] = input;
        this.padded = 0;
        this.computeBlock(this.pad, 0);
    }

    public void engineUpdate(byte[] input, int offset, int length) {
        if (offset >= 0 && length >= 0 && offset + length <= input.length) {
            this.bytes += (long)length;
            if (this.padded > 0 && this.padded + length >= 64) {
                int remaining = 64 - this.padded;
                System.arraycopy(input, offset, this.pad, this.padded, remaining);
                this.padded = 0;
                this.computeBlock(this.pad, 0);
                offset += remaining;
                length -= remaining;
            }
            while (length >= 512) {
                this.computeBlock(input, offset);
                this.computeBlock(input, offset + 64);
                this.computeBlock(input, offset + 128);
                this.computeBlock(input, offset + 192);
                this.computeBlock(input, offset + 256);
                this.computeBlock(input, offset + 320);
                this.computeBlock(input, offset + 384);
                this.computeBlock(input, offset + 448);
                offset += 512;
                length -= 512;
            }
            while (length >= 64) {
                this.computeBlock(input, offset);
                offset += 64;
                length -= 64;
            }
            if (length > 0) {
                System.arraycopy(input, offset, this.pad, this.padded, length);
                this.padded += length;
            }
            return;
        }
        throw new ArrayIndexOutOfBoundsException(offset);
    }

    public byte[] engineDigest() {
        try {
            byte[] hashvalue = new byte[20];
            this.engineDigest(hashvalue, 0, 20);
            return hashvalue;
        }
        catch (DigestException e) {
            return null;
        }
    }

    public int engineGetDigestLength() {
        return 20;
    }

    public int engineDigest(byte[] hashvalue, int offset, int length) throws DigestException {
        if (length >= 20) {
            if (hashvalue.length - offset >= 20) {
                byte[] buf = this.pad;
                int i = this.padded;
                this.pad[i] = -128;
                switch (i) {
                    case 56: {
                        buf[57] = 0;
                    }
                    case 57: {
                        buf[58] = 0;
                    }
                    case 58: {
                        buf[59] = 0;
                    }
                    case 59: {
                        buf[60] = 0;
                    }
                    case 60: {
                        buf[61] = 0;
                    }
                    case 61: {
                        buf[62] = 0;
                    }
                    case 62: {
                        buf[63] = 0;
                    }
                    case 63: {
                        this.computeBlock(buf, 0);
                        i = -1;
                    }
                }
                switch (i & 7) {
                    case 7: {
                        i -= 3;
                        break;
                    }
                    case 6: {
                        buf[(i -= 2) + 3] = 0;
                        break;
                    }
                    case 5: {
                        buf[--i + 2] = 0;
                        buf[i + 3] = 0;
                        break;
                    }
                    case 4: {
                        buf[i + 1] = 0;
                        buf[i + 2] = 0;
                        buf[i + 3] = 0;
                        break;
                    }
                    case 3: {
                        buf[++i] = 0;
                        buf[i + 1] = 0;
                        buf[i + 2] = 0;
                        buf[i + 3] = 0;
                        break;
                    }
                    case 2: {
                        buf[(i += 2) - 1] = 0;
                        buf[i] = 0;
                        buf[i + 1] = 0;
                        buf[i + 2] = 0;
                        buf[i + 3] = 0;
                        break;
                    }
                    case 1: {
                        buf[(i += 3) - 2] = 0;
                        buf[i - 1] = 0;
                        buf[i] = 0;
                        buf[i + 1] = 0;
                        buf[i + 2] = 0;
                        buf[i + 3] = 0;
                        break;
                    }
                    case 0: {
                        buf[(i += 4) - 3] = 0;
                        buf[i - 2] = 0;
                        buf[i - 1] = 0;
                        buf[i] = 0;
                        buf[i + 1] = 0;
                        buf[i + 2] = 0;
                        buf[i + 3] = 0;
                    }
                }
                while ((i += 8) <= 52) {
                    buf[i - 4] = 0;
                    buf[i - 3] = 0;
                    buf[i - 2] = 0;
                    buf[i - 1] = 0;
                    buf[i] = 0;
                    buf[i + 1] = 0;
                    buf[i + 2] = 0;
                    buf[i + 3] = 0;
                }
                i = (int)(this.bytes >>> 29);
                buf[56] = (byte)(i >> 24);
                buf[57] = (byte)(i >>> 16);
                buf[58] = (byte)(i >>> 8);
                buf[59] = (byte)i;
                i = (int)this.bytes << 3;
                buf[60] = (byte)(i >> 24);
                buf[61] = (byte)(i >>> 16);
                buf[62] = (byte)(i >>> 8);
                buf[63] = (byte)i;
                this.computeBlock(this.pad, 0);
                i = this.hA;
                hashvalue[offset] = (byte)(i >>> 24);
                hashvalue[offset + 1] = (byte)(i >>> 16);
                hashvalue[offset + 2] = (byte)(i >>> 8);
                hashvalue[offset + 3] = (byte)i;
                i = this.hB;
                hashvalue[offset + 4] = (byte)(i >>> 24);
                hashvalue[offset + 5] = (byte)(i >>> 16);
                hashvalue[(offset += 10) - 4] = (byte)(i >>> 8);
                hashvalue[offset - 3] = (byte)i;
                i = this.hC;
                hashvalue[offset - 2] = (byte)(i >>> 24);
                hashvalue[offset - 1] = (byte)(i >>> 16);
                hashvalue[offset] = (byte)(i >>> 8);
                hashvalue[offset + 1] = (byte)i;
                i = this.hD;
                hashvalue[offset + 2] = (byte)(i >>> 24);
                hashvalue[offset + 3] = (byte)(i >>> 16);
                hashvalue[offset + 4] = (byte)(i >>> 8);
                hashvalue[offset + 5] = (byte)i;
                i = this.hE;
                hashvalue[offset += 6] = (byte)(i >>> 24);
                hashvalue[offset + 1] = (byte)(i >>> 16);
                hashvalue[offset + 2] = (byte)(i >>> 8);
                hashvalue[offset + 3] = (byte)i;
                this.engineReset();
                return 20;
            }
            throw new DigestException("insufficient space in output buffer to store the digest");
        }
        throw new DigestException("partial digests not returned");
    }

    private void computeBlock(byte[] input, int offset) {
        int i0 = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        int c = this.hC;
        int d = this.hD;
        int b = this.hB;
        int a = this.hA;
        int e = i0 + ((c ^ d) & b ^ d) + (a << 5 | a >>> 27) + 1518500249 + this.hE;
        int i1 = input[offset + 4] << 24 | (input[offset + 5] & 0xFF) << 16 | (input[(offset += 10) - 4] & 0xFF) << 8 | input[offset - 3] & 0xFF;
        b = b << 30 | b >>> 2;
        d = i1 + ((b ^ c) & a ^ c) + (e << 5 | e >>> 27) + 1518500249 + d;
        int i2 = input[offset - 2] << 24 | (input[offset - 1] & 0xFF) << 16 | (input[offset] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        a = a << 30 | a >>> 2;
        c = i2 + ((a ^ b) & e ^ b) + (d << 5 | d >>> 27) + 1518500249 + c;
        int i3 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset + 5] & 0xFF;
        e = e << 30 | e >>> 2;
        b = i3 + ((e ^ a) & d ^ a) + (c << 5 | c >>> 27) + 1518500249 + b;
        int i4 = input[(offset += 10) - 4] << 24 | (input[offset - 3] & 0xFF) << 16 | (input[offset - 2] & 0xFF) << 8 | input[offset - 1] & 0xFF;
        d = d << 30 | d >>> 2;
        a = i4 + ((d ^ e) & c ^ e) + (b << 5 | b >>> 27) + 1518500249 + a;
        int i5 = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        c = c << 30 | c >>> 2;
        e = i5 + ((c ^ d) & b ^ d) + (a << 5 | a >>> 27) + 1518500249 + e;
        int i6 = input[offset + 4] << 24 | (input[offset + 5] & 0xFF) << 16 | (input[(offset += 10) - 4] & 0xFF) << 8 | input[offset - 3] & 0xFF;
        b = b << 30 | b >>> 2;
        d = i6 + ((b ^ c) & a ^ c) + (e << 5 | e >>> 27) + 1518500249 + d;
        int i7 = input[offset - 2] << 24 | (input[offset - 1] & 0xFF) << 16 | (input[offset] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        a = a << 30 | a >>> 2;
        c = i7 + ((a ^ b) & e ^ b) + (d << 5 | d >>> 27) + 1518500249 + c;
        int i8 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset + 5] & 0xFF;
        e = e << 30 | e >>> 2;
        b = i8 + ((e ^ a) & d ^ a) + (c << 5 | c >>> 27) + 1518500249 + b;
        int i9 = input[(offset += 10) - 4] << 24 | (input[offset - 3] & 0xFF) << 16 | (input[offset - 2] & 0xFF) << 8 | input[offset - 1] & 0xFF;
        d = d << 30 | d >>> 2;
        a = i9 + ((d ^ e) & c ^ e) + (b << 5 | b >>> 27) + 1518500249 + a;
        int iA = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        c = c << 30 | c >>> 2;
        e = iA + ((c ^ d) & b ^ d) + (a << 5 | a >>> 27) + 1518500249 + e;
        int iB = input[offset + 4] << 24 | (input[offset + 5] & 0xFF) << 16 | (input[(offset += 10) - 4] & 0xFF) << 8 | input[offset - 3] & 0xFF;
        b = b << 30 | b >>> 2;
        d = iB + ((b ^ c) & a ^ c) + (e << 5 | e >>> 27) + 1518500249 + d;
        int iC = input[offset - 2] << 24 | (input[offset - 1] & 0xFF) << 16 | (input[offset] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        a = a << 30 | a >>> 2;
        c = iC + ((a ^ b) & e ^ b) + (d << 5 | d >>> 27) + 1518500249 + c;
        int iD = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset + 5] & 0xFF;
        e = e << 30 | e >>> 2;
        b = iD + ((e ^ a) & d ^ a) + (c << 5 | c >>> 27) + 1518500249 + b;
        int iE = input[(offset += 10) - 4] << 24 | (input[offset - 3] & 0xFF) << 16 | (input[offset - 2] & 0xFF) << 8 | input[offset - 1] & 0xFF;
        d = d << 30 | d >>> 2;
        a = iE + ((d ^ e) & c ^ e) + (b << 5 | b >>> 27) + 1518500249 + a;
        int iF = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        c = c << 30 | c >>> 2;
        e = iF + ((c ^ d) & b ^ d) + (a << 5 | a >>> 27) + 1518500249 + e;
        i0 = i0 ^ i2 ^ i8 ^ iD;
        i0 = i0 << 1 | i0 >>> 31;
        b = b << 30 | b >>> 2;
        d = i0 + ((b ^ c) & a ^ c) + (e << 5 | e >>> 27) + 1518500249 + d;
        i1 = i1 ^ i3 ^ i9 ^ iE;
        i1 = i1 << 1 | i1 >>> 31;
        a = a << 30 | a >>> 2;
        c = i1 + ((a ^ b) & e ^ b) + (d << 5 | d >>> 27) + 1518500249 + c;
        i2 = i2 ^ i4 ^ iA ^ iF;
        i2 = i2 << 1 | i2 >>> 31;
        e = e << 30 | e >>> 2;
        b = i2 + ((e ^ a) & d ^ a) + (c << 5 | c >>> 27) + 1518500249 + b;
        i3 = i3 ^ i5 ^ iB ^ i0;
        i3 = i3 << 1 | i3 >>> 31;
        d = d << 30 | d >>> 2;
        a = i3 + ((d ^ e) & c ^ e) + (b << 5 | b >>> 27) + 1518500249 + a;
        i4 = i4 ^ i6 ^ iC ^ i1;
        i4 = i4 << 1 | i4 >>> 31;
        c = c << 30 | c >>> 2;
        e = i4 + (c ^ b ^ d) + (a << 5 | a >>> 27) + 1859775393 + e;
        i5 = i5 ^ i7 ^ iD ^ i2;
        i5 = i5 << 1 | i5 >>> 31;
        b = b << 30 | b >>> 2;
        d = i5 + (b ^ a ^ c) + (e << 5 | e >>> 27) + 1859775393 + d;
        i6 = i6 ^ i8 ^ iE ^ i3;
        i6 = i6 << 1 | i6 >>> 31;
        a = a << 30 | a >>> 2;
        c = i6 + (a ^ e ^ b) + (d << 5 | d >>> 27) + 1859775393 + c;
        i7 = i7 ^ i9 ^ iF ^ i4;
        i7 = i7 << 1 | i7 >>> 31;
        e = e << 30 | e >>> 2;
        b = i7 + (e ^ d ^ a) + (c << 5 | c >>> 27) + 1859775393 + b;
        i8 = i8 ^ iA ^ i0 ^ i5;
        i8 = i8 << 1 | i8 >>> 31;
        d = d << 30 | d >>> 2;
        a = i8 + (d ^ c ^ e) + (b << 5 | b >>> 27) + 1859775393 + a;
        i9 = i9 ^ iB ^ i1 ^ i6;
        i9 = i9 << 1 | i9 >>> 31;
        c = c << 30 | c >>> 2;
        e = i9 + (c ^ b ^ d) + (a << 5 | a >>> 27) + 1859775393 + e;
        iA = iA ^ iC ^ i2 ^ i7;
        iA = iA << 1 | iA >>> 31;
        b = b << 30 | b >>> 2;
        d = iA + (b ^ a ^ c) + (e << 5 | e >>> 27) + 1859775393 + d;
        iB = iB ^ iD ^ i3 ^ i8;
        iB = iB << 1 | iB >>> 31;
        a = a << 30 | a >>> 2;
        c = iB + (a ^ e ^ b) + (d << 5 | d >>> 27) + 1859775393 + c;
        iC = iC ^ iE ^ i4 ^ i9;
        iC = iC << 1 | iC >>> 31;
        e = e << 30 | e >>> 2;
        b = iC + (e ^ d ^ a) + (c << 5 | c >>> 27) + 1859775393 + b;
        iD = iD ^ iF ^ i5 ^ iA;
        iD = iD << 1 | iD >>> 31;
        d = d << 30 | d >>> 2;
        a = iD + (d ^ c ^ e) + (b << 5 | b >>> 27) + 1859775393 + a;
        iE = iE ^ i0 ^ i6 ^ iB;
        iE = iE << 1 | iE >>> 31;
        c = c << 30 | c >>> 2;
        e = iE + (c ^ b ^ d) + (a << 5 | a >>> 27) + 1859775393 + e;
        iF = iF ^ i1 ^ i7 ^ iC;
        iF = iF << 1 | iF >>> 31;
        b = b << 30 | b >>> 2;
        d = iF + (b ^ a ^ c) + (e << 5 | e >>> 27) + 1859775393 + d;
        i0 = i0 ^ i2 ^ i8 ^ iD;
        i0 = i0 << 1 | i0 >>> 31;
        a = a << 30 | a >>> 2;
        c = i0 + (a ^ e ^ b) + (d << 5 | d >>> 27) + 1859775393 + c;
        i1 = i1 ^ i3 ^ i9 ^ iE;
        i1 = i1 << 1 | i1 >>> 31;
        e = e << 30 | e >>> 2;
        b = i1 + (e ^ d ^ a) + (c << 5 | c >>> 27) + 1859775393 + b;
        i2 = i2 ^ i4 ^ iA ^ iF;
        i2 = i2 << 1 | i2 >>> 31;
        d = d << 30 | d >>> 2;
        a = i2 + (d ^ c ^ e) + (b << 5 | b >>> 27) + 1859775393 + a;
        i3 = i3 ^ i5 ^ iB ^ i0;
        i3 = i3 << 1 | i3 >>> 31;
        c = c << 30 | c >>> 2;
        e = i3 + (c ^ b ^ d) + (a << 5 | a >>> 27) + 1859775393 + e;
        i4 = i4 ^ i6 ^ iC ^ i1;
        i4 = i4 << 1 | i4 >>> 31;
        b = b << 30 | b >>> 2;
        d = i4 + (b ^ a ^ c) + (e << 5 | e >>> 27) + 1859775393 + d;
        i5 = i5 ^ i7 ^ iD ^ i2;
        i5 = i5 << 1 | i5 >>> 31;
        a = a << 30 | a >>> 2;
        c = i5 + (a ^ e ^ b) + (d << 5 | d >>> 27) + 1859775393 + c;
        i6 = i6 ^ i8 ^ iE ^ i3;
        i6 = i6 << 1 | i6 >>> 31;
        e = e << 30 | e >>> 2;
        b = i6 + (e ^ d ^ a) + (c << 5 | c >>> 27) + 1859775393 + b;
        i7 = i7 ^ i9 ^ iF ^ i4;
        i7 = i7 << 1 | i7 >>> 31;
        d = d << 30 | d >>> 2;
        a = i7 + (d ^ c ^ e) + (b << 5 | b >>> 27) + 1859775393 + a;
        i8 = i8 ^ iA ^ i0 ^ i5;
        i8 = i8 << 1 | i8 >>> 31;
        c = c << 30 | c >>> 2;
        e = i8 + ((c | b) & d | c & b) + (a << 5 | a >>> 27) + -1894007588 + e;
        i9 = i9 ^ iB ^ i1 ^ i6;
        i9 = i9 << 1 | i9 >>> 31;
        b = b << 30 | b >>> 2;
        d = i9 + ((b | a) & c | b & a) + (e << 5 | e >>> 27) + -1894007588 + d;
        iA = iA ^ iC ^ i2 ^ i7;
        iA = iA << 1 | iA >>> 31;
        a = a << 30 | a >>> 2;
        c = iA + ((a | e) & b | a & e) + (d << 5 | d >>> 27) + -1894007588 + c;
        iB = iB ^ iD ^ i3 ^ i8;
        iB = iB << 1 | iB >>> 31;
        e = e << 30 | e >>> 2;
        b = iB + ((e | d) & a | e & d) + (c << 5 | c >>> 27) + -1894007588 + b;
        iC = iC ^ iE ^ i4 ^ i9;
        iC = iC << 1 | iC >>> 31;
        d = d << 30 | d >>> 2;
        a = iC + ((d | c) & e | d & c) + (b << 5 | b >>> 27) + -1894007588 + a;
        iD = iD ^ iF ^ i5 ^ iA;
        iD = iD << 1 | iD >>> 31;
        c = c << 30 | c >>> 2;
        e = iD + ((c | b) & d | c & b) + (a << 5 | a >>> 27) + -1894007588 + e;
        iE = iE ^ i0 ^ i6 ^ iB;
        iE = iE << 1 | iE >>> 31;
        b = b << 30 | b >>> 2;
        d = iE + ((b | a) & c | b & a) + (e << 5 | e >>> 27) + -1894007588 + d;
        iF = iF ^ i1 ^ i7 ^ iC;
        iF = iF << 1 | iF >>> 31;
        a = a << 30 | a >>> 2;
        c = iF + ((a | e) & b | a & e) + (d << 5 | d >>> 27) + -1894007588 + c;
        i0 = i0 ^ i2 ^ i8 ^ iD;
        i0 = i0 << 1 | i0 >>> 31;
        e = e << 30 | e >>> 2;
        b = i0 + ((e | d) & a | d & e) + (c << 5 | c >>> 27) + -1894007588 + b;
        i1 = i1 ^ i3 ^ i9 ^ iE;
        i1 = i1 << 1 | i1 >>> 31;
        d = d << 30 | d >>> 2;
        a = i1 + ((d | c) & e | c & d) + (b << 5 | b >>> 27) + -1894007588 + a;
        i2 = i2 ^ i4 ^ iA ^ iF;
        i2 = i2 << 1 | i2 >>> 31;
        c = c << 30 | c >>> 2;
        e = i2 + ((c | b) & d | b & c) + (a << 5 | a >>> 27) + -1894007588 + e;
        i3 = i3 ^ i5 ^ iB ^ i0;
        i3 = i3 << 1 | i3 >>> 31;
        b = b << 30 | b >>> 2;
        d = i3 + ((b | a) & c | a & b) + (e << 5 | e >>> 27) + -1894007588 + d;
        i4 = i4 ^ i6 ^ iC ^ i1;
        i4 = i4 << 1 | i4 >>> 31;
        a = a << 30 | a >>> 2;
        c = i4 + ((a | e) & b | e & a) + (d << 5 | d >>> 27) + -1894007588 + c;
        i5 = i5 ^ i7 ^ iD ^ i2;
        i5 = i5 << 1 | i5 >>> 31;
        e = e << 30 | e >>> 2;
        b = i5 + ((e | d) & a | d & e) + (c << 5 | c >>> 27) + -1894007588 + b;
        i6 = i6 ^ i8 ^ iE ^ i3;
        i6 = i6 << 1 | i6 >>> 31;
        d = d << 30 | d >>> 2;
        a = i6 + ((d | c) & e | c & d) + (b << 5 | b >>> 27) + -1894007588 + a;
        i7 = i7 ^ i9 ^ iF ^ i4;
        i7 = i7 << 1 | i7 >>> 31;
        c = c << 30 | c >>> 2;
        e = i7 + ((c | b) & d | b & c) + (a << 5 | a >>> 27) + -1894007588 + e;
        i8 = i8 ^ iA ^ i0 ^ i5;
        i8 = i8 << 1 | i8 >>> 31;
        b = b << 30 | b >>> 2;
        d = i8 + ((b | a) & c | a & b) + (e << 5 | e >>> 27) + -1894007588 + d;
        i9 = i9 ^ iB ^ i1 ^ i6;
        i9 = i9 << 1 | i9 >>> 31;
        a = a << 30 | a >>> 2;
        c = i9 + ((a | e) & b | e & a) + (d << 5 | d >>> 27) + -1894007588 + c;
        iA = iA ^ iC ^ i2 ^ i7;
        iA = iA << 1 | iA >>> 31;
        e = e << 30 | e >>> 2;
        b = iA + ((e | d) & a | d & e) + (c << 5 | c >>> 27) + -1894007588 + b;
        iB = iB ^ iD ^ i3 ^ i8;
        iB = iB << 1 | iB >>> 31;
        d = d << 30 | d >>> 2;
        a = iB + ((d | c) & e | c & d) + (b << 5 | b >>> 27) + -1894007588 + a;
        iC = iC ^ iE ^ i4 ^ i9;
        iC = iC << 1 | iC >>> 31;
        c = c << 30 | c >>> 2;
        e = iC + (c ^ b ^ d) + (a << 5 | a >>> 27) + -899497514 + e;
        iD = iD ^ iF ^ i5 ^ iA;
        iD = iD << 1 | iD >>> 31;
        b = b << 30 | b >>> 2;
        d = iD + (b ^ a ^ c) + (e << 5 | e >>> 27) + -899497514 + d;
        iE = iE ^ i0 ^ i6 ^ iB;
        iE = iE << 1 | iE >>> 31;
        a = a << 30 | a >>> 2;
        c = iE + (a ^ e ^ b) + (d << 5 | d >>> 27) + -899497514 + c;
        iF = iF ^ i1 ^ i7 ^ iC;
        iF = iF << 1 | iF >>> 31;
        e = e << 30 | e >>> 2;
        b = iF + (e ^ d ^ a) + (c << 5 | c >>> 27) + -899497514 + b;
        i0 = i0 ^ i2 ^ i8 ^ iD;
        i0 = i0 << 1 | i0 >>> 31;
        d = d << 30 | d >>> 2;
        a = i0 + (d ^ c ^ e) + (b << 5 | b >>> 27) + -899497514 + a;
        i1 = i1 ^ i3 ^ i9 ^ iE;
        i1 = i1 << 1 | i1 >>> 31;
        c = c << 30 | c >>> 2;
        e = i1 + (c ^ b ^ d) + (a << 5 | a >>> 27) + -899497514 + e;
        i2 = i2 ^ i4 ^ iA ^ iF;
        i2 = i2 << 1 | i2 >>> 31;
        b = b << 30 | b >>> 2;
        d = i2 + (b ^ a ^ c) + (e << 5 | e >>> 27) + -899497514 + d;
        i3 = i3 ^ i5 ^ iB ^ i0;
        i3 = i3 << 1 | i3 >>> 31;
        a = a << 30 | a >>> 2;
        c = i3 + (a ^ e ^ b) + (d << 5 | d >>> 27) + -899497514 + c;
        i4 = i4 ^ i6 ^ iC ^ i1;
        i4 = i4 << 1 | i4 >>> 31;
        e = e << 30 | e >>> 2;
        b = i4 + (e ^ d ^ a) + (c << 5 | c >>> 27) + -899497514 + b;
        i5 = i5 ^ i7 ^ iD ^ i2;
        i5 = i5 << 1 | i5 >>> 31;
        d = d << 30 | d >>> 2;
        a = i5 + (d ^ c ^ e) + (b << 5 | b >>> 27) + -899497514 + a;
        i6 = i6 ^ i8 ^ iE ^ i3;
        i6 = i6 << 1 | i6 >>> 31;
        c = c << 30 | c >>> 2;
        e = i6 + (c ^ b ^ d) + (a << 5 | a >>> 27) + -899497514 + e;
        i7 = i7 ^ i9 ^ iF ^ i4;
        i7 = i7 << 1 | i7 >>> 31;
        b = b << 30 | b >>> 2;
        d = i7 + (b ^ a ^ c) + (e << 5 | e >>> 27) + -899497514 + d;
        i8 = i8 ^ iA ^ i0 ^ i5;
        i8 = i8 << 1 | i8 >>> 31;
        a = a << 30 | a >>> 2;
        c = i8 + (a ^ e ^ b) + (d << 5 | d >>> 27) + -899497514 + c;
        i9 = i9 ^ iB ^ i1 ^ i6;
        i9 = i9 << 1 | i9 >>> 31;
        e = e << 30 | e >>> 2;
        b = i9 + (e ^ d ^ a) + (c << 5 | c >>> 27) + -899497514 + b;
        iA = iA ^ iC ^ i2 ^ i7;
        iA = iA << 1 | iA >>> 31;
        d = d << 30 | d >>> 2;
        a = iA + (d ^ c ^ e) + (b << 5 | b >>> 27) + -899497514 + a;
        iB = iB ^ iD ^ i3 ^ i8;
        iB = iB << 1 | iB >>> 31;
        c = c << 30 | c >>> 2;
        e = iB + (c ^ b ^ d) + (a << 5 | a >>> 27) + -899497514 + e;
        iC = iC ^ iE ^ i4 ^ i9;
        iC = iC << 1 | iC >>> 31;
        b = b << 30 | b >>> 2;
        d = iC + (b ^ a ^ c) + (e << 5 | e >>> 27) + -899497514 + d;
        iD = iD ^ iF ^ i5 ^ iA;
        iD = iD << 1 | iD >>> 31;
        a = a << 30 | a >>> 2;
        c = iD + (a ^ e ^ b) + (d << 5 | d >>> 27) + -899497514 + c;
        iE = iE ^ i0 ^ i6 ^ iB;
        iE = iE << 1 | iE >>> 31;
        e = e << 30 | e >>> 2;
        b = iE + (e ^ d ^ a) + (c << 5 | c >>> 27) + -899497514 + b;
        this.hB = b + this.hB;
        iF = iF ^ i1 ^ i7 ^ iC;
        iF = iF << 1 | iF >>> 31;
        d = d << 30 | d >>> 2;
        this.hA = iF + (d ^ c ^ e) + (b << 5 | b >>> 27) + -899497514 + a + this.hA;
        this.hE = e + this.hE;
        this.hD = d + this.hD;
        this.hC = (c << 30 | c >>> 2) + this.hC;
    }
}

