/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import phex.utils.IOUtil;

public class DimeRecord {
    public static final long MAX_MAX_PAYLOAD_SIZE = 0xFFFFFFFFL;
    public static final int DEFAULT_MAX_PAYLOAD_SIZE = Integer.MAX_VALUE;
    public static final int VERSION = 1;
    private static final int VERSION_MASK = 248;
    private static final int VERSION_SHIFT = 3;
    private static final int MB_MASK = 4;
    private static final int ME_MASK = 2;
    private static final int CF_MASK = 1;
    private static final int TYPE_T_MASK = 240;
    private static final int TYPE_T_SHIFT = 4;
    private static final int RESERVED_MASK = 15;
    private TypeNameFormat tnf;
    private byte[] id;
    private byte[] type;
    private boolean first;
    private boolean last;
    private byte[] data;

    public DimeRecord(byte[] data, TypeNameFormat t, String tn, String i) {
        this.tnf = t;
        this.type = tn.getBytes();
        this.id = i != null ? i.getBytes() : IOUtil.EMPTY_BYTE_ARRAY;
        this.data = data;
    }

    protected static DimeRecord extract(InputStream is) throws IOException {
        boolean continued;
        int octet1 = is.read();
        if (octet1 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        boolean last = (octet1 & 2) != 0;
        boolean bl = continued = (octet1 & 1) != 0;
        if (continued) {
            throw new IOException("Continued Dime record not supported.");
        }
        boolean first = (octet1 & 4) != 0;
        int version = (octet1 & 0xF8) >>> 3;
        if (version != 1) {
            throw new IOException("Unparsable Version: " + version);
        }
        int octet2 = is.read();
        if (octet2 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        TypeNameFormat tnf = TypeNameFormat.get((octet2 & 0xF0) >>> 4);
        if ((octet2 & 0xF) != 0) {
            throw new IOException("Reserved header space must be all zero");
        }
        int optLen = DimeRecord.readUnsignedShort(is);
        int idLen = DimeRecord.readUnsignedShort(is);
        int typeLen = DimeRecord.readUnsignedShort(is);
        long payloadLength = DimeRecord.readUnsignedInt(is);
        if (payloadLength > Integer.MAX_VALUE) {
            throw new IOException("Dime payload too large.");
        }
        byte[] opt = DimeRecord.parseField(is, optLen);
        byte[] id = DimeRecord.parseField(is, idLen);
        byte[] type = DimeRecord.parseField(is, typeLen);
        byte[] data = DimeRecord.parseField(is, (int)payloadLength);
        DimeRecord dr = new DimeRecord(data, tnf, new String(type), new String(id));
        dr.last = last;
        dr.first = first;
        return dr;
    }

    private static byte[] parseField(InputStream stream, int len) throws IOException {
        int i;
        int pos;
        int i2;
        byte[] field = new byte[len];
        for (pos = 0; pos < field.length; pos += i2) {
            i2 = stream.read(field, pos, len - pos);
            if (i2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] pad = new byte[(4 - len % 4) % 4];
        for (pos = 0; pos < pad.length; pos += i) {
            i = stream.read(pad, pos, pad.length - pos);
            if (i != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        return field;
    }

    protected synchronized void produce(OutputStream os, long length, boolean begin, boolean end) throws IOException {
        if (this.data == null) {
            throw new IllegalStateException("produce or getPayload already called");
        }
        if (length > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("payload size cannot be bigger than 4294967295");
        }
        byte[] myId = this.id;
        byte[] myType = this.type;
        TypeNameFormat myTnf = this.tnf;
        for (long remaining = (long)this.data.length; remaining > 0L; remaining -= length) {
            int header = 1;
            header <<= 3;
            if (begin) {
                header |= 4;
                begin = false;
            }
            if (end && remaining <= length) {
                header |= 2;
            }
            if (remaining > length) {
                header |= 1;
            }
            header <<= 4;
            header |= myTnf.toInt();
            header <<= 4;
            os.write(DimeRecord.getBytes(header <<= 16));
            header = 0;
            header |= myId.length;
            header <<= 16;
            os.write(DimeRecord.getBytes(header |= myType.length));
            long chunkLen = Math.min(length, remaining);
            os.write(DimeRecord.getBytes((int)(0xFFFFFFFFL & chunkLen)));
            os.write(myId);
            os.write(this.getPad(myId.length));
            os.write(myType);
            os.write(this.getPad(myType.length));
            myType = IOUtil.EMPTY_BYTE_ARRAY;
            myId = IOUtil.EMPTY_BYTE_ARRAY;
            myTnf = TypeNameFormat.UNCHANGED;
            os.write(this.data, 0, this.data.length);
            os.write(this.getPad(chunkLen));
        }
        os.flush();
    }

    private static int readUnsignedShort(InputStream in) throws IOException {
        int i1 = in.read();
        int i2 = in.read();
        if (i1 == -1 || i2 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return (i1 << 8) + i2;
    }

    private static long readUnsignedInt(InputStream in) throws IOException {
        int i1 = in.read();
        int i2 = in.read();
        int i3 = in.read();
        int i4 = in.read();
        if (i1 == -1 || i2 == -1 || i3 == -1 || i4 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return i1 << 24 | i2 << 16 | i3 << 8 | i4;
    }

    private byte[] getPad(long size) {
        byte[] retval = new byte[(4 - (int)(size % 4L)) % 4];
        return retval;
    }

    public synchronized byte[] getData() {
        return this.data;
    }

    public String getId() {
        return this.id == null ? null : (this.id.length == 0 ? null : new String(this.id));
    }

    public String getType() {
        return this.type.length == 0 ? null : new String(this.type);
    }

    public TypeNameFormat getTypeNameFormat() {
        return this.tnf;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String toString() {
        return "DimeRecord(id='" + new String(this.id) + "', tnf='" + this.tnf + "', type='" + new String(this.type) + "', length=" + this.data.length + ", first=" + this.first + ", last=" + this.last + ")";
    }

    public static final byte[] getBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static class TypeNameFormat {
        public static final TypeNameFormat UNCHANGED = new TypeNameFormat(0);
        public static final TypeNameFormat MEDIA_TYPE = new TypeNameFormat(1);
        public static final TypeNameFormat URI = new TypeNameFormat(2);
        public static final TypeNameFormat UNKNOWN = new TypeNameFormat(3);
        public static final TypeNameFormat NONE = new TypeNameFormat(4);
        private int val;

        private TypeNameFormat(int i) {
            this.val = i;
        }

        public int toInt() {
            return this.val;
        }

        public static TypeNameFormat get(int v) {
            switch (v) {
                case 0: {
                    return UNCHANGED;
                }
                case 1: {
                    return MEDIA_TYPE;
                }
                case 2: {
                    return URI;
                }
                case 3: {
                    return UNKNOWN;
                }
                case 4: {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("unrecognized value: " + v);
        }

        public boolean equals(Object o) {
            return o instanceof TypeNameFormat && ((TypeNameFormat)o).val == this.val;
        }

        public int hashCode() {
            return this.toInt();
        }

        public boolean isUnchanged() {
            return this.val == 0;
        }

        public boolean isMediaType() {
            return this.val == 1;
        }

        public boolean isUri() {
            return this.val == 2;
        }

        public boolean isUnknown() {
            return this.val == 3;
        }

        public boolean isNone() {
            return this.val == 4;
        }

        public String toString() {
            switch (this.val) {
                case 0: {
                    return "unchanged";
                }
                case 1: {
                    return "media_type";
                }
                case 2: {
                    return "uri";
                }
                case 3: {
                    return "unknown";
                }
                case 4: {
                    return "none";
                }
            }
            throw new IllegalStateException("Unknown value");
        }
    }
}

